/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.chat.spy;

import io.github.sakurawald.core.annotation.Document;
import io.github.sakurawald.core.auxiliary.LogUtil;
import io.github.sakurawald.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.core.command.annotation.CommandNode;
import io.github.sakurawald.core.command.annotation.CommandRequirement;
import io.github.sakurawald.core.command.annotation.CommandSource;
import io.github.sakurawald.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.module.initializer.ModuleInitializer;
import io.github.sakurawald.module.initializer.chat.spy.config.model.ChatSpyConfigModel;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7471;

@CommandNode(value="chat spy")
@CommandRequirement(level=4)
public class ChatSpyInitializer
extends ModuleInitializer {
    private static String lastContentString = "";
    public static final BaseConfigurationHandler<ChatSpyConfigModel> config = new ObjectConfigurationHandler<ChatSpyConfigModel>("config.json", ChatSpyConfigModel.class).autoSaveEveryMinute();

    @CommandNode(value="toggle")
    @Document(value="Toggle the chat spy mode.")
    private static int toggle(@CommandSource class_3222 player) {
        ChatSpyConfigModel.PerPlayerOptions options = ChatSpyInitializer.withOptions(player);
        options.enabled = !options.enabled;
        TextHelper.sendMessageByFlag(player, options.enabled);
        return 1;
    }

    private static void ensureOptionsExists(class_3222 player) {
        String key = player.method_7334().getName();
        config.model().getOptions().putIfAbsent(key, new ChatSpyConfigModel.PerPlayerOptions());
    }

    public static ChatSpyConfigModel.PerPlayerOptions withOptions(class_3222 player) {
        ChatSpyInitializer.ensureOptionsExists(player);
        return config.model().getOptions().get(player.method_7334().getName());
    }

    public static void processChatSpy(String messageTypeString, class_3222 receiverPlayer, class_7471 signedMessage, class_2556.class_7602 parameters) {
        LogUtil.debug("Receive a message with message type {}", messageTypeString);
        if (ChatSpyInitializer.config.model().message_type.whitelist.stream().noneMatch(it -> it.matches(messageTypeString))) {
            return;
        }
        class_2561 content = parameters.method_44837(signedMessage.method_46291());
        String contentString = content.getString();
        if (ChatSpyInitializer.config.model().ignore_consecutive_same_text && contentString.equals(lastContentString)) {
            return;
        }
        lastContentString = contentString;
        class_2561 receiverPlayerName = receiverPlayer.method_5476();
        class_5250 notificationText = class_2561.method_43473();
        notificationText.method_10852(content).method_10852(TextHelper.TEXT_SPACE).method_10852(TextHelper.getTextByKey(null, "chat.spy.indicator", new Object[0])).method_10852(TextHelper.TEXT_SPACE).method_10852(receiverPlayerName);
        if (ChatSpyInitializer.config.model().log_console) {
            LogUtil.info(notificationText.getString(), new Object[0]);
        }
        ServerHelper.getPlayers().stream().filter(it -> ChatSpyInitializer.withOptions((class_3222)it).enabled).forEach(it -> it.method_43496((class_2561)notificationText));
    }
}

