/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.chat.style;

import eu.pb4.placeholders.api.parsers.NodeParser;
import io.github.sakurawald.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.core.command.annotation.CommandNode;
import io.github.sakurawald.core.command.annotation.CommandSource;
import io.github.sakurawald.core.command.annotation.CommandTarget;
import io.github.sakurawald.core.command.argument.wrapper.impl.GreedyString;
import io.github.sakurawald.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.core.service.style_striper.StyleStriper;
import io.github.sakurawald.module.initializer.ModuleInitializer;
import io.github.sakurawald.module.initializer.chat.style.model.ChatFormatModel;
import io.github.sakurawald.module.initializer.chat.style.model.ChatStyleConfigModel;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7463;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

@CommandNode(value="chat style")
public class ChatStyleInitializer
extends ModuleInitializer {
    private static final BaseConfigurationHandler<ChatStyleConfigModel> config = new ObjectConfigurationHandler<ChatStyleConfigModel>("config.json", ChatStyleConfigModel.class);
    public static final class_5321<class_2556> MESSAGE_TYPE_KEY = class_5321.method_29179((class_5321)class_7924.field_41237, (class_2960)class_2960.method_43902((String)"fuji", (String)("chat_" + FabricLoader.getInstance().getEnvironmentType().toString().toLowerCase())));
    public static final class_2556 MESSAGE_TYPE_VALUE = new class_2556(class_7463.method_43831((String)"%s%s"), class_7463.method_43831((String)"%s%s"));
    private static final BaseConfigurationHandler<ChatFormatModel> chatFormatData = new ObjectConfigurationHandler<ChatFormatModel>("chat.json", ChatFormatModel.class);
    private static final NodeParser CHAT_STYLE_PARSER = TextHelper.DEFAULT_PARSER;
    private static final String DEFAULT_CONTENT_FORMAT = "%message%";
    private static final String CHAT_STYLE_TYPE = "chat";

    private static String stripeStyleTags(class_3222 player, String string) {
        return StyleStriper.stripe((class_1657)player, CHAT_STYLE_TYPE, string);
    }

    @CommandNode(value="set")
    private static int setPerPlayerFormat(@CommandSource @CommandTarget class_3222 player, GreedyString format) {
        String playerName = PlayerHelper.getName((class_1657)player);
        String newFormat = (String)format.getValue();
        String stripedFormat = newFormat = ChatStyleInitializer.stripeStyleTags(player, newFormat);
        ChatStyleInitializer.chatFormatData.model().format.player2format.put(playerName, newFormat);
        chatFormatData.writeStorage();
        newFormat = TextHelper.getValueByKey(player, "chat.format.set");
        newFormat = newFormat.replace("%s", stripedFormat);
        newFormat = newFormat.replace(DEFAULT_CONTENT_FORMAT, TextHelper.getValueByKey(player, "chat.format.show"));
        class_2561 text = TextHelper.getTextByValue(player, newFormat, new Object[0]);
        player.method_43496(text);
        return 1;
    }

    @CommandNode(value="reset")
    private static int resetPerPlayerFormat(@CommandSource @CommandTarget class_3222 player) {
        String playerName = PlayerHelper.getName((class_1657)player);
        ChatStyleInitializer.chatFormatData.model().format.player2format.remove(playerName);
        chatFormatData.writeStorage();
        TextHelper.sendMessageByKey(player, "chat.format.reset", new Object[0]);
        return 1;
    }

    @NotNull
    public static class_2561 parseSenderText(@NotNull class_3222 player) {
        String senderString = ChatStyleInitializer.config.model().style.sender;
        return TextHelper.getTextByValue(player, senderString, new Object[0]);
    }

    @NotNull
    public static class_2561 parseContentText(@NotNull class_3222 player, String message) {
        String contentString = ChatStyleInitializer.config.model().style.content.formatted(message);
        String playerName = PlayerHelper.getName((class_1657)player);
        contentString = ChatStyleInitializer.chatFormatData.model().format.player2format.getOrDefault(playerName, DEFAULT_CONTENT_FORMAT).replace(DEFAULT_CONTENT_FORMAT, contentString);
        contentString = ChatStyleInitializer.stripeStyleTags(player, contentString);
        return CHAT_STYLE_PARSER.parseNode(contentString).toText();
    }
}

