/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.chat.trigger;

import io.github.sakurawald.core.auxiliary.LogUtil;
import io.github.sakurawald.core.auxiliary.StringUtil;
import io.github.sakurawald.core.command.executor.CommandExecutor;
import io.github.sakurawald.core.command.structure.ExtendedCommandSource;
import io.github.sakurawald.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.module.initializer.ModuleInitializer;
import io.github.sakurawald.module.initializer.chat.trigger.config.model.ChatTriggerConfigModel;
import io.github.sakurawald.module.initializer.chat.trigger.structure.ChatTrigger;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.class_2168;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public class ChatTriggerInitializer
extends ModuleInitializer {
    private static final BaseConfigurationHandler<ChatTriggerConfigModel> config = new ObjectConfigurationHandler<ChatTriggerConfigModel>("config.json", ChatTriggerConfigModel.class);

    public static String processChatTriggers(class_2168 source, String chatString, CallbackInfo ci) {
        LogUtil.debug("Process Chat Triggers: chatString = {}", chatString);
        List<ChatTrigger> triggers = ChatTriggerInitializer.config.model().triggers;
        triggers.stream().filter(it -> chatString.matches(it.regex)).forEach(it -> {
            Matcher matcher = Pattern.compile(it.regex).matcher(chatString);
            matcher.find();
            List commands = it.commands.stream().map(cmd -> StringUtil.replaceGroupsPlaceholders(matcher, cmd)).collect(Collectors.toCollection(ArrayList::new));
            LogUtil.debug("Execute commands {} for {}", commands, it);
            commands.forEach(cmd -> CommandExecutor.execute(ExtendedCommandSource.asConsole(source), cmd));
        });
        return chatString;
    }
}

