/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.command_permission;

import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.context.CommandContextBuilder;
import io.github.sakurawald.core.annotation.Cite;
import io.github.sakurawald.core.annotation.Document;
import io.github.sakurawald.core.auxiliary.LogUtil;
import io.github.sakurawald.core.auxiliary.minecraft.CommandHelper;
import io.github.sakurawald.core.auxiliary.minecraft.PermissionHelper;
import io.github.sakurawald.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.core.command.annotation.CommandNode;
import io.github.sakurawald.core.command.annotation.CommandRequirement;
import io.github.sakurawald.core.command.annotation.CommandSource;
import io.github.sakurawald.core.command.argument.wrapper.impl.GreedyString;
import io.github.sakurawald.core.event.impl.ServerLifecycleEvents;
import io.github.sakurawald.core.structure.CommandNodeWrapper;
import io.github.sakurawald.module.initializer.ModuleInitializer;
import io.github.sakurawald.module.initializer.command_permission.gui.CommandPermissionGui;
import io.github.sakurawald.module.initializer.command_permission.structure.CommandNodePermission;
import io.github.sakurawald.module.initializer.command_permission.structure.WrappedPredicate;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.luckperms.api.util.Tristate;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

@Cite(value={"https://github.com/DrexHD/VanillaPermissions"})
@CommandNode(value="command-permission")
@CommandRequirement(level=4)
public class CommandPermissionInitializer
extends ModuleInitializer {
    private static boolean verboseModeFlag = false;

    @CommandNode(value="gui")
    @Document(value="Open the command permission gui.")
    public static int $gui(@CommandSource class_3222 player) {
        List<CommandNodePermission> entities = CommandHelper.getCommandNodes().stream().map(CommandNodePermission::new).sorted(Comparator.comparing(CommandNodeWrapper::getPath)).toList();
        new CommandPermissionGui(player, entities, 0).open();
        return 1;
    }

    @CommandNode(value="verbose")
    @Document(value="Toggle the command permission verbose mode.")
    public static int $verbose(@CommandSource class_2168 source) {
        verboseModeFlag = !verboseModeFlag;
        TextHelper.sendMessageByKey(source, verboseModeFlag ? "command_permission.verbose.on" : "command_permission.verbose.off", new Object[0]);
        return 1;
    }

    @CommandNode(value="describe")
    @Document(value="Describe the command path and required permissions of a give command.")
    public static int $describe(@CommandSource class_2168 source, GreedyString command) {
        String $command = (String)command.getValue();
        ParseResults parseResults = ServerHelper.getCommandDispatcher().parse($command, (Object)source);
        CommandContextBuilder context = parseResults.getContext();
        String commandString = TextHelper.escapeTags(parseResults.getReader().getString());
        TextHelper.sendMessageByKey(source, "command_permission.describe.command_string", commandString);
        Map exceptions = parseResults.getExceptions();
        if (!exceptions.isEmpty()) {
            TextHelper.sendMessageByKey(source, "command_permission.describe.command_string.parser.exceptions", new Object[0]);
            exceptions.forEach((k, v) -> {
                String nodeName = k.getName();
                String exception = v.toString();
                TextHelper.sendMessageByKey(source, "command_permission.describe.command_string.parser.exception", nodeName, exception);
            });
            return 1;
        }
        List nodes = context.getNodes();
        List<String> nodesName = nodes.stream().map(it -> it.getNode().getName()).toList();
        TextHelper.sendMessageByKey(source, "command_permission.describe.command_node.nodes", nodesName);
        if (nodesName.isEmpty()) {
            TextHelper.sendMessageByKey(source, "command_permission.describe.command_node.empty", new Object[0]);
            return 1;
        }
        nodes.forEach(it -> {
            com.mojang.brigadier.tree.CommandNode node = it.getNode();
            String nodeName = node.getName();
            String nodeType = CommandHelper.getCommandNodeType((com.mojang.brigadier.tree.CommandNode<class_2168>)node);
            boolean nodeWrapped = CommandPermissionInitializer.isCommandNodeWrapped((com.mojang.brigadier.tree.CommandNode<class_2168>)node);
            TextHelper.sendMessageByKey(source, "command_permission.describe.command_node.node", nodeName, nodeType, nodeWrapped);
        });
        String commandPath = CommandHelper.computeCommandNodePath(context.getNodes());
        TextHelper.sendMessageByKey(source, "command_permission.describe.command_path", commandPath);
        TextHelper.sendMessageByKey(source, "command_permission.describe.command_permissions", new Object[0]);
        List<String> commandPathPrefixes = CommandHelper.getCommandPathPrefixes(nodes);
        commandPathPrefixes.forEach(path -> {
            String requiredPermission = CommandPermissionInitializer.computeCommandPermission(path);
            TextHelper.sendMessageByKey(source, "command_permission.describe.command_permission", requiredPermission);
        });
        source.method_45068((class_2561)class_2561.method_43473());
        return 1;
    }

    public static String computeCommandPermission(String commandPath) {
        return "fuji.permission.%s".formatted(commandPath);
    }

    private static void processVerboseMode(class_2168 source, String commandPath, String requiredPermissionToExecuteThisCommand, Tristate state) {
        if (!verboseModeFlag) {
            return;
        }
        String description = CommandPermissionInitializer.makeDescription(state);
        LogUtil.info("\n\u25c9 Command Source: {}\n\u25c9 Command Path of the Target Command: {}\n\u25c9 The permission used by Luckperms to calculate whether the command source can use the target command: {}\n\u25c9 LuckPerms Permission Calculation Result: {}\n\u25c9 Description: {}\n", source.method_9214(), commandPath, requiredPermissionToExecuteThisCommand, state, description);
    }

    @NotNull
    private static String makeDescription(Tristate state) {
        String description = state == Tristate.UNDEFINED ? "The luckperms permission test result is UNDEFINED, it means command_permission module WILL NOT HANDLE this command. We simply fallback the requirement predicate of this command to its original predicate." : (state == Tristate.TRUE ? "The luckperms permission test result is TRUE, it means command_permission module WILL ALLOW the command source to use this command." : (state == Tristate.FALSE ? "The luckperms permission test result is FALSE, it means command_permission module WILL DIS-ALLOW the command source to use this command." : "I don't know why, but the value of Tristate is un-expected."));
        return description;
    }

    @NotNull
    public static WrappedPredicate<class_2168> makeWrappedPredicate(String commandPath, @NotNull Predicate<class_2168> original) {
        return source -> {
            if (source.method_44023() == null) {
                return original.test((class_2168)source);
            }
            try {
                String permission = CommandPermissionInitializer.computeCommandPermission(commandPath);
                Tristate triState = PermissionHelper.getPermission(source.method_44023().method_5667(), permission);
                CommandPermissionInitializer.processVerboseMode(source, commandPath, permission, triState);
                if (triState != Tristate.UNDEFINED) {
                    return triState.asBoolean();
                }
                return original.test((class_2168)source);
            }
            catch (Throwable use_original_predicate_if_failed) {
                return original.test((class_2168)source);
            }
        };
    }

    private static void ensureCommandNodeRequirementIsWrapped() {
        CommandHelper.getCommandNodes().forEach(com.mojang.brigadier.tree.CommandNode::getRequirement);
    }

    public static boolean isCommandNodeWrapped(com.mojang.brigadier.tree.CommandNode<class_2168> commandNode) {
        return commandNode.getRequirement() instanceof WrappedPredicate;
    }

    @Override
    protected void onInitialize() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> CommandPermissionInitializer.ensureCommandNodeRequirementIsWrapped());
    }
}

