/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.fuji;

import com.mojang.brigadier.context.CommandContext;
import io.github.sakurawald.core.annotation.Document;
import io.github.sakurawald.core.auxiliary.minecraft.CommandHelper;
import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.core.command.annotation.CommandNode;
import io.github.sakurawald.core.command.annotation.CommandRequirement;
import io.github.sakurawald.core.command.annotation.CommandSource;
import io.github.sakurawald.core.command.argument.adapter.abst.BaseArgumentTypeAdapter;
import io.github.sakurawald.core.command.processor.CommandAnnotationProcessor;
import io.github.sakurawald.core.command.structure.CommandDescriptor;
import io.github.sakurawald.core.config.Configs;
import io.github.sakurawald.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.core.config.model.ConfigModel;
import io.github.sakurawald.core.gui.CommandDescriptorGui;
import io.github.sakurawald.core.job.abst.BaseJob;
import io.github.sakurawald.core.manager.Managers;
import io.github.sakurawald.core.manager.impl.module.ModuleManager;
import io.github.sakurawald.core.structure.CommandNodeWrapper;
import io.github.sakurawald.core.structure.Pair;
import io.github.sakurawald.module.initializer.ModuleInitializer;
import io.github.sakurawald.module.initializer.fuji.gui.AboutGui;
import io.github.sakurawald.module.initializer.fuji.gui.ArgumentTypeGui;
import io.github.sakurawald.module.initializer.fuji.gui.ConfigurationHandlerGui;
import io.github.sakurawald.module.initializer.fuji.gui.ModulesGui;
import io.github.sakurawald.module.initializer.fuji.gui.RegistryGui;
import io.github.sakurawald.module.initializer.fuji.gui.ServerCommandsGui;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.api.metadata.Person;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7655;
import net.minecraft.class_7923;

@CommandNode(value="fuji")
@CommandRequirement(level=4)
public class FujiInitializer
extends ModuleInitializer {
    @CommandNode(value="reload")
    private static int $reload(@CommandSource CommandContext<class_2168> ctx) {
        Configs.configHandler.readStorage();
        Managers.getModuleManager().reloadModuleInitializers();
        BaseJob.rescheduleAll();
        TextHelper.sendMessageByKey(ctx.getSource(), "reload", new Object[0]);
        return 1;
    }

    @CommandNode(value="about")
    @Document(value="Open fuji about gui.")
    private static int $about(@CommandSource class_3222 player) {
        ModMetadata metadata = ((ModContainer)FabricLoader.getInstance().getModContainer("fuji").orElseThrow(() -> new IllegalStateException("failed to get the metadata of this mod."))).getMetadata();
        ArrayList<Person> persons = new ArrayList<Person>();
        persons.addAll(metadata.getAuthors());
        persons.addAll(metadata.getContributors());
        new AboutGui(player, persons, 0).open();
        return 1;
    }

    @CommandNode(value="debug")
    @Document(value="Switch the `log_debug_message` option.")
    private static int debug(@CommandSource class_2168 source) {
        ConfigModel.Core.Debug debug = Configs.configHandler.model().core.debug;
        debug.log_debug_messages = !debug.log_debug_messages;
        TextHelper.sendMessageByFlag(source, debug.log_debug_messages);
        return 1;
    }

    @CommandNode(value="inspect server-commands")
    @Document(value="Inspect all commands registered in server.")
    private static int $listServerCommands(@CommandSource class_3222 player) {
        List<CommandNodeWrapper> entities = CommandHelper.getCommandNodes().stream().map(CommandNodeWrapper::new).sorted(Comparator.comparing(CommandNodeWrapper::getPath)).toList();
        new ServerCommandsGui(player, entities, 0).open();
        return 1;
    }

    @CommandNode(value="inspect modules")
    @Document(value="Inspect all enabled/disabled modules of fuji.")
    private static int $listModules(@CommandSource class_3222 player) {
        List<Pair<String, Boolean>> list = Managers.getModuleManager().getModule2enable().entrySet().stream().map(it -> new Pair<String, Boolean>(ModuleManager.joinModulePath((List)it.getKey()), (Boolean)it.getValue())).sorted(Comparator.comparing(Pair::getKey)).toList();
        new ModulesGui(player, list, 0).open();
        return 1;
    }

    @CommandNode(value="inspect fuji-commands")
    @Document(value="Inspect all commands registered by fuji.")
    private static int $listFujiCommands(@CommandSource class_3222 player) {
        List<CommandDescriptor> descriptors = CommandAnnotationProcessor.descriptors.stream().sorted(Comparator.comparing(CommandDescriptor::getCommandNodePath)).toList();
        new CommandDescriptorGui(player, descriptors, 0).open();
        return 1;
    }

    @CommandNode(value="inspect argument-types")
    @Document(value="Inspect all argument types registered by fuji.")
    private static int listCommandArgumentType(@CommandSource CommandContext<class_2168> ctx) {
        List<BaseArgumentTypeAdapter> adapters = BaseArgumentTypeAdapter.getAdapters();
        if (((class_2168)ctx.getSource()).method_43737()) {
            new ArgumentTypeGui(((class_2168)ctx.getSource()).method_44023(), adapters, 0).open();
        } else {
            adapters.forEach(adapter -> adapter.getTypeStrings().forEach(typeString -> {
                String typeClass = adapter.getTypeClasses().get(0).getSimpleName();
                String string2types = "%s -> %s".formatted(typeString, typeClass);
                ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)string2types));
            }));
        }
        return 1;
    }

    @CommandNode(value="inspect configurations")
    @Document(value="Inspect all loaded configurations files.")
    private static int listConfiguration(@CommandSource class_3222 player) {
        List<BaseConfigurationHandler<?>> list = BaseConfigurationHandler.handlers.stream().filter(it -> it instanceof ObjectConfigurationHandler).sorted(Comparator.comparing(BaseConfigurationHandler::getPath)).toList();
        new ConfigurationHandlerGui(null, player, list, 0).open();
        return 1;
    }

    @CommandNode(value="inspect registry")
    @Document(value="Inspect all registries in server.")
    private static int listRegistry(@CommandSource class_3222 player) {
        List<class_2960> staticRegistries = class_7923.field_41167.method_42021().stream().map(class_5321::method_29177).toList();
        List<class_2960> dynamicRegistries = class_7655.field_39968.stream().map(it -> it.comp_985().method_29177()).toList();
        ArrayList<class_2960> identifiers = new ArrayList<class_2960>();
        identifiers.addAll(staticRegistries);
        identifiers.addAll(dynamicRegistries);
        identifiers.sort(Comparator.comparing(class_2960::toString));
        new RegistryGui(null, player, true, identifiers, 0).open();
        return 1;
    }
}

