/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.skin.structure;

import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import io.github.sakurawald.core.annotation.Cite;
import io.github.sakurawald.core.auxiliary.LogUtil;
import io.github.sakurawald.core.auxiliary.minecraft.EntityHelper;
import io.github.sakurawald.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.module.initializer.skin.structure.SkinStorage;
import it.unimi.dsi.fastutil.Pair;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_2596;
import net.minecraft.class_2604;
import net.minecraft.class_2632;
import net.minecraft.class_2703;
import net.minecraft.class_2716;
import net.minecraft.class_2724;
import net.minecraft.class_2735;
import net.minecraft.class_2739;
import net.minecraft.class_2748;
import net.minecraft.class_2752;
import net.minecraft.class_2777;
import net.minecraft.class_2783;
import net.minecraft.class_3222;
import net.minecraft.class_7828;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

@Cite(value={"https://github.com/Suiranoil/SkinRestorer"})
public class SkinRestorer {
    private static final SkinStorage skinStorage = new SkinStorage();

    public static CompletableFuture<Pair<Collection<class_3222>, Collection<GameProfile>>> setSkinAsync(@NotNull MinecraftServer server, @NotNull Collection<GameProfile> targets, @NotNull Supplier<Property> skinSupplier) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            HashSet<GameProfile> acceptedProfiles = new HashSet<GameProfile>();
            Property skin = (Property)skinSupplier.get();
            LogUtil.debug("skinSupplier.get() -> skin = {}", skin);
            if (skin == null) {
                LogUtil.debug("Can not get the skin for {}", ((GameProfile)targets.stream().findFirst().orElseThrow()).getName());
                return Pair.of(null, Collections.emptySet());
            }
            for (GameProfile profile : targets) {
                SkinRestorer.getSkinStorage().setSkin(profile.getId(), skin);
                acceptedProfiles.add(profile);
            }
            return Pair.of((Object)skin, acceptedProfiles);
        }).thenApplyAsync(pair -> {
            Property skin = (Property)pair.left();
            if (skin == null) {
                return Pair.of(Collections.emptySet(), Collections.emptySet());
            }
            Collection acceptedProfiles = (Collection)pair.right();
            HashSet<class_3222> acceptedPlayers = new HashSet<class_3222>();
            JsonObject newSkinJson = (JsonObject)BaseConfigurationHandler.getGson().fromJson(new String(Base64.getDecoder().decode(PlayerHelper.getPropertyValue(skin)), StandardCharsets.UTF_8), JsonObject.class);
            newSkinJson.remove("timestamp");
            for (GameProfile profile : acceptedProfiles) {
                class_3222 player = server.method_3760().method_14602(profile.getId());
                if (player == null || SkinRestorer.arePropertiesEquals(newSkinJson, player.method_7334())) continue;
                SkinRestorer.applySkin(player.method_7334(), skin);
                for (class_3222 observer : EntityHelper.getServerWorld((class_1297)player).method_18456()) {
                    observer.field_13987.method_14364((class_2596)new class_7828(Collections.singletonList(player.method_5667())));
                    observer.field_13987.method_14364((class_2596)new class_2703(class_2703.class_5893.field_29136, player));
                    if (player != observer && observer.method_6057((class_1297)player)) {
                        observer.field_13987.method_14364((class_2596)new class_2716(new int[]{player.method_5628()}));
                        observer.field_13987.method_14364((class_2596)new class_2604((class_1297)player, 0, player.method_24515()));
                        observer.field_13987.method_14364((class_2596)new class_2777((class_1297)player));
                        observer.field_13987.method_14364((class_2596)new class_2739(player.method_5628(), player.method_5841().method_46357()));
                        observer.field_13987.method_14364((class_2596)new class_2752((class_1297)player));
                        continue;
                    }
                    if (player != observer) continue;
                    observer.field_13987.method_14364((class_2596)new class_2724(player.method_52374(EntityHelper.getServerWorld((class_1297)player)), 2));
                    observer.field_13987.method_14363(observer.method_23317(), observer.method_23318(), observer.method_23321(), observer.method_36454(), observer.method_36455());
                    observer.field_13987.method_14364((class_2596)new class_2632(EntityHelper.getServerWorld((class_1297)observer).method_8407(), EntityHelper.getServerWorld((class_1297)player).method_8401().method_197()));
                    observer.field_13987.method_14364((class_2596)new class_2735(observer.method_31548().field_7545));
                    observer.method_7355();
                    observer.field_7498.method_37420();
                    for (class_1293 instance : observer.method_6026()) {
                        observer.field_13987.method_14364((class_2596)new class_2783(observer.method_5628(), instance, false));
                    }
                    observer.field_13987.method_14364((class_2596)new class_2739(player.method_5628(), player.method_5841().method_46357()));
                    observer.field_13987.method_14364((class_2596)new class_2748(player.field_7510, player.field_7495, player.field_7520));
                    observer.field_13987.method_14364((class_2596)new class_2752((class_1297)observer));
                }
                acceptedPlayers.add(player);
            }
            return Pair.of(acceptedPlayers, (Object)acceptedProfiles);
        }, (Executor)server)).orTimeout(10L, TimeUnit.SECONDS).exceptionally(e -> Pair.of(Collections.emptySet(), Collections.emptySet()));
    }

    public static void applySkin(@NotNull GameProfile gameProfile, Property skin) {
        gameProfile.getProperties().removeAll((Object)"textures");
        gameProfile.getProperties().put((Object)"textures", (Object)skin);
    }

    private static boolean arePropertiesEquals(@NotNull JsonObject x, @NotNull GameProfile y) {
        Property py = y.getProperties().get((Object)"textures").stream().findFirst().orElse(null);
        if (py == null) {
            return false;
        }
        try {
            JsonObject jy = (JsonObject)BaseConfigurationHandler.getGson().fromJson(new String(Base64.getDecoder().decode(PlayerHelper.getPropertyValue(py)), StandardCharsets.UTF_8), JsonObject.class);
            jy.remove("timestamp");
            return x.equals((Object)jy);
        }
        catch (Exception ex) {
            LogUtil.error("Can not compare skin", ex);
            return false;
        }
    }

    public static SkinStorage getSkinStorage() {
        return skinStorage;
    }
}

