/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.top_chunks.structure;

import io.github.sakurawald.core.auxiliary.minecraft.PermissionHelper;
import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.core.manager.Managers;
import io.github.sakurawald.core.structure.SpatialPose;
import io.github.sakurawald.core.structure.TypeFormatter;
import io.github.sakurawald.module.initializer.top_chunks.TopChunksInitializer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class ChunkScore
implements Comparable<ChunkScore> {
    private final HashMap<String, Integer> type2amount = new HashMap();
    private final class_3218 dimension;
    private final class_1923 chunkPos;
    private final List<String> players = new ArrayList<String>();
    private int score;

    public ChunkScore(class_3218 dimension, class_1923 chunkPos) {
        this.dimension = dimension;
        this.chunkPos = chunkPos;
    }

    public static boolean hasPermissionToClickToTeleport(@NotNull class_3222 player) {
        return player.method_5687(4) || PermissionHelper.hasPermission(player.method_5667(), "top_chunks.teleport");
    }

    public void plusEntity(@NotNull class_1297 entity) {
        String type = entity.method_5864().method_5882();
        this.type2amount.putIfAbsent(type, 0);
        this.type2amount.put(type, this.type2amount.get(type) + 1);
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            this.players.add(player.method_7334().getName());
        }
    }

    public void plusBlockEntity(@NotNull class_2586 blockEntity) {
        String type = blockEntity.method_11010().method_26204().method_9539();
        this.type2amount.putIfAbsent(type, 0);
        this.type2amount.put(type, this.type2amount.get(type) + 1);
    }

    public void sum() {
        this.score = 0;
        for (String type : this.type2amount.keySet()) {
            HashMap<String, Integer> type2score = TopChunksInitializer.config.model().type2score;
            this.score += type2score.getOrDefault(type, type2score.get("default")) * this.type2amount.get(type);
        }
    }

    @NotNull
    public String toString() {
        return String.format("%-5d", this.score);
    }

    @Override
    public int compareTo(@NotNull ChunkScore that) {
        return Integer.compare(that.score, this.score);
    }

    @NotNull
    public class_2561 asText(@NotNull class_2168 source) {
        String chunkLocation;
        if (TopChunksInitializer.config.model().hide_location) {
            chunkLocation = TextHelper.getValueByKey(source, "top_chunks.prop.hidden");
            if (source.method_9259(4)) {
                chunkLocation = TextHelper.getValueByKey(source, "top_chunks.prop.hidden.bypass", this.getChunkPos().toString());
            }
        } else {
            chunkLocation = this.getChunkPos().toString();
        }
        class_5250 hoverText = class_2561.method_43473().method_27692(class_124.field_1065).method_10852(TextHelper.getTextByKey(source, "top_chunks.prop.dimension", this.dimension.method_27983().method_29177())).method_10852(TextHelper.TEXT_NEWLINE).method_10852(TextHelper.getTextByKey(source, "top_chunks.prop.chunk", chunkLocation)).method_10852(TextHelper.TEXT_NEWLINE).method_10852(TextHelper.getTextByKey(source, "top_chunks.prop.score", this.score)).method_10852(TextHelper.TEXT_NEWLINE).method_10852(TextHelper.getTextByKey(source, "top_chunks.prop.players", this.players)).method_10852(TextHelper.TEXT_NEWLINE).method_10852(TypeFormatter.formatTypes(source, this.type2amount));
        return class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)this.toString())).method_27696(class_2583.field_24360.method_10949(TextHelper.HoverEvent.makeShowTextAction((class_2561)hoverText)).method_27706(this.players.isEmpty() ? class_124.field_1080 : class_124.field_1077).method_10958(Managers.getCallbackManager().makeCallbackEvent(player -> {
            if (!ChunkScore.hasPermissionToClickToTeleport(player)) {
                return;
            }
            class_2338 blockPos = new class_2338(this.chunkPos.method_33940(), 128, this.chunkPos.method_33942());
            int y = this.dimension.method_8598(class_2902.class_2903.field_13197, blockPos).method_10264();
            if (y == -64) {
                y = 128;
            }
            new SpatialPose((class_1937)this.dimension, (double)blockPos.method_10263(), (double)y, (double)blockPos.method_10260(), player.method_36454(), player.method_36455()).teleport((class_3222)player);
        }, 5L, TimeUnit.MINUTES)));
    }

    public class_3218 getDimension() {
        return this.dimension;
    }

    public class_1923 getChunkPos() {
        return this.chunkPos;
    }

    public List<String> getPlayers() {
        return this.players;
    }

    public int getScore() {
        return this.score;
    }
}

