/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.works.structure.work.abst;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.gui.SimpleGui;
import io.github.sakurawald.core.auxiliary.ChronosUtil;
import io.github.sakurawald.core.auxiliary.minecraft.EntityHelper;
import io.github.sakurawald.core.auxiliary.minecraft.GuiHelper;
import io.github.sakurawald.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.core.auxiliary.minecraft.StackHelper;
import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.core.gui.ConfirmGui;
import io.github.sakurawald.core.gui.InputSignGui;
import io.github.sakurawald.module.initializer.works.WorksInitializer;
import io.github.sakurawald.module.initializer.works.structure.work.impl.NonProductionWork;
import io.github.sakurawald.module.initializer.works.structure.work.impl.ProductionWork;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Work {
    public String type;
    public String id;
    public long createTimeMS;
    public String creator;
    public String name;
    @Nullable
    public String introduction;
    public String level;
    public double x;
    public double y;
    public double z;
    public float yaw;
    public float pitch;
    @Nullable
    public String icon;

    public Work(@NotNull class_3222 player, String name) {
        this.type = this.getType();
        this.id = this.generateID();
        this.createTimeMS = System.currentTimeMillis();
        this.creator = player.method_7334().getName();
        this.name = name;
        this.introduction = null;
        this.level = player.method_37908().method_27983().method_29177().toString();
        this.x = player.method_19538().field_1352;
        this.y = player.method_19538().field_1351;
        this.z = player.method_19538().field_1350;
        this.yaw = player.method_36454();
        this.pitch = player.method_36455();
        this.icon = null;
    }

    @Nullable
    private static Work getWorkByID(String uuid) {
        return WorksInitializer.works.model().works.stream().filter(it -> it.getId().equals(uuid)).findFirst().orElse(null);
    }

    protected abstract String getType();

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Work work = (Work)o;
        return this.id.equals(work.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    protected abstract String getDefaultIconItemIdentifier();

    public void onSchedule() {
    }

    public abstract void openSpecializedSettingsGui(class_3222 var1, SimpleGui var2);

    public void openGeneralSettingsGui(@NotNull class_3222 player, @NotNull SimpleGui parentGui) {
        final Work work = this;
        SimpleGui gui = new SimpleGui(class_3917.field_18664, player, false);
        gui.setLockPlayerInventory(true);
        gui.setTitle(TextHelper.getTextByKey(player, "works.work.set.general_settings.title", new Object[0]));
        gui.addSlot(new GuiElementBuilder().setItem(class_1802.field_8448).setName(TextHelper.getTextByKey(player, "works.work.set.target.name", new Object[0])).setCallback(() -> new InputSignGui(this, player, null){

            public void onClose() {
                String newValue = this.reduceInput();
                if (newValue == null) {
                    TextHelper.sendActionBarByKey(this.player, "works.work.add.empty_name", new Object[0]);
                    return;
                }
                work.name = newValue;
                TextHelper.sendMessageByKey(this.player, "works.work.set.done", work.name);
            }
        }.open()));
        gui.addSlot(new GuiElementBuilder().setItem(class_1802.field_42708).setName(TextHelper.getTextByKey(player, "works.work.set.target.introduction", new Object[0])).setCallback(() -> new InputSignGui(this, player, null){

            public void onClose() {
                work.introduction = this.reduceInput();
                TextHelper.sendMessageByKey(this.player, "works.work.set.done", work.introduction);
            }
        }.open()));
        gui.addSlot(new GuiElementBuilder().setItem(class_1802.field_8827).setName(TextHelper.getTextByKey(player, "works.work.set.target.position", new Object[0])).setCallback(() -> {
            work.level = EntityHelper.getServerWorld((class_1297)player).method_27983().method_29177().toString();
            work.x = player.method_19538().field_1352;
            work.y = player.method_19538().field_1351;
            work.z = player.method_19538().field_1350;
            TextHelper.sendMessageByKey(player, "works.work.set.done", "(%s, %f, %f, %f)".formatted(work.level, work.x, work.y, work.z));
            gui.close();
        }));
        gui.addSlot(new GuiElementBuilder().setItem(class_1802.field_8892).setName(TextHelper.getTextByKey(player, "works.work.set.target.icon", new Object[0])).setCallback(() -> {
            class_1799 mainHandItem = player.method_6047();
            if (mainHandItem.method_7960()) {
                TextHelper.sendActionBarByKey(player, "works.work.set.target.icon.no_item", new Object[0]);
                gui.close();
                return;
            }
            work.icon = class_7923.field_41178.method_10221((Object)mainHandItem.method_7909()).toString();
            TextHelper.sendMessageByKey(player, "works.work.set.done", work.icon);
            gui.close();
        }));
        gui.addSlot(new GuiElementBuilder().setItem(class_1802.field_8077).setName(TextHelper.getTextByKey(player, "works.work.set.target.delete", new Object[0])).setCallback(() -> new ConfirmGui(this, player){

            @Override
            public void onConfirm() {
                WorksInitializer.works.model().works.remove(work);
                TextHelper.sendActionBarByKey(this.player, "works.work.delete.done", new Object[0]);
            }
        }.open()));
        gui.setSlot(8, GuiHelper.makePreviousPageButton(player).setCallback(() -> ((SimpleGui)parentGui).open()));
        gui.open();
    }

    public class_1792 getIconItem() {
        class_2487 rootTag = new class_2487();
        rootTag.method_10582("id", this.getIconItemIdentifier());
        rootTag.method_10569("Count", 1);
        Optional<class_1799> itemStack = StackHelper.fromNbt((class_7225.class_7874)ServerHelper.getServer().method_30611(), (class_2520)rootTag);
        if (itemStack.isEmpty()) {
            return class_1802.field_8077;
        }
        return itemStack.get().method_7909();
    }

    @NotNull
    public String getIconItemIdentifier() {
        return this.icon == null ? this.getDefaultIconItemIdentifier() : this.icon;
    }

    public List<class_2561> asLore(class_3222 player) {
        ArrayList<class_2561> ret = new ArrayList<class_2561>();
        ret.add(TextHelper.getTextByKey(player, "works.work.prop.creator", this.creator));
        if (this.introduction != null) {
            ret.add(TextHelper.getTextByKey(player, "works.work.prop.introduction", this.introduction));
        }
        ret.add(TextHelper.getTextByKey(player, "works.work.prop.time", ChronosUtil.toStandardDateFormat(this.createTimeMS)));
        ret.add(TextHelper.getTextByKey(player, "works.work.prop.dimension", this.level));
        ret.add(TextHelper.getTextByKey(player, "works.work.prop.coordinate", this.x, this.y, this.z));
        return ret;
    }

    @NotNull
    private String generateID() {
        String ret = null;
        while (ret == null || Work.getWorkByID(ret) != null) {
            ret = UUID.randomUUID().toString().substring(0, 8);
        }
        return ret;
    }

    public Work() {
    }

    public String getId() {
        return this.id;
    }

    public long getCreateTimeMS() {
        return this.createTimeMS;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getIntroduction() {
        return this.introduction;
    }

    public String getLevel() {
        return this.level;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    @Nullable
    public String getIcon() {
        return this.icon;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setCreateTimeMS(long createTimeMS) {
        this.createTimeMS = createTimeMS;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setIntroduction(@Nullable String introduction) {
        this.introduction = introduction;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public void setYaw(float yaw) {
        this.yaw = yaw;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    public void setIcon(@Nullable String icon) {
        this.icon = icon;
    }

    public String toString() {
        return "Work(type=" + this.getType() + ", id=" + this.getId() + ", createTimeMS=" + this.getCreateTimeMS() + ", creator=" + this.getCreator() + ", name=" + this.getName() + ", introduction=" + this.getIntroduction() + ", level=" + this.getLevel() + ", x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", yaw=" + this.getYaw() + ", pitch=" + this.getPitch() + ", icon=" + this.getIcon() + ")";
    }

    public static class WorkTypeAdapter
    implements JsonDeserializer<Work> {
        @Nullable
        public Work deserialize(@NotNull JsonElement json, Type typeOfT, @NotNull JsonDeserializationContext context) throws JsonParseException {
            String type = json.getAsJsonObject().get("type").getAsString();
            if (type.equals(WorkType.NonProductionWork.name())) {
                return (Work)context.deserialize(json, NonProductionWork.class);
            }
            if (type.equals(WorkType.ProductionWork.name())) {
                return (Work)context.deserialize(json, ProductionWork.class);
            }
            return null;
        }
    }

    public static enum WorkType {
        NonProductionWork,
        ProductionWork;

    }
}

