/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.mixin.chat.history;

import com.google.common.collect.EvictingQueue;
import io.github.sakurawald.core.auxiliary.minecraft.RegistryHelper;
import io.github.sakurawald.module.initializer.chat.history.ChatHistoryInitializer;
import java.util.Queue;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_3244;
import net.minecraft.class_7471;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3244.class})
public abstract class StoreChatHistoryMixin {
    @Unique
    private static final Queue<Long> DUPLICATED_SENT_TEXT_FILTER = EvictingQueue.create((int)10);

    @Unique
    private long getUniqueKey(class_7471 signedMessage) {
        return signedMessage.method_44865();
    }

    @Inject(method={"sendChatMessage"}, at={@At(value="TAIL")})
    void storeChatHistoryWhenSentMessage(class_7471 signedMessage, class_2556.class_7602 parameters, CallbackInfo ci) {
        long uniqueKey = this.getUniqueKey(signedMessage);
        if (!DUPLICATED_SENT_TEXT_FILTER.contains(uniqueKey)) {
            String parametersString;
            DUPLICATED_SENT_TEXT_FILTER.add(uniqueKey);
            String messageTypeString = RegistryHelper.getMessageTypeAsString(parameters);
            if (!ChatHistoryInitializer.isMessageTypeFiltered(messageTypeString)) {
                return;
            }
            String contentString = signedMessage.method_46291().getString();
            if (ChatHistoryInitializer.isMessageRejected(contentString, parametersString = parameters.toString())) {
                return;
            }
            class_2561 decoratedTextAsTheClientSideDo = parameters.method_44837(signedMessage.method_46291());
            ChatHistoryInitializer.getChatHistory().add(decoratedTextAsTheClientSideDo);
        }
    }
}

