/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.command.suggestion.structure;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import lombok.Generated;
import mod.fuji.core.auxiliary.AsyncUtil;
import mod.fuji.core.document.annotation.TestCase;
import net.minecraft.class_2168;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposedCommandSuggestionsProvider
implements SuggestionProvider<class_2168> {
    @NotNull
    private final ArgumentType<?> argumentType;
    @Nullable
    private final SuggestionProvider<class_2168> originalCustomSuggestionsProvider;
    @NotNull
    private final BiConsumer<CommandContext<class_2168>, SuggestionsBuilder> onAskServerSideCommandSuggestionsHook;

    @TestCase(action="Test the command suggestion functionality.", targets={"Issue `/command-attachment attach-entity-one <uuid>` command, it should suggest the looking at entity UUID.", "Issue `/command-attachment attach-entity-one @e[type` command, it should be able to `insert` the suggestion content in the proper position. (non-zero-offset suggestions builder)", "Issue `/command-attachment attach-entity-one <uuid>` command, it should be able to `insert` the suggestion content in the proper position. (zero-offset suggestions builder)", "Issue `/command-attachment attach-block-one ` command, it should filter out the duplicated suggestions. (client-side suggestions and server-side suggestions)"})
    @NotNull
    public CompletableFuture<Suggestions> getSuggestions(@NotNull CommandContext<class_2168> context, @NotNull SuggestionsBuilder builder) throws CommandSyntaxException {
        AsyncUtil.runAsyncAndHandleExceptions(() -> this.onAskServerSideCommandSuggestionsHook.accept(context, builder));
        CompletableFuture firstFuture = this.argumentType.listSuggestions(context, builder);
        CompletableFuture secondFuture = this.originalCustomSuggestionsProvider != null ? this.originalCustomSuggestionsProvider.getSuggestions(context, builder) : Suggestions.empty();
        return firstFuture.thenCombine((CompletionStage)secondFuture, (firstValue, secondValue) -> {
            StringRange composedStringRange = ComposedCommandSuggestionsProvider.composeStringRange(builder, firstValue, secondValue);
            List firstSuggestionList = firstValue.getList();
            List secondSuggestionList = secondValue.getList();
            HashSet uniqueSuggestions = new HashSet();
            uniqueSuggestions.addAll(firstSuggestionList);
            uniqueSuggestions.addAll(secondSuggestionList);
            return new Suggestions(composedStringRange, new ArrayList(uniqueSuggestions));
        });
    }

    @NotNull
    private static StringRange composeStringRange(@NotNull SuggestionsBuilder builder, @NotNull Suggestions first, @NotNull Suggestions second) {
        StringRange firstRange = first.getRange();
        StringRange secondRange = second.getRange();
        if (firstRange.getStart() != 0 && firstRange.getEnd() != 0) {
            return firstRange;
        }
        if (secondRange.getStart() != 0 && secondRange.getEnd() != 0) {
            return secondRange;
        }
        return StringRange.at((int)builder.getStart());
    }

    @Generated
    public ComposedCommandSuggestionsProvider(@NotNull ArgumentType<?> argumentType, @Nullable SuggestionProvider<class_2168> originalCustomSuggestionsProvider, @NotNull BiConsumer<CommandContext<class_2168>, SuggestionsBuilder> onAskServerSideCommandSuggestionsHook) {
        if (argumentType == null) {
            throw new NullPointerException("argumentType is marked non-null but is null");
        }
        if (onAskServerSideCommandSuggestionsHook == null) {
            throw new NullPointerException("onAskServerSideCommandSuggestionsHook is marked non-null but is null");
        }
        this.argumentType = argumentType;
        this.originalCustomSuggestionsProvider = originalCustomSuggestionsProvider;
        this.onAskServerSideCommandSuggestionsHook = onAskServerSideCommandSuggestionsHook;
    }

    @NotNull
    @Generated
    public ArgumentType<?> getArgumentType() {
        return this.argumentType;
    }

    @Nullable
    @Generated
    public SuggestionProvider<class_2168> getOriginalCustomSuggestionsProvider() {
        return this.originalCustomSuggestionsProvider;
    }

    @NotNull
    @Generated
    public BiConsumer<CommandContext<class_2168>, SuggestionsBuilder> getOnAskServerSideCommandSuggestionsHook() {
        return this.onAskServerSideCommandSuggestionsHook;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComposedCommandSuggestionsProvider)) {
            return false;
        }
        ComposedCommandSuggestionsProvider other = (ComposedCommandSuggestionsProvider)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ArgumentType<?> this$argumentType = this.getArgumentType();
        ArgumentType<?> other$argumentType = other.getArgumentType();
        if (this$argumentType == null ? other$argumentType != null : !this$argumentType.equals(other$argumentType)) {
            return false;
        }
        SuggestionProvider<class_2168> this$originalCustomSuggestionsProvider = this.getOriginalCustomSuggestionsProvider();
        SuggestionProvider<class_2168> other$originalCustomSuggestionsProvider = other.getOriginalCustomSuggestionsProvider();
        if (this$originalCustomSuggestionsProvider == null ? other$originalCustomSuggestionsProvider != null : !this$originalCustomSuggestionsProvider.equals(other$originalCustomSuggestionsProvider)) {
            return false;
        }
        BiConsumer<CommandContext<class_2168>, SuggestionsBuilder> this$onAskServerSideCommandSuggestionsHook = this.getOnAskServerSideCommandSuggestionsHook();
        BiConsumer<CommandContext<class_2168>, SuggestionsBuilder> other$onAskServerSideCommandSuggestionsHook = other.getOnAskServerSideCommandSuggestionsHook();
        return !(this$onAskServerSideCommandSuggestionsHook == null ? other$onAskServerSideCommandSuggestionsHook != null : !this$onAskServerSideCommandSuggestionsHook.equals(other$onAskServerSideCommandSuggestionsHook));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ComposedCommandSuggestionsProvider;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ArgumentType<?> $argumentType = this.getArgumentType();
        result = result * 59 + ($argumentType == null ? 43 : $argumentType.hashCode());
        SuggestionProvider<class_2168> $originalCustomSuggestionsProvider = this.getOriginalCustomSuggestionsProvider();
        result = result * 59 + ($originalCustomSuggestionsProvider == null ? 43 : $originalCustomSuggestionsProvider.hashCode());
        BiConsumer<CommandContext<class_2168>, SuggestionsBuilder> $onAskServerSideCommandSuggestionsHook = this.getOnAskServerSideCommandSuggestionsHook();
        result = result * 59 + ($onAskServerSideCommandSuggestionsHook == null ? 43 : $onAskServerSideCommandSuggestionsHook.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ComposedCommandSuggestionsProvider(argumentType=" + String.valueOf(this.getArgumentType()) + ", originalCustomSuggestionsProvider=" + String.valueOf(this.getOriginalCustomSuggestionsProvider()) + ", onAskServerSideCommandSuggestionsHook=" + String.valueOf(this.getOnAskServerSideCommandSuggestionsHook()) + ")";
    }
}

