/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.config.constraint;

import java.util.Optional;
import lombok.Generated;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.command.exception.AbortCommandExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringConstraints {
    private int maxLength;
    @Nullable
    private String acceptStringPattern;
    @Nullable
    private String rejectStringPattern;

    @Nullable
    public String apply(@Nullable String value, @NotNull Object audience) {
        if (value == null) {
            return null;
        }
        if (value.length() > this.maxLength) {
            TextHelper.sendTextByKey(audience, "constraint.length.overflow", TextHelper.Parsers.escapeTags(value));
            throw new AbortCommandExecutionException();
        }
        Optional.ofNullable(this.acceptStringPattern).ifPresent($acceptStringPattern -> {
            if (!value.matches((String)$acceptStringPattern)) {
                TextHelper.sendTextByKey(audience, "constraint.pattern.matcher.accept.failed", TextHelper.Parsers.escapeTags(value));
                throw new AbortCommandExecutionException();
            }
        });
        Optional.ofNullable(this.rejectStringPattern).ifPresent($rejectStringPattern -> {
            if (value.matches((String)$rejectStringPattern)) {
                TextHelper.sendTextByKey(audience, "constraint.pattern.matcher.reject.failed", TextHelper.Parsers.escapeTags(value));
                throw new AbortCommandExecutionException();
            }
        });
        return value;
    }

    @Generated
    public int getMaxLength() {
        return this.maxLength;
    }

    @Nullable
    @Generated
    public String getAcceptStringPattern() {
        return this.acceptStringPattern;
    }

    @Nullable
    @Generated
    public String getRejectStringPattern() {
        return this.rejectStringPattern;
    }

    @Generated
    public StringConstraints setMaxLength(int maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    @Generated
    public StringConstraints setAcceptStringPattern(@Nullable String acceptStringPattern) {
        this.acceptStringPattern = acceptStringPattern;
        return this;
    }

    @Generated
    public StringConstraints setRejectStringPattern(@Nullable String rejectStringPattern) {
        this.rejectStringPattern = rejectStringPattern;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StringConstraints)) {
            return false;
        }
        StringConstraints other = (StringConstraints)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxLength() != other.getMaxLength()) {
            return false;
        }
        String this$acceptStringPattern = this.getAcceptStringPattern();
        String other$acceptStringPattern = other.getAcceptStringPattern();
        if (this$acceptStringPattern == null ? other$acceptStringPattern != null : !this$acceptStringPattern.equals(other$acceptStringPattern)) {
            return false;
        }
        String this$rejectStringPattern = this.getRejectStringPattern();
        String other$rejectStringPattern = other.getRejectStringPattern();
        return !(this$rejectStringPattern == null ? other$rejectStringPattern != null : !this$rejectStringPattern.equals(other$rejectStringPattern));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StringConstraints;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxLength();
        String $acceptStringPattern = this.getAcceptStringPattern();
        result = result * 59 + ($acceptStringPattern == null ? 43 : $acceptStringPattern.hashCode());
        String $rejectStringPattern = this.getRejectStringPattern();
        result = result * 59 + ($rejectStringPattern == null ? 43 : $rejectStringPattern.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "StringConstraints(maxLength=" + this.getMaxLength() + ", acceptStringPattern=" + this.getAcceptStringPattern() + ", rejectStringPattern=" + this.getRejectStringPattern() + ")";
    }

    @Generated
    public StringConstraints() {
    }

    @Generated
    public StringConstraints(int maxLength, @Nullable String acceptStringPattern, @Nullable String rejectStringPattern) {
        this.maxLength = maxLength;
        this.acceptStringPattern = acceptStringPattern;
        this.rejectStringPattern = rejectStringPattern;
    }
}

