/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.chat.trigger;

import java.util.List;
import java.util.regex.Matcher;
import mod.fuji.core.auxiliary.LogUtil;
import mod.fuji.core.auxiliary.StringUtil;
import mod.fuji.core.auxiliary.minecraft.CommandHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.command.executor.CommandExecutor;
import mod.fuji.core.command.executor.structure.ExtendedCommandSource;
import mod.fuji.core.config.handler.abst.BaseConfigurationHandler;
import mod.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import mod.fuji.core.document.annotation.ColorBox;
import mod.fuji.core.document.annotation.ColorBoxes;
import mod.fuji.core.document.annotation.Document;
import mod.fuji.core.event.annotation.EventConsumer;
import mod.fuji.core.event.message.player.PlayerChatMessagePostEvent;
import mod.fuji.module.initializer.ModuleInitializer;
import mod.fuji.module.initializer.chat.trigger.config.model.ChatTriggerConfigModel;
import net.minecraft.class_2168;
import net.minecraft.class_7471;
import org.jetbrains.annotations.NotNull;

@Document(id=1751826730890L, value="This module allows defining `magic spells` in chat that `execute commands`.\n")
@ColorBoxes(value={@ColorBox(id=1754612494551L, color=ColorBox.ColorBoxTypes.TIP, value="\u25c9 Use `chat.trigger` to create `chat commands`.\nThe `regex` in `chat.replace` is used to `find` the target pattern in `the given string`.\nThe `regex` in `chat.trigger` is used to `match` the target pattern against `the given string`.\n\nYou can define a `chat command` like `!report` or `!noclip` in other games.\n"), @ColorBox(id=1751899049909L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 To define a simple magic spell in chat string.\nRegex: `magic`\nCommands: `say magic!`\n"), @ColorBox(id=1751899198263L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 To define a complex magic spell with arguments in chat string.\nRegex: `i am (.+)`\nCommands:\n1. `say You just said: $0`\n2. `say Hello $1`\n"), @ColorBox(id=1751899201560L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 To define a shortcut for chat display module with Styled Chat mod.\nRegex: `(?<=^|\\\\s)item(?=\\\\s|$)`\nCommands: `run as fake-op %player:name% chat display item`\n")})
public class ChatTriggerInitializer
extends ModuleInitializer {
    private static final BaseConfigurationHandler<ChatTriggerConfigModel> config = ObjectConfigurationHandler.ofModule("config.json", ChatTriggerConfigModel.class);

    private static void processChatTriggers(@NotNull class_2168 source, @NotNull String chatString) {
        LogUtil.debug("Process chat triggers for input: chatString = {}", chatString);
        config.model().getTriggers().stream().filter(it -> it.getCachedPattern().matcher(chatString).matches()).forEach(chatTrigger -> {
            Matcher matcher = chatTrigger.getCachedPattern().matcher(chatString);
            List<String> commands = chatTrigger.getCommands().stream().map(cmd -> StringUtil.replaceAllAndResetMatcher(matcher, cmd)).toList();
            CommandExecutor.executeBatch(ExtendedCommandSource.asConsole(source), commands);
        });
    }

    @EventConsumer(injectorPriority=2000, consumerPriority=2000)
    private static void handleOnPlayerChatEvent(PlayerChatMessagePostEvent event) {
        class_7471 signedMessage = event.getSignedMessage();
        String chatString = TextHelper.Operators.getString(signedMessage.method_46291());
        ChatTriggerInitializer.processChatTriggers(CommandHelper.Source.getCommandSource(event.getPlayer()), chatString);
    }
}

