/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.command_spy.config.transformer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import mod.fuji.core.auxiliary.JsonUtil;
import mod.fuji.core.config.migrator.transformer.abst.JsonConfigurationTransformer;
import org.jetbrains.annotations.NotNull;

public class CommandSpySchemaV1Transformer
extends JsonConfigurationTransformer {
    @Override
    public String sinceVersion() {
        return "12.40.0";
    }

    @Override
    protected void apply() {
        this.readTargetJsonFile().ifPresent(rootJsonObject -> {
            AtomicBoolean overrideFile = new AtomicBoolean(false);
            boolean spyOnConsoleFlag = Optional.ofNullable(rootJsonObject.get("spy_on_console")).map(JsonElement::getAsBoolean).orElse(false);
            JsonUtil.ifJsonElementPresent(rootJsonObject, "ignore_commands", JsonArray.class, ignoreCommandsJsonArray -> CommandSpySchemaV1Transformer.withRules(rootJsonObject, rulesJsonArray -> {
                for (JsonElement ignoreCommandElement : ignoreCommandsJsonArray) {
                    JsonObject ruleJsonObject = CommandSpySchemaV1Transformer.makeCommandRule(ignoreCommandElement.getAsString(), spyOnConsoleFlag, false);
                    rulesJsonArray.add((JsonElement)ruleJsonObject);
                    overrideFile.set(true);
                }
            }));
            JsonUtil.ifJsonElementPresent(rootJsonObject, "only_spy_these_commands", JsonObject.class, onlySpyTheseCommands -> CommandSpySchemaV1Transformer.withRules(rootJsonObject, rulesJsonArray -> {
                boolean enable = onlySpyTheseCommands.get("enable").getAsBoolean();
                if (enable) {
                    JsonArray commands = onlySpyTheseCommands.get("commands").getAsJsonArray();
                    for (JsonElement command : commands) {
                        JsonObject rule = CommandSpySchemaV1Transformer.makeCommandRule(command.getAsString(), spyOnConsoleFlag, true);
                        rulesJsonArray.add((JsonElement)rule);
                        overrideFile.set(true);
                    }
                } else {
                    JsonObject rule = CommandSpySchemaV1Transformer.makeCommandRule(".+", spyOnConsoleFlag, true);
                    rulesJsonArray.add((JsonElement)rule);
                    overrideFile.set(true);
                }
            }));
            if (overrideFile.get()) {
                this.writeTargetJsonFile((JsonObject)rootJsonObject);
            }
        });
    }

    private static JsonObject makeCommandRule(@NotNull String commandString, boolean spyOnConsoleFlag, boolean logToConsoleFlag) {
        JsonObject rule = new JsonObject();
        rule.addProperty("enable", Boolean.valueOf(true));
        JsonObject matcher = new JsonObject();
        JsonObject ifMatched = new JsonObject();
        rule.add("matcher", (JsonElement)matcher);
        rule.add("if_matched", (JsonElement)ifMatched);
        matcher.addProperty("command_string_regex", commandString);
        matcher.addProperty("accept_silent_command", Boolean.valueOf(true));
        matcher.addProperty("accept_player_command_source", Boolean.valueOf(true));
        matcher.addProperty("accept_server_command_source", Boolean.valueOf(spyOnConsoleFlag));
        ifMatched.addProperty("log_to_console", Boolean.valueOf(logToConsoleFlag));
        ifMatched.addProperty("notify_players_with_level_permission", (Number)5);
        return rule;
    }

    private static void withRules(@NotNull JsonObject rootJsonObject, Consumer<JsonArray> consumer) {
        String rulesJsonKey = "rules";
        JsonArray value = Optional.ofNullable(rootJsonObject.get("rules")).map(JsonElement::getAsJsonArray).orElseGet(() -> {
            JsonArray newValue = new JsonArray();
            rootJsonObject.add("rules", (JsonElement)newValue);
            return newValue;
        });
        consumer.accept(value);
    }
}

