/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.fuji;

import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.command.annotation.CommandNode;
import mod.fuji.core.command.annotation.CommandRequirement;
import mod.fuji.core.command.annotation.CommandSource;
import mod.fuji.core.config.Configs;
import mod.fuji.core.config.model.MainControlConfigModel;
import mod.fuji.core.document.annotation.Document;
import mod.fuji.core.document.gui.CommandsInspectionGui;
import mod.fuji.core.job.JobManager;
import mod.fuji.core.module.ModuleManager;
import mod.fuji.module.initializer.ModuleInitializer;
import mod.fuji.module.initializer.core.CoreInitializer;
import mod.fuji.module.initializer.fuji.gui.AboutGui;
import mod.fuji.module.initializer.fuji.gui.ArgumentTypesInspectionGui;
import mod.fuji.module.initializer.fuji.gui.ConfigurationsInspectionGui;
import mod.fuji.module.initializer.fuji.gui.EventsInspectionGui;
import mod.fuji.module.initializer.fuji.gui.JobsInspectionGui;
import mod.fuji.module.initializer.fuji.gui.LanguagesInspectionGui;
import mod.fuji.module.initializer.fuji.gui.MixinsInspectionGui;
import mod.fuji.module.initializer.fuji.gui.ModulesInspectionGui;
import mod.fuji.module.initializer.fuji.gui.PermissionsAndMetasInspectionGui;
import mod.fuji.module.initializer.fuji.gui.PlaceholdersInspectionGui;
import mod.fuji.module.initializer.fuji.gui.RegistriesInspectionGui;
import mod.fuji.module.initializer.fuji.gui.ServerCommandsInspectionGui;
import net.minecraft.class_2168;
import net.minecraft.class_3222;

@Document(id=1751826545831L, value="Provides `/fuji` command.\nTo `reload` the configs of fuji.\nTo `inspect` states of fuji.\nTo `discover` things of fuji.\n")
@CommandNode(value="fuji")
@CommandRequirement(level=4)
public class FujiInitializer
extends ModuleInitializer {
    @Document(id=1751826549358L, value="Reload all the configuration files in `/fuji inspect configurations`.\nReload all the `enabled` modules in `/fuji inspect modules`.\n\nNOTE: You have to `re-start` the server, after you enable/disable a module.\n")
    @CommandNode(value="reload")
    public static int $reload(@CommandSource class_2168 source) {
        Configs.MAIN_CONTROL_CONFIG.readStorage();
        TextHelper.Loader.clearLoadedLanguageJsons();
        ModuleManager.reloadModuleInitializers();
        JobManager.reloadStaticJobTriggers();
        TextHelper.sendTextByKey(source, "reload", new Object[0]);
        return 1;
    }

    @Document(id=1751826551723L, value="Print the user guide of fuji.")
    @CommandNode(value="user-guide")
    public static int $userGuide(@CommandSource class_2168 source) {
        CoreInitializer.printUserGuide();
        TextHelper.sendTextByKey(source, "fuji.user_guide", new Object[0]);
        return 1;
    }

    @Document(id=1751826554192L, value="Open the about GUI.")
    @CommandNode(value="about")
    private static int $about(@CommandSource class_3222 player) {
        AboutGui.make(null, player).open();
        return 1;
    }

    @Document(id=1751826556095L, value="Toggle the debug mode of fuji.")
    @CommandNode(value="debug")
    public static int $debug(@CommandSource class_2168 source) {
        MainControlConfigModel.Core.Debug config = Configs.MAIN_CONTROL_CONFIG.model().core.debug;
        config.log_debug_messages = !config.log_debug_messages;
        TextHelper.sendTextByKey(source, config.log_debug_messages ? "fuji.debug.on" : "fuji.debug.off", new Object[0]);
        return 1;
    }

    @Document(id=1751826560904L, value="Inspect all commands registered in server.")
    @CommandNode(value="inspect server-commands")
    private static int $inspectServerCommands(@CommandSource class_3222 player) {
        ServerCommandsInspectionGui.inspectAll(player).open();
        return 1;
    }

    @Document(id=1751826563793L, value="Inspect all enabled/disabled modules of fuji.")
    @CommandNode(value="inspect modules")
    private static int $inspectModules(@CommandSource class_3222 player) {
        ModulesInspectionGui.inspectAll(null, player).open();
        return 1;
    }

    @Document(id=1751826565988L, value="Alias to `/fuji inspect modules`.")
    @CommandNode
    private static int $inspectModulesShortcut(@CommandSource class_3222 player) {
        FujiInitializer.$inspectModules(player);
        return 1;
    }

    @Document(id=1751826568226L, value="Alias to `/fuji inspect modules`.")
    @CommandNode(value="gui")
    private static int $gui(@CommandSource class_3222 player) {
        FujiInitializer.$inspectModules(player);
        return 1;
    }

    @Document(id=1751826570905L, value="Inspect all commands registered by fuji.")
    @CommandNode(value="inspect fuji-commands")
    private static int $inspectFujiCommands(@CommandSource class_3222 player) {
        CommandsInspectionGui.inspectAll(null, player).open();
        return 1;
    }

    @Document(id=1751826572555L, value="Inspect all argument types registered by fuji.")
    @CommandNode(value="inspect argument-types")
    private static int $inspectCommandArgumentTypes(@CommandSource class_3222 player) {
        ArgumentTypesInspectionGui.inspectAll(null, player).open();
        return 1;
    }

    @Document(id=1751826574793L, value="Inspect all loaded configurations files used by fuji.")
    @CommandNode(value="inspect configurations")
    private static int $inspectConfigurations(@CommandSource class_3222 player) {
        ConfigurationsInspectionGui.inspectAll(null, player).open();
        return 1;
    }

    @Document(id=1751826576778L, value="Inspect all registries in server.")
    @CommandNode(value="inspect registry")
    private static int $inspectRegistry(@CommandSource class_3222 player) {
        RegistriesInspectionGui.inspectAll(player).open();
        return 1;
    }

    @Document(id=1751826579437L, value="Inspect permissions and metas used by fuji.")
    @CommandNode(value="inspect permissions-and-metas")
    private static int $inspectPermissionsAndMetas(@CommandSource class_3222 player) {
        PermissionsAndMetasInspectionGui.inspectAll(null, player).open();
        return 1;
    }

    @Document(id=1751826581359L, value="Inspect placeholders registered by fuji.")
    @CommandNode(value="inspect placeholders")
    private static int $inspectPlaceholders(@CommandSource class_3222 player) {
        PlaceholdersInspectionGui.inspectAll(null, player).open();
        return 1;
    }

    @Document(id=1751826583345L, value="Inspect jobs registered by fuji.")
    @CommandNode(value="inspect jobs")
    private static int $inspectJobs(@CommandSource class_3222 player) {
        JobsInspectionGui.inspectAll(null, player).open();
        return 1;
    }

    @Document(id=1752003106392L, value="Inspect loaded language files by fuji.")
    @CommandNode(value="inspect languages")
    private static int $inspectLanguages(@CommandSource class_3222 player) {
        LanguagesInspectionGui.inspectAll(null, player).open();
        return 1;
    }

    @Document(id=1756906211441L, value="Inspect applied mixins by fuji.")
    @CommandNode(value="inspect mixins")
    private static int $inspectMixins(@CommandSource class_3222 player) {
        MixinsInspectionGui.inspectAll(player).open();
        return 1;
    }

    @Document(id=1756910112078L, value="Inspect registered events by fuji.")
    @CommandNode(value="inspect events")
    private static int $inspectEvents(@CommandSource class_3222 player) {
        EventsInspectionGui.inspectAll(player).open();
        return 1;
    }
}

