/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.jail.service;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import mod.fuji.core.auxiliary.LogUtil;
import mod.fuji.core.auxiliary.minecraft.PlayerHelper;
import mod.fuji.core.auxiliary.minecraft.ServerHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.command.executor.CommandExecutor;
import mod.fuji.core.command.executor.structure.ExtendedCommandSource;
import mod.fuji.core.service.duration_parser.DurationParser;
import mod.fuji.core.structure.GlobalPos;
import mod.fuji.module.initializer.jail.JailInitializer;
import mod.fuji.module.initializer.jail.job.PatrolJailJob;
import mod.fuji.module.initializer.jail.structure.JailDataNode;
import mod.fuji.module.initializer.jail.structure.JailDescriptor;
import mod.fuji.module.initializer.jail.structure.JailRecord;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JailService {
    public static List<JailDescriptor> getJailDescriptors() {
        return JailInitializer.config.model().getJailDescriptors();
    }

    public static List<String> getJailIds() {
        return JailService.getJailDescriptors().stream().map(JailDescriptor::getId).toList();
    }

    public static Optional<JailDescriptor> findJailDescriptor(String id) {
        return JailService.getJailDescriptors().stream().filter(it -> it.getId().equals(id)).findFirst();
    }

    private static List<JailDataNode> getJailDataNodes() {
        return JailInitializer.data.model().getJailDataNodes();
    }

    private static <T> T withJailDataNode(@NotNull JailDescriptor jail, Function<JailDataNode, T> function) {
        Optional<JailDataNode> jailDataNode = JailService.getJailDataNodes().stream().filter(it -> it.getJailId().equals(jail.getId())).findFirst();
        JailDataNode $jailDataNode = jailDataNode.orElseGet(() -> {
            JailDataNode newValue = JailDataNode.makeDefault(jail);
            JailService.getJailDataNodes().add(newValue);
            return newValue;
        });
        return function.apply($jailDataNode);
    }

    public static List<JailRecord> getJailRecords() {
        return JailService.getJailDescriptors().stream().flatMap(it -> JailService.getJailRecords(it).stream()).toList();
    }

    public static List<JailRecord> getEnabledRecords() {
        return JailService.filterEnabledJailRecords(JailService.getJailRecords());
    }

    public static List<JailRecord> getJailRecords(@NotNull JailDescriptor jailDescriptor) {
        return JailService.withJailDataNode(jailDescriptor, jailDataNode -> {
            List<JailRecord> jailRecords = jailDataNode.getRecords();
            jailRecords.forEach(jailRecord -> jailRecord.setOwnerJailDescriptor(jailDescriptor));
            return jailRecords;
        });
    }

    private static List<JailRecord> filterEnabledJailRecords(@NotNull List<JailRecord> jailRecords) {
        return jailRecords.stream().filter(JailRecord::isEnable).toList();
    }

    @NotNull
    public static List<String> getJailedPlayerNames() {
        return JailService.getEnabledRecords().stream().map(JailRecord::getPrisonerName).toList();
    }

    public static Optional<JailRecord> getActiveJailRecord(String playerName) {
        return JailService.getEnabledRecords().stream().filter(jailRecord -> jailRecord.getPrisonerName().equals(playerName)).findFirst();
    }

    public static void createJailDescriptor(@NotNull String jailId, @NotNull class_2168 source) {
        GlobalPos globalPos = GlobalPos.of(source);
        JailDescriptor newValue = JailDescriptor.make(jailId, globalPos);
        JailInitializer.config.model().getJailDescriptors().add(newValue);
        JailInitializer.config.writeStorage();
        PatrolJailJob.scheduleJob(newValue);
    }

    public static void deleteJailDescriptor(@NotNull JailDescriptor jailDescriptor) {
        JailInitializer.config.model().getJailDescriptors().remove(jailDescriptor);
        JailInitializer.config.writeStorage();
    }

    public static void setJailPosition(@NotNull JailDescriptor jailDescriptor, @NotNull GlobalPos globalPos) {
        jailDescriptor.setGlobalPosition(globalPos);
        JailInitializer.config.writeStorage();
    }

    public static void createJailRecord(String creatorName, String playerName, JailDescriptor jail, String reason, String $duration) {
        JailService.withJailDataNode(jail, jailDataNode -> {
            int specifiedJailSeconds = DurationParser.parseIntoSeconds($duration).orElseThrow();
            JailRecord jailRecord = JailRecord.make(creatorName, playerName, specifiedJailSeconds, reason);
            jailDataNode.getRecords().add(jailRecord);
            return null;
        });
        JailService.executeOnJailedCommands(jail, playerName);
        PlayerHelper.updateDisplayNames();
    }

    private static void executeOnUnjailedCommands(JailDescriptor jail, String playerName) {
        class_3222 offlinePlayerEntity = PlayerHelper.Loader.loadDummyPlayer(playerName);
        CommandExecutor.executeBatch(ExtendedCommandSource.asConsole(offlinePlayerEntity.method_64396()), jail.getEvents().getOnUnjailedEvent());
    }

    public static void deactivateJailRecord(JailRecord jailRecord) {
        JailService.executeOnUnjailedCommands(jailRecord.getOwnerJailDescriptor(), jailRecord.getPrisonerName());
        jailRecord.setEnable(false);
        PlayerHelper.updateDisplayNames();
    }

    public static void deactivateJailRecordWithoutEvents(String playerName) {
        JailService.getActiveJailRecord(playerName).ifPresent(jailRecord -> jailRecord.setEnable(false));
    }

    private static void executeOnJailedCommands(JailDescriptor jail, String playerName) {
        class_3222 offlinePlayerEntity = PlayerHelper.Loader.loadDummyPlayer(playerName);
        CommandExecutor.executeBatch(ExtendedCommandSource.asConsole(offlinePlayerEntity.method_64396()), jail.getEvents().getOnJailedEvent());
    }

    public static void updateJailRecords(int passedTimeInMillSeconds) {
        JailService.getEnabledRecords().forEach(jailRecord -> jailRecord.onUpdateRecord(passedTimeInMillSeconds));
    }

    public static void executePatrolCommands(JailDescriptor jail) {
        List<JailRecord> enabledJailRecords = JailService.filterEnabledJailRecords(JailService.getJailRecords(jail));
        enabledJailRecords.forEach(jailRecord -> ServerHelper.executeSync(() -> {
            String playerName = jailRecord.getPrisonerName();
            PlayerHelper.Lookup.getOnlinePlayerByName(playerName).ifPresent(onlinePlayer -> {
                LogUtil.debug("Execute patrol commands: jail = {}, jailedPlayer = {}", jail.getId(), playerName);
                List<String> patrolCommands = jail.getPatrol().getPatrolCommands();
                CommandExecutor.executeBatch(ExtendedCommandSource.asConsole(onlinePlayer.method_64396()), patrolCommands);
            });
        }));
    }

    public static class_2561 getNoJailStatusText() {
        String value = JailInitializer.config.model().getNoJailStatusText();
        return TextHelper.getTextByValue(null, value, new Object[0]);
    }

    @Nullable
    public static class_2561 modifyDisplayName(@Nullable class_2561 original, @NotNull class_1657 player) {
        String playerName = PlayerHelper.getPlayerName(player);
        return JailService.getActiveJailRecord(playerName).map(it -> TextHelper.getTextByValue(player, JailInitializer.config.model().getJailedPlayerTabListText(), new Object[0])).orElse(original);
    }
}

