/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.service.style_striper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mod.fuji.core.auxiliary.LogUtil;
import mod.fuji.core.auxiliary.minecraft.LuckpermsHelper;
import mod.fuji.core.document.annotation.DocStringProvider;
import mod.fuji.core.document.descriptor.PermissionDescriptor;
import net.minecraft.class_1657;
import org.jetbrains.annotations.NotNull;

public class StyleStriper {
    private static final Pattern TAG_RESOLVER = Pattern.compile("<([^>]+)>");
    private static final Map<String, PermissionDescriptor> CREATED_STYLE_KINDS = new HashMap<String, PermissionDescriptor>();

    @NotNull
    public static String stripe(@NotNull class_1657 player, @NotNull String styleKind, @NotNull String inputString) {
        for (String tag : StyleStriper.resolveTags(inputString)) {
            String tagType = StyleStriper.extractTagType(tag);
            if (StyleStriper.canUseThisTagType(player, styleKind, tagType)) continue;
            inputString = inputString.replace(tag, "");
        }
        return inputString;
    }

    @NotNull
    private static String extractTagType(@NotNull String tag) {
        int colonIndex;
        if ((tag = tag.trim()).startsWith("/")) {
            tag = tag.substring(1);
        }
        if (tag.endsWith("\\")) {
            tag = tag.substring(0, tag.length() - 1);
        }
        if ((colonIndex = tag.indexOf(58)) != -1) {
            return tag.substring(0, colonIndex);
        }
        int blankIndex = tag.indexOf(32);
        if (blankIndex != -1) {
            return tag.substring(0, blankIndex);
        }
        return tag;
    }

    @NotNull
    private static Set<String> resolveTags(@NotNull String string) {
        HashSet<String> tags = new HashSet<String>();
        Matcher matcher = TAG_RESOLVER.matcher(string);
        while (matcher.find()) {
            String tag = matcher.group(1);
            tags.add(tag);
        }
        LogUtil.debug("Resolve style tags: {}", tags);
        return tags;
    }

    @DocStringProvider(id=1751999453562L, value="The permission used for `style tags striper`.\nA player requires the `corresponding permission` to use that `style tag` in `a style kind`.\n\nFor example:\n1. The `style kind` can be: `sign`, `anvil`...\n2. The `style tag` can be: `\\<yellow\\>`, `\\<bold\\>`...\n")
    @NotNull
    private static PermissionDescriptor getOrCreatePermissionDescriptorForStyleKind(@NotNull String styleKind) {
        return CREATED_STYLE_KINDS.computeIfAbsent(styleKind, key -> {
            String pattern = "fuji.style.%s.<style-tag>";
            pattern = pattern.formatted(styleKind);
            return new PermissionDescriptor(pattern, 1751999453562L);
        });
    }

    private static boolean canUseThisTagType(@NotNull class_1657 player, @NotNull String styleKind, @NotNull String tagType) {
        PermissionDescriptor permission = StyleStriper.getOrCreatePermissionDescriptorForStyleKind(styleKind);
        return LuckpermsHelper.hasPermission(player.method_5667(), permission, styleKind, tagType);
    }
}

