/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.skin.structure;

import java.util.Collections;
import mod.fuji.core.auxiliary.LogUtil;
import mod.fuji.core.auxiliary.minecraft.EntityHelper;
import mod.fuji.core.auxiliary.minecraft.PlayerHelper;
import mod.fuji.core.auxiliary.minecraft.WorldHelper;
import mod.fuji.core.document.annotation.TestCase;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2596;
import net.minecraft.class_2632;
import net.minecraft.class_2703;
import net.minecraft.class_2724;
import net.minecraft.class_2739;
import net.minecraft.class_2743;
import net.minecraft.class_2748;
import net.minecraft.class_2752;
import net.minecraft.class_2783;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3898;
import net.minecraft.class_7828;
import org.jetbrains.annotations.NotNull;

public class SkinSyncer {
    public static void broadcastGameProfileChange(@NotNull class_3222 player) {
        PlayerHelper.Lookup.getOnlinePlayers().forEach(observer -> {
            SkinSyncer.sendPacketsToOnlinePlayers(observer, player);
            if (observer.equals((Object)player)) {
                SkinSyncer.sendPacketsToSelfPlayer(player);
            } else {
                SkinSyncer.sendPacketsToObservingPlayers(observer, player);
            }
        });
    }

    @TestCase(action="Try to send a chat message after the skin changed in online-mode server.", targets={"The chat message validation should be proper after a player changed its skin.", "It should work in both `online-mode` and `offline-mode` servers."})
    private static void sendPacketsToSelfPlayer(@NotNull class_3222 player) {
        if (player.method_31481()) {
            LogUtil.debug("Skip the sending packets to the self player, because it's already removed. (player = {})", PlayerHelper.getPlayerName((class_1657)player));
            return;
        }
        player.field_13987.method_14364((class_2596)new class_2724(player.method_52374(EntityHelper.getServerWorld((class_1297)player)), 3));
        player.field_13987.method_14364((class_2596)new class_2703(class_2703.class_5893.field_40699, player));
        player.field_13987.method_14363(player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454(), player.method_36455());
        player.field_13987.method_14364((class_2596)new class_2743((class_1297)player));
        player.field_13987.method_14364((class_2596)new class_2632(EntityHelper.getServerWorld((class_1297)player).method_8407(), EntityHelper.getServerWorld((class_1297)player).method_8401().method_197()));
        PlayerHelper.getPlayerManager().method_14594(player);
        player.method_7355();
        for (class_1293 effect : player.method_6026()) {
            player.field_13987.method_14364((class_2596)new class_2783(player.method_5628(), effect));
        }
        player.field_13987.method_14364((class_2596)new class_2748(player.field_7510, player.field_7495, player.field_7520));
        SkinSyncer.syncVehicleAndPassengers(player, player);
        PlayerHelper.getPlayerManager().method_14606(player, PlayerHelper.getServerWorld(player));
        player.field_13987.method_14364((class_2596)new class_2739(player.method_5628(), player.method_5841().method_46357()));
    }

    private static void syncVehicleAndPassengers(@NotNull class_3222 observer, @NotNull class_3222 player) {
        class_1297 vehicle = player.method_5854();
        if (vehicle != null) {
            observer.field_13987.method_14364((class_2596)new class_2752(vehicle));
        }
        observer.field_13987.method_14364((class_2596)new class_2752((class_1297)player));
    }

    private static void sendPacketsToObservingPlayers(@NotNull class_3222 observer, @NotNull class_3222 player) {
        class_3218 playerServerWorld = PlayerHelper.getServerWorld(player);
        class_3898.class_3208 trackedPlayer = (class_3898.class_3208)WorldHelper.getChunkStorage((class_3218)playerServerWorld).field_18242.get(player.method_5628());
        if (trackedPlayer != null) {
            trackedPlayer.method_18733(observer);
            trackedPlayer.method_18736(observer);
        }
        observer.field_13987.method_14364((class_2596)new class_2752((class_1297)player));
    }

    private static void sendPacketsToOnlinePlayers(@NotNull class_3222 observer, @NotNull class_3222 player) {
        observer.field_13987.method_14364((class_2596)new class_7828(Collections.singletonList(player.method_5667())));
        observer.field_13987.method_14364((class_2596)new class_2703(class_2703.class_5893.field_29136, player));
        observer.field_13987.method_14364((class_2596)new class_2703(class_2703.class_5893.field_40700, player));
        observer.field_13987.method_14364((class_2596)new class_2703(class_2703.class_5893.field_29139, player));
    }
}

