/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.auxiliary;

import com.google.errorprone.annotations.CheckReturnValue;
import java.util.ArrayList;
import java.util.List;
import mod.fuji.core.document.annotation.TestCase;
import mod.fuji.core.exception.FujiException;
import org.jetbrains.annotations.NotNull;

public class ExceptionUtil {
    @CheckReturnValue
    @TestCase(action="Test the exception handler functions.", targets={"This mod failed at server startup, due to mixin injection errors.", "This mod failed at server startup, due to module initialization failed.", "This mod failed at the execution of `/fuji reload` command.", "This mod failed at the execution of `/json read a b` command.", "This mod failed at the execution of `/run as console run as player %player:name% bad` command."})
    @NotNull
    public static RuntimeException makeReThrownException(@NotNull Exception exception) {
        return ExceptionUtil.makeReThrownException("\u2b06\u2b06\u2b06\u2b06\u2b06 Re-throw exception by Fuji Mod. Refer to the details above. \u2b06\u2b06\u2b06\u2b06\u2b06", exception);
    }

    @CheckReturnValue
    @NotNull
    private static RuntimeException makeReThrownException(@NotNull String message, @NotNull Exception exception) {
        if (exception instanceof RuntimeException) {
            RuntimeException runtimeException = (RuntimeException)exception;
            return runtimeException;
        }
        return new FujiException(message, exception);
    }

    @NotNull
    public static List<Throwable> getThrowableChain(@NotNull Throwable throwable) {
        ArrayList<Throwable> chain = new ArrayList<Throwable>();
        for (Throwable current = throwable; current != null; current = current.getCause()) {
            chain.add(current);
        }
        return chain;
    }
}

