/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.document.structure;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import mod.fuji.core.document.interfaces.SourceModuleGetter;
import mod.fuji.core.manager.impl.module.ModulePathResolver;
import mod.fuji.core.manager.impl.scheduler.ScheduleManager;
import org.jetbrains.annotations.NotNull;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.matchers.GroupMatcher;

public class JobDescriptor
implements SourceModuleGetter {
    public final JobDetail jobDetail;
    private List<? extends Trigger> triggersOfJob;

    @NotNull
    public static List<JobDescriptor> getJobDescriptors() throws SchedulerException {
        ArrayList<JobDescriptor> entities = new ArrayList<JobDescriptor>();
        Scheduler scheduler = ScheduleManager.getScheduler();
        GroupMatcher jobKeyGroupMatcher = GroupMatcher.anyJobGroup();
        Set jobKeys = scheduler.getJobKeys(jobKeyGroupMatcher);
        for (JobKey jobKey : jobKeys) {
            JobDetail jobDetail = scheduler.getJobDetail(jobKey);
            List triggersOfJob = scheduler.getTriggersOfJob(jobKey);
            entities.add(new JobDescriptor(jobDetail, triggersOfJob));
        }
        entities.sort(Comparator.comparing(it -> it.getJobDetail().getKey().getGroup()));
        return entities;
    }

    @Override
    public String getSourceModule() {
        JobDetail jobDetail = this.jobDetail;
        Object specifiedSourceModule = jobDetail.getJobDataMap().get((Object)"source-module");
        if (specifiedSourceModule != null) {
            return specifiedSourceModule.toString();
        }
        Class jobClass = jobDetail.getJobClass();
        return ModulePathResolver.computeModulePathString(jobClass.getName());
    }

    @Generated
    public JobDetail getJobDetail() {
        return this.jobDetail;
    }

    @Generated
    public List<? extends Trigger> getTriggersOfJob() {
        return this.triggersOfJob;
    }

    @Generated
    public JobDescriptor setTriggersOfJob(List<? extends Trigger> triggersOfJob) {
        this.triggersOfJob = triggersOfJob;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JobDescriptor)) {
            return false;
        }
        JobDescriptor other = (JobDescriptor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JobDetail this$jobDetail = this.getJobDetail();
        JobDetail other$jobDetail = other.getJobDetail();
        if (this$jobDetail == null ? other$jobDetail != null : !this$jobDetail.equals(other$jobDetail)) {
            return false;
        }
        List<? extends Trigger> this$triggersOfJob = this.getTriggersOfJob();
        List<? extends Trigger> other$triggersOfJob = other.getTriggersOfJob();
        return !(this$triggersOfJob == null ? other$triggersOfJob != null : !((Object)this$triggersOfJob).equals(other$triggersOfJob));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JobDescriptor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JobDetail $jobDetail = this.getJobDetail();
        result = result * 59 + ($jobDetail == null ? 43 : $jobDetail.hashCode());
        List<? extends Trigger> $triggersOfJob = this.getTriggersOfJob();
        result = result * 59 + ($triggersOfJob == null ? 43 : ((Object)$triggersOfJob).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "JobDescriptor(jobDetail=" + String.valueOf(this.getJobDetail()) + ", triggersOfJob=" + String.valueOf(this.getTriggersOfJob()) + ")";
    }

    @Generated
    public JobDescriptor(JobDetail jobDetail, List<? extends Trigger> triggersOfJob) {
        this.jobDetail = jobDetail;
        this.triggersOfJob = triggersOfJob;
    }
}

