/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.event.consumer;

import java.util.function.Consumer;
import mod.fuji.core.auxiliary.ReflectionUtil;
import mod.fuji.core.event.consumer.BaseEventConsumer;
import mod.fuji.core.event.injector.structure.EventConsumerInfo;
import mod.fuji.core.event.message.BaseEvent;
import org.jetbrains.annotations.NotNull;

public class DynamicEventConsumer<T>
extends BaseEventConsumer<T> {
    protected DynamicEventConsumer(EventConsumerInfo eventConsumerInfo, Class<T> eventType, Consumer<T> eventConsumerMethod) {
        super(eventConsumerInfo, eventType, eventConsumerMethod);
    }

    public static <T extends BaseEvent> BaseEventConsumer<T> makeDynamic(@NotNull Class<T> eventTypeClass, int injectorPriority, int consumerPriority, @NotNull Consumer<T> eventConsumer) {
        String eventTypeClassName = eventTypeClass.getName();
        StackTraceElement callerMethod = ReflectionUtil.Stacktrace.getCallerMethod();
        String declaringClassName = callerMethod.getClassName();
        String declaringMethodName = callerMethod.getMethodName();
        EventConsumerInfo eventConsumerInfo = new EventConsumerInfo(eventTypeClassName, declaringClassName, declaringMethodName, injectorPriority, consumerPriority, true);
        return new DynamicEventConsumer<T>(eventConsumerInfo, eventTypeClass, eventConsumer);
    }
}

