/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.manager.impl.backup;

import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import mod.fuji.Fuji;
import mod.fuji.core.auxiliary.IOUtil;
import mod.fuji.core.config.Configs;
import mod.fuji.core.manager.impl.backup.BaseBackupManager;
import org.jetbrains.annotations.NotNull;

public class PrimaryBackupManager
extends BaseBackupManager {
    public PrimaryBackupManager() {
        super(Fuji.MOD_CONFIG_PATH.resolve("backup"));
    }

    @Override
    protected boolean shouldSkipPath(@NotNull Path dir) {
        return Configs.MAIN_CONTROL_CONFIG.model().core.backup.skip.stream().anyMatch(other -> dir.equals(Fuji.MOD_CONFIG_PATH.resolve((String)other)));
    }

    private void trimBackup() {
        List<Path> latestFiles = IOUtil.listLatestFiles(this.BACKUP_STORAGE_PATH);
        Iterator<Path> iterator = latestFiles.iterator();
        int maxBackupSlots = Configs.MAIN_CONTROL_CONFIG.model().core.backup.max_slots - 1;
        while (iterator.hasNext() && latestFiles.size() > maxBackupSlots) {
            Files.delete(iterator.next());
            iterator.remove();
        }
    }

    @Override
    public void createBackup() {
        this.trimBackup();
        super.createBackup();
    }
}

