/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.manager.impl.bossbar;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import mod.fuji.core.annotation.Unused;
import mod.fuji.core.auxiliary.minecraft.PlayerHelper;
import mod.fuji.core.event.annotation.EventConsumer;
import mod.fuji.core.event.message.player.PlayerDamageEvent;
import mod.fuji.core.event.message.server.tick.ServerTickStartEvent;
import mod.fuji.core.manager.abst.BaseManager;
import mod.fuji.core.manager.impl.bossbar.BossBarTicket;
import mod.fuji.core.manager.impl.bossbar.structure.InterruptibleTicket;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class BossBarManager
extends BaseManager {
    private static final List<BossBarTicket> tickets = new CopyOnWriteArrayList<BossBarTicket>();
    private static final List<BossBarTicket> addedTickets = new CopyOnWriteArrayList<BossBarTicket>();

    @EventConsumer
    private static void processOnPlayerDamagedEvent(PlayerDamageEvent event) {
        class_3222 player = event.getPlayer();
        tickets.stream().filter(it -> {
            InterruptibleTicket interruptibleTicket;
            return it instanceof InterruptibleTicket && (interruptibleTicket = (InterruptibleTicket)it).getInterruptible().isEnable() && interruptibleTicket.getInterruptible().isInterruptOnDamaged() && PlayerHelper.Kind.isRealPlayer(player) && it.getPlayers().stream().anyMatch(p -> p.equals((Object)player));
        }).forEach(it -> it.setAborted(true));
    }

    public static Collection<BossBarTicket> getTickets() {
        return Collections.unmodifiableCollection(tickets);
    }

    public static void addTicket(BossBarTicket ticket) {
        addedTickets.add(ticket);
    }

    private static void abortTicket(@NotNull BossBarTicket ticket) {
        ticket.clearPlayers();
        tickets.remove(ticket);
    }

    @EventConsumer
    private static void tickBossBarTickets(@Unused ServerTickStartEvent event) {
        tickets.addAll(addedTickets);
        addedTickets.clear();
        if (tickets.isEmpty()) {
            return;
        }
        ArrayList<BossBarTicket> abortedTickets = new ArrayList<BossBarTicket>();
        ArrayList<BossBarTicket> completedTickets = new ArrayList<BossBarTicket>();
        for (BossBarTicket ticket : tickets) {
            if (ticket.isAborted()) {
                abortedTickets.add(ticket);
                continue;
            }
            if (!ticket.preProgressChange()) {
                ticket.setAborted(true);
                continue;
            }
            ticket.getBossBar().method_14091(true);
            for (class_3222 player : ticket.getPlayers()) {
                if (!player.method_14239()) continue;
                ticket.onPlayerDisconnected(player);
                ticket.removePlayer(player);
            }
            try {
                ticket.step();
            }
            catch (Exception e) {
                ticket.setAborted(true);
                return;
            }
            if (!ticket.postProgressChange()) {
                ticket.setAborted(true);
                continue;
            }
            if (!ticket.isCompleted()) continue;
            ticket.setAborted(true);
            completedTickets.add(ticket);
        }
        completedTickets.forEach(BossBarTicket::onComplete);
        abortedTickets.forEach(BossBarManager::abortTicket);
    }

    public static <T extends BossBarTicket> Optional<T> findBossbarTicket(@NotNull Class<T> ticketType, @NotNull class_3222 player) {
        return BossBarManager.getTickets().stream().filter(it -> it.getPlayers().stream().anyMatch(p -> p.equals((Object)player)) && ticketType.isInstance(it)).map(it -> it).findFirst();
    }
}

