/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.manager.impl.bossbar;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import mod.fuji.core.manager.impl.bossbar.command.argument.wrapper.StepType;
import net.minecraft.class_3213;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public abstract class BossBarTicket {
    private final float totalTicks;
    private final float stepTicksPerTick;
    private final class_3213 bossBar;
    private final StepType stepType;
    private boolean aborted;

    public BossBarTicket(class_3213 bossBar, int totalMs, StepType stepType, @NotNull List<class_3222> players) {
        this.bossBar = bossBar;
        this.totalTicks = 20.0f * ((float)totalMs / 1000.0f);
        this.stepType = stepType;
        this.bossBar.method_5408(this.computeInitialProgress());
        this.stepTicksPerTick = this.computeStepTicksPerTick();
        players.forEach(this::addPlayer);
        this.bossBar.method_14091(false);
    }

    public BossBarTicket(class_3213 bossBar, int totalMs, @NotNull List<class_3222> players) {
        this(bossBar, totalMs, StepType.FORWARD, players);
    }

    private float computeInitialProgress() {
        return this.stepType == StepType.FORWARD ? 0.0f : 1.0f;
    }

    private float computeStepTicksPerTick() {
        float abs = 1.0f / this.totalTicks;
        return this.stepType == StepType.FORWARD ? abs : -abs;
    }

    @NotNull
    public Collection<class_3222> getPlayers() {
        return Collections.unmodifiableCollection(this.bossBar.method_14092());
    }

    public void step() {
        if (this.stepType == StepType.FORWARD) {
            this.progress(Math.min(1.0f, this.progress() + this.stepTicksPerTick));
        } else {
            this.progress(Math.max(0.0f, this.progress() + this.stepTicksPerTick));
        }
    }

    public boolean isCompleted() {
        if (this.stepType == StepType.FORWARD) {
            return Float.compare(this.progress(), 1.0f) == 0;
        }
        return Float.compare(this.progress(), 0.0f) == 0;
    }

    public float progress() {
        return this.bossBar.method_5412();
    }

    public void progress(float progress) {
        this.bossBar.method_5408(progress);
    }

    public void addPlayer(@NotNull class_3222 player) {
        this.bossBar.method_14088(player);
    }

    public void removePlayer(@NotNull class_3222 player) {
        this.bossBar.method_14089(player);
    }

    public void clearPlayers() {
        this.bossBar.method_14091(false);
        this.bossBar.method_14094();
    }

    protected void onPlayerDisconnected(class_3222 player) {
    }

    protected boolean preProgressChange() {
        return true;
    }

    protected boolean postProgressChange() {
        return true;
    }

    protected abstract void onComplete();

    @Generated
    public float getTotalTicks() {
        return this.totalTicks;
    }

    @Generated
    public float getStepTicksPerTick() {
        return this.stepTicksPerTick;
    }

    @Generated
    public class_3213 getBossBar() {
        return this.bossBar;
    }

    @Generated
    public StepType getStepType() {
        return this.stepType;
    }

    @Generated
    public boolean isAborted() {
        return this.aborted;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BossBarTicket)) {
            return false;
        }
        BossBarTicket other = (BossBarTicket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getTotalTicks(), other.getTotalTicks()) != 0) {
            return false;
        }
        if (Float.compare(this.getStepTicksPerTick(), other.getStepTicksPerTick()) != 0) {
            return false;
        }
        if (this.isAborted() != other.isAborted()) {
            return false;
        }
        class_3213 this$bossBar = this.getBossBar();
        class_3213 other$bossBar = other.getBossBar();
        if (this$bossBar == null ? other$bossBar != null : !this$bossBar.equals(other$bossBar)) {
            return false;
        }
        StepType this$stepType = this.getStepType();
        StepType other$stepType = other.getStepType();
        return !(this$stepType == null ? other$stepType != null : !((Object)((Object)this$stepType)).equals((Object)other$stepType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BossBarTicket;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getTotalTicks());
        result = result * 59 + Float.floatToIntBits(this.getStepTicksPerTick());
        result = result * 59 + (this.isAborted() ? 79 : 97);
        class_3213 $bossBar = this.getBossBar();
        result = result * 59 + ($bossBar == null ? 43 : $bossBar.hashCode());
        StepType $stepType = this.getStepType();
        result = result * 59 + ($stepType == null ? 43 : ((Object)((Object)$stepType)).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BossBarTicket(totalTicks=" + this.getTotalTicks() + ", stepTicksPerTick=" + this.getStepTicksPerTick() + ", bossBar=" + String.valueOf(this.getBossBar()) + ", stepType=" + String.valueOf((Object)this.getStepType()) + ", aborted=" + this.isAborted() + ")";
    }

    @Generated
    public BossBarTicket setAborted(boolean aborted) {
        this.aborted = aborted;
        return this;
    }
}

