/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.manager.impl.bossbar.structure;

import java.util.List;
import lombok.Generated;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.extension.PlayerCombatExtension;
import mod.fuji.core.manager.impl.bossbar.BossBarTicket;
import mod.fuji.core.manager.impl.bossbar.structure.Interruptible;
import mod.fuji.core.structure.GlobalPos;
import net.minecraft.class_3213;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public abstract class InterruptibleTicket
extends BossBarTicket {
    @NotNull
    protected final class_3222 player;
    @NotNull
    protected final GlobalPos source;
    @NotNull
    protected final Interruptible interruptible;

    public InterruptibleTicket(class_3213 bossBar, int totalMS, @NotNull class_3222 player, @NotNull GlobalPos source, @NotNull Interruptible interruptible) {
        super(bossBar, totalMS, List.of(player));
        this.player = player;
        this.source = source;
        this.interruptible = interruptible;
    }

    @Override
    protected boolean preProgressChange() {
        if (!this.interruptible.isEnable()) {
            return true;
        }
        if (this.interruptible.isInterruptInCombat() && ((PlayerCombatExtension)this.player).fuji$inCombat()) {
            TextHelper.sendTextByKey(this.player, "teleport_warmup.in_combat", new Object[0]);
            return false;
        }
        double interruptDistance = this.getInterruptible().getInterruptDistance();
        return !(this.player.method_73189().method_1028(this.source.getX(), this.source.getY(), this.source.getZ()) >= interruptDistance * interruptDistance);
    }

    @NotNull
    @Generated
    public class_3222 getPlayer() {
        return this.player;
    }

    @NotNull
    @Generated
    public GlobalPos getSource() {
        return this.source;
    }

    @NotNull
    @Generated
    public Interruptible getInterruptible() {
        return this.interruptible;
    }
}

