/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.manager.impl.callback;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import mod.fuji.core.annotation.Unused;
import mod.fuji.core.auxiliary.LogUtil;
import mod.fuji.core.auxiliary.RandomUtil;
import mod.fuji.core.auxiliary.minecraft.CommandHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.event.annotation.EventConsumer;
import mod.fuji.core.event.message.server.command.CommandRegistrationEvent;
import mod.fuji.core.event.message.server.lifecycle.ServerStartedEvent;
import mod.fuji.core.manager.abst.BaseManager;
import mod.fuji.core.manager.impl.callback.structure.TTLMap;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2558;
import net.minecraft.class_3222;

public class CallbackManager
extends BaseManager {
    private static final String COMMAND_CALLBACK_LITERAL = "command-callback";
    private static final String COMMAND_CALLBACK_UUID_ARGUMENT_NAME = "uuid";
    private static TTLMap<String, Consumer<class_3222>> uuid2consumer;

    @EventConsumer
    private static void resetCallbackMap(@Unused ServerStartedEvent event) {
        uuid2consumer = new TTLMap();
    }

    @EventConsumer
    private static void registerCommandCallbackCommand(CommandRegistrationEvent event) {
        CommandDispatcher<class_2168> dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)COMMAND_CALLBACK_LITERAL).then(class_2170.method_9244((String)COMMAND_CALLBACK_UUID_ARGUMENT_NAME, (ArgumentType)StringArgumentType.greedyString()).executes(CallbackManager::$executeCallbackCommand)));
    }

    private static int $executeCallbackCommand(CommandContext<class_2168> ctx) {
        return CommandHelper.Pattern.withServerPlayerCommand((class_2168)ctx.getSource(), player -> {
            String uuid = StringArgumentType.getString((CommandContext)ctx, (String)COMMAND_CALLBACK_UUID_ARGUMENT_NAME);
            CallbackManager.executeCallbackCommand(uuid, player);
            return 1;
        });
    }

    private static void executeCallbackCommand(String uuid, class_3222 player) {
        Consumer<class_3222> consumer = uuid2consumer.get(uuid);
        if (consumer == null) {
            TextHelper.sendTextByKey(player, "callback.invalid", new Object[0]);
            return;
        }
        consumer.accept(player);
    }

    private String makeCallbackCommand(String uuid, Consumer<class_3222> callback, long ttl, TimeUnit timeUnit) {
        LogUtil.debug("Make callback command: uuid = {}", uuid);
        uuid2consumer.put(uuid, callback, ttl, timeUnit);
        return "/command-callback " + uuid;
    }

    public String makeCallbackCommand(Consumer<class_3222> callback, long ttl, TimeUnit timeUnit) {
        return this.makeCallbackCommand(RandomUtil.randomUUID(), callback, ttl, timeUnit);
    }

    private class_2558 makeCallbackEvent(String uuid, Consumer<class_3222> callback, long ttl, TimeUnit timeUnit) {
        String commandString = this.makeCallbackCommand(uuid, callback, ttl, timeUnit);
        return TextHelper.Events.ClickEvent.makeRunCommandAction(commandString);
    }

    public class_2558 makeCallbackEvent(Consumer<class_3222> callback, long ttl, TimeUnit timeUnit) {
        return this.makeCallbackEvent(RandomUtil.randomUUID(), callback, ttl, timeUnit);
    }
}

