/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.manager.impl.scheduler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import mod.fuji.core.annotation.Unused;
import mod.fuji.core.auxiliary.ExceptionUtil;
import mod.fuji.core.auxiliary.LogUtil;
import mod.fuji.core.auxiliary.minecraft.ServerHelper;
import mod.fuji.core.config.Configs;
import mod.fuji.core.document.annotation.TestCase;
import mod.fuji.core.event.annotation.EventConsumer;
import mod.fuji.core.event.message.server.lifecycle.ServerStartedEvent;
import mod.fuji.core.event.message.server.lifecycle.ServerStoppingEvent;
import mod.fuji.core.job.abst.BaseJob;
import mod.fuji.core.manager.abst.BaseManager;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.config.Configurator;
import org.jetbrains.annotations.NotNull;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.matchers.GroupMatcher;

@TestCase(action="Issue `/stop` in the production environment.", targets={"The program should be terminated."})
public class ScheduleManager
extends BaseManager {
    public static final String CRON_EVERY_SECOND = "* * * ? * *";
    public static final String CRON_EVERY_FIVE_SECONDS = "0/5 * * ? * * *";
    public static final String CRON_EVERY_TEN_SECONDS = "0/10 * * ? * * *";
    public static final String CRON_EVERY_MINUTE = "0 * * ? * * *";
    public static final String CRON_EVERY_THREE_MINUTES = "0 */3 * ? * *";
    public static final String CRON_EVERY_FIVE_MINUTES = "0 */5 * ? * *";
    private static final Set<BaseJob> STATIC_JOBS = new HashSet<BaseJob>();
    private static Scheduler scheduler;

    private static void getOrInitializeScheduler() {
        try {
            StdSchedulerFactory stdSchedulerFactory = new StdSchedulerFactory();
            scheduler = stdSchedulerFactory.getScheduler();
        }
        catch (SchedulerException e) {
            throw ExceptionUtil.makeReThrownException((Exception)((Object)e));
        }
    }

    @EventConsumer(injectorPriority=2000, consumerPriority=2000)
    private static void startScheduler(@Unused ServerStartedEvent event) {
        try {
            scheduler.start();
        }
        catch (SchedulerException e) {
            LogUtil.error("Failed to start the scheduler.", new Object[]{e});
        }
    }

    @EventConsumer
    private static void shutdownScheduler(@Unused ServerStoppingEvent event) {
        try {
            scheduler.shutdown(false);
            if (ServerHelper.Environment.isClientSideIntegratedServer()) {
                ScheduleManager.getOrInitializeScheduler();
            }
        }
        catch (SchedulerException e) {
            LogUtil.error("Failed to shutdown the scheduler", new Object[]{e});
        }
    }

    public void addJob(@NotNull BaseJob baseJob) {
        JobDetail jobDetail = baseJob.getJobDetail();
        Trigger trigger = baseJob.makeTrigger();
        try {
            LogUtil.debug("Add job: jobDetail = {}, trigger = {}", jobDetail, trigger);
            if (baseJob.isStaticJob()) {
                STATIC_JOBS.add(baseJob);
            }
            scheduler.scheduleJob(jobDetail, trigger);
        }
        catch (SchedulerException e) {
            LogUtil.error("Failed to add job: jobDetail = {}, trigger = {}", new Object[]{jobDetail, trigger, e});
        }
    }

    public void deleteJobs(@NotNull Class<?> jobGroupClass) {
        @NotNull String jobGroupName = jobGroupClass.getName();
        ArrayList<JobKey> jobKeys = new ArrayList<JobKey>(this.getJobKeys(jobGroupName));
        this.deleteJobs(jobKeys);
    }

    private void deleteJobs(@NotNull List<JobKey> jobKeys) {
        try {
            LogUtil.debug("Delete jobs: jobKeys = {}", jobKeys);
            scheduler.deleteJobs(jobKeys);
        }
        catch (SchedulerException e) {
            LogUtil.error("Failed to delete jobs: jobKeys = {}", new Object[]{jobKeys, e});
        }
    }

    @NotNull
    private Set<JobKey> getJobKeys(@NotNull String jobGroup) {
        try {
            GroupMatcher groupMatcher = GroupMatcher.groupEquals((String)jobGroup);
            return scheduler.getJobKeys(groupMatcher);
        }
        catch (SchedulerException e) {
            LogUtil.error("Failed to get job keys: jobGroup = {}", new Object[]{jobGroup, e});
            return Collections.emptySet();
        }
    }

    public void triggerJobs(@NotNull String jobGroup) {
        this.getJobKeys(jobGroup).forEach(jobKey -> {
            try {
                scheduler.triggerJob(jobKey);
            }
            catch (SchedulerException e) {
                LogUtil.error("Failed to trigger jobs: jobGroup = {}", new Object[]{jobGroup, e});
            }
        });
    }

    public void updateJobTriggers(@NotNull BaseJob baseJob) {
        TriggerKey triggerKey = baseJob.getTriggerKey();
        Trigger newTrigger = baseJob.makeTrigger();
        try {
            LogUtil.debug("Update job triggers: triggerKey = {}, newTrigger = {}", triggerKey, newTrigger);
            scheduler.rescheduleJob(triggerKey, newTrigger);
        }
        catch (SchedulerException e) {
            LogUtil.error("Failed to update job triggers: triggerKey = {}, newTrigger = {}", new Object[]{triggerKey, newTrigger, e});
        }
    }

    public void reloadStaticJobTriggers() {
        STATIC_JOBS.forEach(this::updateJobTriggers);
    }

    @Generated
    public static Scheduler getScheduler() {
        return scheduler;
    }

    static {
        Level level = Level.getLevel((String)Configs.MAIN_CONTROL_CONFIG.model().core.scheduler.logger_level);
        Configurator.setAllLevels((String)"org.quartz", (Level)level);
        ScheduleManager.getOrInitializeScheduler();
    }
}

