/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.manager.impl.task;

import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import mod.fuji.core.annotation.Unused;
import mod.fuji.core.event.annotation.EventConsumer;
import mod.fuji.core.event.message.server.tick.ServerTickStartEvent;
import mod.fuji.core.manager.abst.BaseManager;
import mod.fuji.core.manager.impl.task.structure.GameTask;
import org.jetbrains.annotations.NotNull;

public class GameTaskManager
extends BaseManager {
    private static final CopyOnWriteArrayList<GameTask> TASK_QUEUE = new CopyOnWriteArrayList();

    public static void runInTicks(int inTicks, @NotNull Runnable runnable) {
        GameTask gameTask = new GameTask(inTicks, () -> {}, () -> {}, runnable);
        GameTaskManager.submitTask(gameTask);
    }

    @EventConsumer
    private static void tickGameTasks(@Unused ServerTickStartEvent event) {
        TASK_QUEUE.forEach(GameTask::onTick);
        TASK_QUEUE.removeIf(GameTask::isCompleted);
    }

    public static void submitTask(@NotNull GameTask task) {
        TASK_QUEUE.add(task);
    }

    public static void submitTasks(@NotNull Collection<GameTask> tasks) {
        TASK_QUEUE.addAll(tasks);
    }
}

