/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.back.service;

import java.util.Optional;
import java.util.function.Function;
import mod.fuji.core.auxiliary.ChronosUtil;
import mod.fuji.core.auxiliary.minecraft.LuckpermsHelper;
import mod.fuji.core.auxiliary.minecraft.PlayerHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.command.argument.wrapper.impl.Dimension;
import mod.fuji.core.command.exception.AbortCommandExecutionException;
import mod.fuji.core.event.annotation.EventConsumer;
import mod.fuji.core.event.message.player.PlayerDeathEvent;
import mod.fuji.core.event.message.player.PlayerTeleportPreEvent;
import mod.fuji.core.structure.GlobalPos;
import mod.fuji.module.initializer.back.BackInitializer;
import mod.fuji.module.initializer.back.structure.LocationEntry;
import mod.fuji.module.initializer.back.structure.LocationHistory;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackService {
    public static <R> R withLocationHistory(@NotNull class_3222 player, Function<LocationHistory, R> function) {
        String playerName = PlayerHelper.getPlayerName((class_1657)player);
        BackInitializer.savedPositionConfig.model().player2history.computeIfAbsent(playerName, k -> new LocationHistory());
        LocationHistory locationHistory = BackInitializer.savedPositionConfig.model().player2history.get(playerName);
        return function.apply(locationHistory);
    }

    public static Integer listBackLocations(class_2168 source, class_3222 player) {
        return BackService.withLocationHistory(player, locationHistory -> {
            String targetPlayerName = PlayerHelper.getPlayerName((class_1657)player);
            TextHelper.sendTextByKey(source, "back.list", targetPlayerName);
            locationHistory.listEntries().forEachRemaining(it -> {
                GlobalPos location = it.getLocation();
                TextHelper.sendTextByKey(source, "back.list.entry", location.getLevel(), location.getX(), location.getY(), location.getZ(), ChronosUtil.Formatter.formatDate(it.getSavedTimestamp()));
            });
            return 1;
        });
    }

    public static int teleportBackLocation(@NotNull class_3222 player, int lastNLocation, @Nullable Dimension targetDimension) {
        return BackService.withLocationHistory(player, locationHistory -> {
            LocationEntry latestEntry = locationHistory.findEntry(lastNLocation, targetDimension);
            if (latestEntry == null) {
                TextHelper.sendTextByKey(player, "back.no_previous_position", new Object[0]);
                throw new AbortCommandExecutionException();
            }
            latestEntry.getLocation().teleport(player);
            return 1;
        });
    }

    private static int getMaxBackLocationEntriesToSave(@NotNull class_3222 player) {
        Optional<Integer> value = LuckpermsHelper.getMeta(player.method_5667(), BackInitializer.MAX_LOCATION_ENTRIES_TO_SAVE_META, new Object[0]);
        return value.orElse(BackInitializer.config.model().max_back_location_entries_to_save);
    }

    private static boolean shouldSaveCurrentLocation(@NotNull class_3222 player) {
        return BackService.withLocationHistory(player, locationHistory -> {
            LocationEntry latestEntry = locationHistory.getLatestEntry();
            if (latestEntry == null) {
                return true;
            }
            GlobalPos latestLocation = latestEntry.getLocation();
            double ignoreDistance = BackInitializer.config.model().ignore_distance;
            if (latestLocation.sameLevel((class_1937)PlayerHelper.getServerWorld(player)) && player.method_73189().method_1028(latestLocation.getX(), latestLocation.getY(), latestLocation.getZ()) <= ignoreDistance * ignoreDistance) {
                return false;
            }
            return true;
        });
    }

    private static void trySaveCurrentLocation(@NotNull class_3222 player) {
        BackService.withLocationHistory(player, locationHistory -> {
            if (BackService.shouldSaveCurrentLocation(player)) {
                LocationEntry locationEntry = LocationEntry.makeLocationEntry(player);
                BackService.pushBackLocation(player, locationHistory, locationEntry);
            }
            return null;
        });
    }

    public static void pushBackLocation(@NotNull class_3222 player, @NotNull LocationHistory locationHistory, @NotNull LocationEntry locationEntry) {
        locationHistory.pushEntry(locationEntry);
        locationHistory.trimEntries(BackService.getMaxBackLocationEntriesToSave(player));
    }

    @EventConsumer
    private static void handleOnPlayerDeathEvent(PlayerDeathEvent event) {
        if (BackInitializer.config.model().enable_back_on_death) {
            BackService.trySaveCurrentLocation(event.getPlayer());
        }
    }

    @EventConsumer
    private static void handlePlayerPreTeleportEvent(PlayerTeleportPreEvent event) {
        if (event.getCallbackInfo().isCancelled()) {
            return;
        }
        if (BackInitializer.config.model().enable_back_on_teleport) {
            BackService.trySaveCurrentLocation(event.getPlayer());
        }
    }
}

