/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.chat.display.helper;

import java.util.concurrent.TimeUnit;
import mod.fuji.core.auxiliary.RandomUtil;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.manager.Managers;
import mod.fuji.core.service.display.gui.BaseDisplayGuiFactory;
import mod.fuji.core.service.display.gui.InventoryDisplayGuiFactory;
import mod.fuji.core.service.display.gui.ShulkerBoxDisplayGuiFactory;
import mod.fuji.module.initializer.chat.display.ChatDisplayInitializer;
import mod.fuji.module.initializer.chat.display.gui.EnderChestDisplayGuiFactory;
import mod.fuji.module.initializer.chat.display.gui.ItemDisplayGuiFactory;
import mod.fuji.module.initializer.chat.display.structure.SoftReferenceMap;
import net.minecraft.class_1799;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class DisplayHelper {
    private static final SoftReferenceMap<String, BaseDisplayGuiFactory> uuid2factory = new SoftReferenceMap();

    private static String bindUUID(@NotNull BaseDisplayGuiFactory displayGuiFactory) {
        String uuid = RandomUtil.randomUUID();
        uuid2factory.put(uuid, displayGuiFactory);
        return uuid;
    }

    private static void viewDisplayGui(@NotNull class_3222 viewingPlayer, @NotNull String displayUUID) {
        BaseDisplayGuiFactory baseDisplayGui = uuid2factory.get(displayUUID);
        if (baseDisplayGui == null) {
            TextHelper.sendTextByKey(viewingPlayer, "display.invalid", new Object[0]);
            return;
        }
        baseDisplayGui.build(viewingPlayer).open();
    }

    public static class_5250 createEnderDisplayText(@NotNull class_3222 sharingPlayer) {
        String displayUUID = DisplayHelper.bindUUID(new EnderChestDisplayGuiFactory(sharingPlayer));
        return TextHelper.getTextByKey(sharingPlayer, "display.ender_chest.text", new Object[0]).method_27661().method_27696(class_2583.field_24360.method_10949(TextHelper.Events.HoverEvent.makeShowTextAction(TextHelper.getTextByKey(sharingPlayer, "display.click.prompt", new Object[0]))).method_10958(DisplayHelper.makeDisplayClickEvent(displayUUID)));
    }

    public static class_5250 createInvDisplayText(@NotNull class_3222 sharingPlayer) {
        String displayUUID = DisplayHelper.bindUUID(new InventoryDisplayGuiFactory(sharingPlayer));
        return TextHelper.getTextByKey(sharingPlayer, "display.inventory.text", new Object[0]).method_27661().method_27696(class_2583.field_24360.method_10949(TextHelper.Events.HoverEvent.makeShowTextAction(TextHelper.getTextByKey(sharingPlayer, "display.click.prompt", new Object[0]))).method_10958(DisplayHelper.makeDisplayClickEvent(displayUUID)));
    }

    @NotNull
    public static class_5250 createItemDisplayText(@NotNull class_3222 sharingPlayer) {
        class_1799 itemStack = sharingPlayer.method_6047().method_7972();
        BaseDisplayGuiFactory displayGui = BaseDisplayGuiFactory.isShulkerBox(itemStack) ? new ShulkerBoxDisplayGuiFactory(sharingPlayer, itemStack, null) : new ItemDisplayGuiFactory(sharingPlayer, itemStack);
        String displayUUID = DisplayHelper.bindUUID(displayGui);
        class_5250 translatableItemNameText = class_2561.method_43471((String)sharingPlayer.method_6047().method_7909().method_7876());
        translatableItemNameText.method_27696(class_2583.field_24360.method_10949(TextHelper.Events.HoverEvent.makeShowTextAction(TextHelper.getTextByKey(sharingPlayer, "display.click.prompt", new Object[0]))).method_10958(DisplayHelper.makeDisplayClickEvent(displayUUID)));
        class_5250 displayText = TextHelper.getTextByKey(sharingPlayer, "display.item.text", new Object[0]).method_27661();
        displayText = TextHelper.Replacer.replaceTextWithNamedArgument((class_2561)displayText, "item", matcher -> translatableItemNameText);
        return displayText;
    }

    @NotNull
    private static class_2558 makeDisplayClickEvent(@NotNull String displayUUID) {
        return Managers.getCallbackManager().makeCallbackEvent(player -> DisplayHelper.viewDisplayGui(player, displayUUID), ChatDisplayInitializer.config.model().getExpirationDurationSeconds(), TimeUnit.SECONDS);
    }
}

