/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.color.sign;

import java.io.IOException;
import mod.fuji.core.auxiliary.LogUtil;
import mod.fuji.core.auxiliary.minecraft.UuidHelper;
import mod.fuji.core.config.handler.abst.BaseConfigurationHandler;
import mod.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import mod.fuji.core.config.mapper.GsonMapper;
import mod.fuji.core.document.annotation.ColorBox;
import mod.fuji.core.document.annotation.Document;
import mod.fuji.core.document.annotation.TestCase;
import mod.fuji.core.manager.Managers;
import mod.fuji.core.service.style_striper.StyleStriper;
import mod.fuji.core.structure.GlobalBlockPos;
import mod.fuji.module.initializer.ModuleInitializer;
import mod.fuji.module.initializer.color.sign.config.model.ColorSignConfigModel;
import mod.fuji.module.initializer.color.sign.structure.SignCache;
import net.minecraft.class_1657;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Document(id=1751824932882L, value="This module allows you to use `color tags` in `sign blocks`.\n")
@ColorBox(id=1751900015107L, color=ColorBox.ColorBoxTypes.TIP, value="\u25c9 You can write `style tags` on the sign.\nFoe example: `\\<red\\>`, `\\<rb\\>`, `\\<bold\\>` and `\\<i\\>`.\n")
@TestCase(action="Place a `sign block` and write style tags in it, then re-open the sign.", targets={"The style tags in the sign block should be `parsed` and `reversed`."})
public class ColorSignInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<ColorSignConfigModel> config = ObjectConfigurationHandler.ofModule("config.json", ColorSignConfigModel.class);
    private static final String ATTACHMENT_SUBJECT = "color-sign-cache";

    @Nullable
    public static SignCache readSignCache(@NotNull GlobalBlockPos globalBlockPos) {
        String uuid = UuidHelper.getAttachedUuid(globalBlockPos);
        if (!Managers.getAttachmentManager().existsAttachment(ATTACHMENT_SUBJECT, uuid)) {
            return null;
        }
        try {
            String data = Managers.getAttachmentManager().getAttachment(ATTACHMENT_SUBJECT, uuid);
            return GsonMapper.fromJson(data, SignCache.class);
        }
        catch (IOException e) {
            LogUtil.error("Failed to read sign cache: spatialBlock = {}", globalBlockPos, e);
            return null;
        }
    }

    public static void writeSignCache(@NotNull GlobalBlockPos globalBlockPos, @NotNull SignCache signCache) {
        String uuid = UuidHelper.getAttachedUuid(globalBlockPos);
        String data = GsonMapper.toJsonString(signCache);
        try {
            Managers.getAttachmentManager().setAttachment(ATTACHMENT_SUBJECT, uuid, data);
        }
        catch (IOException e) {
            LogUtil.error("Failed to write sign cache: spatialBlock = {}, signCache = {}", globalBlockPos, signCache, e);
        }
    }

    public static String stripeStyleTags(class_1657 player, String string) {
        return StyleStriper.stripe(player, "sign", string);
    }
}

