/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.command_scheduler;

import java.util.List;
import mod.fuji.core.annotation.Unused;
import mod.fuji.core.auxiliary.LogUtil;
import mod.fuji.core.command.annotation.CommandNode;
import mod.fuji.core.command.annotation.CommandRequirement;
import mod.fuji.core.command.annotation.CommandSource;
import mod.fuji.core.config.handler.abst.BaseConfigurationHandler;
import mod.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import mod.fuji.core.document.annotation.ColorBox;
import mod.fuji.core.document.annotation.ColorBoxes;
import mod.fuji.core.document.annotation.Document;
import mod.fuji.core.document.annotation.TestCase;
import mod.fuji.core.event.annotation.EventConsumer;
import mod.fuji.core.event.message.server.lifecycle.ServerStartedEvent;
import mod.fuji.core.manager.Managers;
import mod.fuji.module.initializer.ModuleInitializer;
import mod.fuji.module.initializer.command_scheduler.command.argument.wrapper.JobName;
import mod.fuji.module.initializer.command_scheduler.config.model.CommandSchedulerConfigModel;
import mod.fuji.module.initializer.command_scheduler.gui.JobGui;
import mod.fuji.module.initializer.command_scheduler.job.CommandScheduleJob;
import mod.fuji.module.initializer.command_scheduler.structure.CommandSchedulerJobDescriptor;
import net.minecraft.class_3222;
import org.quartz.JobDataMap;

@Document(id=1755407283186L, value="This module allows executing commands on a `schedule`.\n\nIts typical use case is executing `broadcast commands` on a schedule.\nHowever, it can also be used to execute any specified commands.\n")
@ColorBoxes(value={@ColorBox(id=1755407830073L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 How it works?\n1. Define a `job` to execute `commands` on a schedule.\n1.a. The `schedule` is expressed using the `cron expression` language.\n1.b. You can specify multiple `cron expressions` for a `job`.\n1.c. A `job` is `triggered` if any of its `cron expressions` match.\n2. A `job` is automatically `triggered` according to its `cron expressions`.\n3. When a `job` is `triggered`, it will do:\n3.a. If the `enable` property is `false`, then do nothing.\n3.b. If the `remaining runs` property is `<= 0`, then do nothing.\n3.c. Otherwise, it decreases the `remaining runs` property by 1, and pick a random `command group` to execute.\n4. You can `trigger` a `job` using `/command-scheduler trigger \\<job\\>` manually.\n"), @ColorBox(id=1751972254866L, color=ColorBox.ColorBoxTypes.TIP, value="\u25c9 You can use `cron expression` generator, to specify when a `job` should be `triggered`.\nSee\n1. https://www.freeformatter.com/cron-expression-generator-quartz.html\n2. https://crontab.cronhub.io/\n3. https://odown.com/free-tools/cron-expression-generator/\n\n\u25c9 List the `next fire dates` for each defined `job`.\nIssue `/fuji inspect jobs` to see the `fire dates` of defined `jobs`.\n")})
@CommandNode(value="command-scheduler")
@CommandRequirement(level=4)
@TestCase(action="Issue `/fuji reload` command.", targets={"The jobs from command_scheduler module should be re-scheduled."})
public class CommandSchedulerInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<CommandSchedulerConfigModel> scheduler = ObjectConfigurationHandler.ofModule("scheduler.json", CommandSchedulerConfigModel.class);

    @EventConsumer
    private static void addCommandSchedulerJobs(@Unused ServerStartedEvent event) {
        CommandSchedulerInitializer.reloadJobs();
    }

    @Override
    protected void onReload() {
        CommandSchedulerInitializer.reloadJobs();
    }

    @Document(id=1751826757048L, value="List all defined jobs.")
    @CommandNode(value="list")
    private static int $list(@CommandSource class_3222 player) {
        List<CommandSchedulerJobDescriptor> jobs = CommandSchedulerInitializer.scheduler.model().jobs;
        new JobGui(player, jobs, 0).open();
        return 1;
    }

    @Document(id=1751826758887L, value="Trigger a job manually.")
    @CommandNode(value="trigger")
    private static int $trigger(JobName jobName) {
        CommandSchedulerInitializer.scheduler.model().jobs.stream().filter(it -> it.getName().equals(jobName.getValue())).findFirst().ifPresent(CommandSchedulerJobDescriptor::tryTrigger);
        return 1;
    }

    private static void reloadJobs() {
        LogUtil.info("Delete jobs.", new Object[0]);
        Managers.getScheduleManager().deleteJobs(CommandScheduleJob.class);
        CommandSchedulerInitializer.scheduler.model().jobs.forEach(definedJob -> {
            definedJob.getSchedules().forEach(cron -> {
                String jobName = definedJob.getName() + " -> " + cron;
                CommandScheduleJob job = new CommandScheduleJob(jobName, new JobDataMap((CommandSchedulerJobDescriptor)definedJob){
                    final /* synthetic */ CommandSchedulerJobDescriptor val$definedJob;
                    {
                        this.val$definedJob = val$definedJob;
                        this.put("job", this.val$definedJob);
                    }
                }, () -> cron);
                Managers.getScheduleManager().addJob(job);
            });
            LogUtil.info("Add job -> {}", definedJob.getName());
        });
    }
}

