/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.echo.send_bossbar;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import mod.fuji.core.auxiliary.minecraft.CommandHelper;
import mod.fuji.core.auxiliary.minecraft.PlayerHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.command.annotation.CommandNode;
import mod.fuji.core.command.annotation.CommandRequirement;
import mod.fuji.core.command.annotation.CommandSource;
import mod.fuji.core.command.argument.wrapper.impl.GreedyString;
import mod.fuji.core.command.argument.wrapper.impl.StringList;
import mod.fuji.core.command.executor.CommandExecutor;
import mod.fuji.core.command.executor.structure.ExtendedCommandSource;
import mod.fuji.core.document.annotation.ColorBox;
import mod.fuji.core.document.annotation.Document;
import mod.fuji.core.manager.impl.bossbar.BossBarManager;
import mod.fuji.core.manager.impl.bossbar.command.argument.wrapper.StepType;
import mod.fuji.module.initializer.ModuleInitializer;
import mod.fuji.module.initializer.echo.send_bossbar.structure.SendBossbarTicket;
import net.minecraft.class_1259;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_3222;

@Document(id=1751976322975L, value="This module provides `/send-bossbar` command.\nTo send the `text` as the `bossbar` to a specified player.\n")
@ColorBox(id=1751976574472L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 A simple example.\nIssue: `/send-bossbar Alice Hello World`\n\n\u25c9 All in one example.\nIssue: `/send-bossbar Alice --stepType BACKWARD --totalMs 5000 --color PURPLE --style NOTCHED_6 --notifyMeOnComplete true --commandList \"say the player %player:name% is healed|heal others %player:name%\" \\<rb\\>Healing is coming [elapsed_time]/[total_time]/[left_time]`\n")
public class SendBossbarInitializer
extends ModuleInitializer {
    @CommandNode(value="send-bossbar")
    @CommandRequirement(level=4)
    private static int $sendBossbar(@CommandSource class_2168 source, class_3222 player, Optional<Integer> totalMs, Optional<class_1259.class_1260> color, Optional<class_1259.class_1261> style, Optional<StringList> commandList, Optional<Boolean> notifyMeOnComplete, Optional<StepType> stepType, GreedyString title) {
        Integer $totalMs = totalMs.orElse(3000);
        class_1259.class_1260 $color = color.orElse(class_1259.class_1260.field_5783);
        class_1259.class_1261 $style = style.orElse(class_1259.class_1261.field_5795);
        StringList $commandList = commandList.orElse(new StringList(Collections.emptyList()));
        Boolean $notifyMeOnComplete = notifyMeOnComplete.orElse(false);
        StepType $stepType = stepType.orElse(StepType.FORWARD);
        SendBossbarTicket bossBarTicket = new SendBossbarTicket((String)title.getValue(), $color, $style, $totalMs, $stepType, player, () -> {
            ExtendedCommandSource extendedCommandSource = ExtendedCommandSource.asConsole(CommandHelper.Source.getCommandSource(player));
            CommandExecutor.executeBatch(extendedCommandSource, (List)$commandList.getValue());
            if ($notifyMeOnComplete.booleanValue()) {
                TextHelper.sendTextByKey(source, "echo.send_bossbar.notify", PlayerHelper.getPlayerName((class_1657)player), $commandList.getValue());
            }
        });
        BossBarManager.addTicket(bossBarTicket);
        return 1;
    }
}

