/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.gameplay.carpet.fake_player_manager;

import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.command.annotation.CommandNode;
import mod.fuji.core.command.annotation.CommandSource;
import mod.fuji.core.config.handler.abst.BaseConfigurationHandler;
import mod.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import mod.fuji.core.document.annotation.ColorBox;
import mod.fuji.core.document.annotation.Document;
import mod.fuji.module.initializer.ModuleInitializer;
import mod.fuji.module.initializer.gameplay.carpet.fake_player_manager.config.model.FakePlayerManagerConfigModel;
import mod.fuji.module.initializer.gameplay.carpet.fake_player_manager.service.FakePlayerManagerService;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

@Document(id=1751827019419L, value="This module provides `fake player management` for `carpet` mod.\n")
@ColorBox(id=1753153100239L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 This module introduces the `authority` for each `fake-player`.\n1. Disables the `/player shadow` command.\n2. For each `fake-player`, the `player` who `spawned` it is its `owner player`.\n3. For each `fake-player`, it can only be `interacted` (right-click) with by its `owner player`.\n4. For each `fake-player`, it can only be `manipulated` (The `/player` command) by its `owner player`.\n5. The `console`, `the ops` or `the owner player` are considered authorized.\n\n\u25c9 This module allows you to define the naming-format for `fake-player`.\nYou can define a `prefix` and `suffix` for fake player names.\nThe `fake player name` argument value will be transformed when you use `/player <playerName> spawn` command.\n\n\u25c9 This module introduce the `spawn caps limit` and `expiration time` for each fake player.\n1. You can define the `spawn caps limit` at different time.\n2. You can specify the `max living duration` for each fake player. (By default, it is `12h`.)\n3. A player can use `/player renew` command to `renew` the `expiration time` for all of its fake players.\n4. The `console` can bypass the `spawn caps limit`.\n")
public class FakePlayerManagerInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<FakePlayerManagerConfigModel> config = ObjectConfigurationHandler.ofModule("config.json", FakePlayerManagerConfigModel.class);

    @Document(id=1751827022331L, value="Renew the expiration time of `all` fake-player you have `spawned`.")
    @CommandNode(value="player renew")
    private static int $renew(@CommandSource class_3222 player) {
        FakePlayerManagerService.renewMyFakePlayers(player);
        return 1;
    }

    @Document(id=1751827025708L, value="List all fake-player and its owner player.")
    @CommandNode(value="player who")
    private static int $who(@CommandSource class_2168 source) {
        TextHelper.sendTextByKey(source, "fake_player_manager.who.header", new Object[0]);
        TextHelper.sendMessageByText(source, (class_2561)TextHelper.Formatter.formatMapMultiLine(FakePlayerManagerService.player2fakePlayers));
        return 1;
    }
}

