/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.jail.job;

import lombok.Generated;
import mod.fuji.core.auxiliary.LogUtil;
import mod.fuji.core.document.annotation.Document;
import mod.fuji.core.job.abst.FixedIntervalJob;
import mod.fuji.core.manager.Managers;
import mod.fuji.module.initializer.jail.service.JailService;
import mod.fuji.module.initializer.jail.structure.JailDescriptor;
import org.jetbrains.annotations.NotNull;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@Document(id=1753752697817L, value="This `job` is used to `execute the patrol commands` for a `jail` periodically.\n")
public class PatrolJailJob
extends FixedIntervalJob {
    public PatrolJailJob(@NotNull JobDataMap jobDataMap, @NotNull JailDescriptor jailDescriptor) {
        super(null, jailDescriptor.getId(), jobDataMap, () -> jailDescriptor.getPatrol().getPatrolIntervalMillSeconds(), -1, false);
    }

    public static void scheduleJob(final @NotNull JailDescriptor jailDescriptor) {
        PatrolJailJob job = new PatrolJailJob(new JobDataMap(){
            {
                this.put(JailDescriptor.class.getName(), jailDescriptor);
            }
        }, jailDescriptor);
        Managers.getScheduleManager().addJob(job);
    }

    public static void reloadPatrolJobs() {
        LogUtil.debug("Un-schedule patrol jobs.", new Object[0]);
        Managers.getScheduleManager().deleteJobs(PatrolJailJob.class);
        JailService.getJailDescriptors().forEach(jailDescriptor -> {
            String jailId = jailDescriptor.getId();
            int patrolIntervalMillSeconds = jailDescriptor.getPatrol().getPatrolIntervalMillSeconds();
            LogUtil.debug("Schedule patrol job: jailId = {}, intervalMillSeconds = {}", jailId, patrolIntervalMillSeconds);
            PatrolJailJob.scheduleJob(jailDescriptor);
        });
    }

    public void execute(JobExecutionContext context) throws JobExecutionException {
        JailDescriptor jailDescriptor = (JailDescriptor)context.getJobDetail().getJobDataMap().get((Object)JailDescriptor.class.getName());
        JailService.executePatrolCommands(jailDescriptor);
    }

    @Override
    @Generated
    public String toString() {
        return "PatrolJailJob()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PatrolJailJob)) {
            return false;
        }
        PatrolJailJob other = (PatrolJailJob)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PatrolJailJob;
    }

    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Generated
    public PatrolJailJob() {
    }
}

