/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.teleport_warmup;

import java.util.Optional;
import mod.fuji.core.auxiliary.minecraft.CommandHelper;
import mod.fuji.core.auxiliary.minecraft.EntityHelper;
import mod.fuji.core.auxiliary.minecraft.LuckpermsHelper;
import mod.fuji.core.auxiliary.minecraft.PlayerHelper;
import mod.fuji.core.auxiliary.minecraft.RegistryHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.config.handler.abst.BaseConfigurationHandler;
import mod.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import mod.fuji.core.document.annotation.ColorBox;
import mod.fuji.core.document.annotation.ColorBoxes;
import mod.fuji.core.document.annotation.DocStringProvider;
import mod.fuji.core.document.annotation.Document;
import mod.fuji.core.document.descriptor.MetaDescriptor;
import mod.fuji.core.document.descriptor.PermissionDescriptor;
import mod.fuji.core.event.annotation.EventConsumer;
import mod.fuji.core.event.message.player.PlayerTeleportPreEvent;
import mod.fuji.core.manager.impl.bossbar.BossBarManager;
import mod.fuji.core.structure.GlobalPos;
import mod.fuji.core.structure.TeleportTicket;
import mod.fuji.module.initializer.ModuleInitializer;
import mod.fuji.module.initializer.teleport_warmup.config.model.TeleportWarmupConfigModel;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

@Document(id=1751826791752L, value="Adds a warmup cooldown before player teleportation.\n")
@ColorBoxes(value={@ColorBox(id=1751980526151L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 How it works?\nInside the vanilla Minecraft, there is a teleport function for teleportation.\nWe listen on this teleport function, and wrap it with a warmup cooldown.\n\n\u25c9 How can I specify different cooldown time for different commands?\nYou need to use `command_warmup` module.\nThe `command_cooldown` module will simply treats `all` the teleportation request the same.\nThat's because we only know there is a teleport request.\nBut we didn't even know who creates this teleport request.\nSo we have to treat `all` teleportation the same.\n\n\u25c9 What's the purpose of teleport warmup.\nThe main purpose is to prevent the `abuse` of `teleport commands` in vanilla Minecraft.\nLike, use teleport commands to escape death.\n<green>NOTE: The `admin players` can bypass the teleport warmup.\n"), @ColorBox(id=1758083431300L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 The `teleport warmup` will NOT be applied if...\n1. The target dimension is not defined in the `effective dimensions` list.\n2. The target player's `age <= 3`\n3. The target player is admin. (level permission >= 4)\n4. The target player is a `fake player`.\n5. The target player has the `warmup bypass permission`.\n")})
public class TeleportWarmupInitializer
extends ModuleInitializer {
    @DocStringProvider(id=1752000321033L, value="To bypass all teleport warmup.\n")
    public static final PermissionDescriptor TELEPORT_WARMUP_BYPASS_PERMISSION = new PermissionDescriptor("fuji.teleport_warmup.bypass", 1752000321033L);
    @DocStringProvider(id=1752000334206L, value="Specify the teleport warmup time in seconds for this player.\n")
    public static final MetaDescriptor<Double> TELEPORT_WARMUP_TIME_META = new MetaDescriptor<Double>("fuji.teleport_warmup.warmup", Double::valueOf, 1752000334206L);
    public static final BaseConfigurationHandler<TeleportWarmupConfigModel> config = ObjectConfigurationHandler.ofModule("config.json", TeleportWarmupConfigModel.class);

    public static boolean shouldApplyTeleportWarmup(class_3218 destinationDimension, class_3222 player) {
        if (!TeleportWarmupInitializer.config.model().dimension.effective_dimensions.contains(RegistryHelper.getIdAsString((class_1937)destinationDimension))) {
            return false;
        }
        if (EntityHelper.getAge((class_1297)player) <= 3) {
            return false;
        }
        if (CommandHelper.Requirement.isAdmin(player)) {
            return false;
        }
        if (!PlayerHelper.Kind.isRealPlayer(player)) {
            return false;
        }
        return !LuckpermsHelper.hasPermission(player.method_5667(), TELEPORT_WARMUP_BYPASS_PERMISSION, new Object[0]);
    }

    public static double getWarmupSeconds(class_3222 player) {
        Optional<Double> warmupSecondsSpecifiedByMeta = LuckpermsHelper.getMeta(player.method_5667(), TELEPORT_WARMUP_TIME_META, new Object[0]);
        return warmupSecondsSpecifiedByMeta.orElse(TeleportWarmupInitializer.config.model().warmup_second);
    }

    @EventConsumer(injectorPriority=0, consumerPriority=0)
    private static void handlePlayerPreTeleportEvent(PlayerTeleportPreEvent event) {
        if (event.getCallbackInfo().isCancelled()) {
            return;
        }
        class_3222 player = event.getPlayer();
        class_3218 destinationDimension = event.getDestinationDimension();
        if (!TeleportWarmupInitializer.shouldApplyTeleportWarmup(destinationDimension, player)) {
            return;
        }
        Optional<TeleportTicket> existingTeleportTicket = BossBarManager.findBossbarTicket(TeleportTicket.class, player);
        if (existingTeleportTicket.isEmpty()) {
            int warmupDurationMs = (int)(TeleportWarmupInitializer.getWarmupSeconds(player) * 1000.0);
            TeleportTicket teleportTicket = TeleportTicket.make(player, GlobalPos.of(player), new GlobalPos((class_1937)destinationDimension, event.getDestinationX(), event.getDestinationY(), event.getDestinationZ(), event.getDestinationYaw(), event.getDestinationPitch()), warmupDurationMs, TeleportWarmupInitializer.config.model().interruptible, event.getPositionFlags());
            BossBarManager.addTicket(teleportTicket);
            event.getCallbackInfo().cancel();
            return;
        }
        if (!existingTeleportTicket.get().isCompleted()) {
            TextHelper.sendTextByKey(player, "teleport_warmup.another_teleportation_in_progress", new Object[0]);
            event.getCallbackInfo().cancel();
            return;
        }
    }
}

