/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.world.manager;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import mod.fuji.core.auxiliary.minecraft.CommandHelper;
import mod.fuji.core.auxiliary.minecraft.PlayerHelper;
import mod.fuji.core.auxiliary.minecraft.RegistryHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.auxiliary.minecraft.WorldHelper;
import mod.fuji.core.command.annotation.CommandNode;
import mod.fuji.core.command.annotation.CommandRequirement;
import mod.fuji.core.command.annotation.CommandSource;
import mod.fuji.core.command.argument.wrapper.impl.Dimension;
import mod.fuji.core.command.argument.wrapper.impl.DimensionType;
import mod.fuji.core.command.argument.wrapper.impl.FujiIdentifier;
import mod.fuji.core.command.exception.AbortCommandExecutionException;
import mod.fuji.core.config.handler.abst.BaseConfigurationHandler;
import mod.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import mod.fuji.core.config.mapper.GsonMapper;
import mod.fuji.core.document.annotation.Cite;
import mod.fuji.core.document.annotation.ColorBox;
import mod.fuji.core.document.annotation.ColorBoxes;
import mod.fuji.core.document.annotation.Document;
import mod.fuji.core.document.annotation.TestCase;
import mod.fuji.core.document.annotation.TestCases;
import mod.fuji.core.structure.GlobalPos;
import mod.fuji.module.initializer.ModuleInitializer;
import mod.fuji.module.initializer.world.manager.command.argument.wrapper.ChunkGeneratorType;
import mod.fuji.module.initializer.world.manager.command.argument.wrapper.LoadedRuntimeDimensionDescriptor;
import mod.fuji.module.initializer.world.manager.command.argument.wrapper.UnloadedRuntimeDimensionDescriptor;
import mod.fuji.module.initializer.world.manager.command.argument.wrapper.WorldPresetType;
import mod.fuji.module.initializer.world.manager.config.model.WorldConfigModel;
import mod.fuji.module.initializer.world.manager.config.model.WorldDataModel;
import mod.fuji.module.initializer.world.manager.service.WorldService;
import mod.fuji.module.initializer.world.manager.service.structure.DimensionCreationTicket;
import mod.fuji.module.initializer.world.manager.service.structure.DimensionDeletionTicket;
import mod.fuji.module.initializer.world.manager.structure.RuntimeDimensionDescriptor;
import mod.fuji.module.initializer.world.manager.structure.RuntimeDimensionImporter;
import net.minecraft.class_1267;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2784;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_6673;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Cite(value={"https://github.com/NucleoidMC/fantasy"})
@Document(id=1751826605981L, value="Provides a unified world management.\n")
@ColorBoxes(value={@ColorBox(id=1751981919874L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 The definition of `world`, ` dimension` and `dimension type`.\nIn early Minecraft, a `world` only contains `1 dimension` (The overworld dimension).\nIn modern Minecraft, a `world` can contain `3 or more dimensions`. (The overworld, the end and the nether)\n\nEach `dimension` has its `dimension type`.\nWe can create extra dimensions using existed `dimension type`.\n\nSee also: https://minecraft.wiki/w/Dimension_definition\nSee also: https://minecraft.wiki/w/Dimension_type\n\n<green>NOTE: You can just think the `dimension` word is identical to `world`.\n"), @ColorBox(id=1752458381916L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 How it works?\nIn vanilla Minecraft, there is a variable `worlds` in `server`, used to store all `loaded dimensions`.\n\nThe vanilla Minecraft will `load` the 3 `dimensions` on server startup.\nThey are `minecraft:overworld`, `minecraft:the_nether` and `minecraft:the_end`.\n\nSo, what we should do is to `imitate` the actions.\nWe make the `dimension` instance at server startup.\nAnd then we put the `dimension` in the `loaded dimensions` list.\nSo it will be recognised by the server.\n\nNOTE: The dimensions created by fuji is named `runtime dimension`, because they are `created` and `loaded` at runtime.\n\n\u25c9 Does it need to store any special data in the `world` folder?\nNo, we didn't touch the `world` folder, or put any special data into it.\n\nWhat we need is minimal, we need to define `runtime dimension descriptor` in the module folder.\nThe `runtime dimension descriptor` should provide enough information to define a `Dimension Options`.\n\n\u25c9 What is `DimensionOptions`?\nA `DimensionOptions` = A `Dimension Type` + A `Chunk Generator`.\nThe `dimension type` is used to define the `environment` of a `dimension`. (Like, `bed explosion?` or `infinite burning?`)\nThe `chunk generator` is used to `generate` the `chunks`. (Give the `seed` and `chunk location` to the generator, it will fill blocks for you)\n\nSee also:\n1. https://minecraft.wiki/w/Dimension_type\n2. https://minecraft.wiki/w/Dimension_definition\n3. https://minecraft.wiki/w/Noise_settings\n"), @ColorBox(id=1752458991398L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 How the `world` module generate the dimension?\nActually, the `world` module didn't do the `world generation` itself.\n\nWhat we do is simple, the `runtime dimension descriptor` provides enough information to create the `DimensionOptions`.\nNote that `Dimension Options = Dimension Type + Chunk Generator`:\n1. We use `Dimension Type` to describe the `environment` of a specific `dimension`. (For example, `bed explosion?`, `infinite burning?`...)\n2. We use `Chunk Generator` to describe how the `chunks` are generated. (We will give the specified `seed` argument to it)\n\n\u25c9 What is a `chunk generator`?\nGive a `seed` and `chunk location` to a `chunk generator`.\nThe `chunk generator` will `fill` blocks for you.\n\nThere are 2 types of `chunk generator`:\n1. `Flat Chunk Generator`: It is used for `superflat` world, it fills blocks `layer` by `layer`.\n2. `Noise Chunk Generator`: Compared to `Flat Chunk Generator`, it makes some `noise`, so you dimension looks not boring like `superflat dimension`.\n\n<green>NOTE: The `minecraft:overworld`, `minecraft:the_nether` and `minecraft:the_end` all use `Noise Chunk Generator`, but they have different `Chunk Generator Settings`.\n<green>There are 3 `NoiseChunkGenerator` instances with different `Chunk Generator Settings`.\n<green>That's why the `minecraft:overworld`, `minecraft:the_nether` and `minecraft:the_end` look different.\n\n\u25c9 The logic of `chunk generator`.\nIf the specified chunk is not `generated`, then the chunk generator will `generate` a new one.\nIf the specified chunk is `generated`, the chunk generator will just use the `existed chunk data` in storage.\n"), @ColorBox(id=1752297520453L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 Advanced World Management and Per-world rules.\nThe `world` module provided by fuji is a simple module.\nIf you want a more powerful tool, you can try use `WorldManager` mod and `WorldGameRules` mod.\n\nSee:\n1. https://github.com/DrexHD/WorldManager\n2. https://github.com/DrexHD/WorldGameRules\n"), @ColorBox(id=1752788919780L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 Useful concepts about a `dimension`.\n- https://minecraft.wiki/w/World_generation\n- https://minecraft.wiki/w/World_type\n- https://minecraft.wiki/w/World\n- https://minecraft.wiki/w/Biome\n- https://minecraft.wiki/w/Void\n- https://minecraft.wiki/w/Overworld\n- https://minecraft.wiki/w/Feature\n- https://minecraft.wiki/w/Structure\n- https://minecraft.wiki/w/Terrain_features\n- https://minecraft.fandom.com/wiki/Java_Edition_level_format\n- https://minecraft.wiki/w/Chunk_format\n- https://minecraft.wiki/w/Loot_table\n"), @ColorBox(id=1751982071236L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 Create an extra `the_nether` dimension\nIssue: `/world create my_nether minecraft:the_nether`\n\n<yellow>NOTE: By default, the dimension namespace is `fuji`.\n<yellow>Issue `/world create \"custom_namespace:my_nether\" minecraft:the_nether` to use a custom namespace.\n\n\u25c9 Delete the extra dimension\nIssue: `/world delete fuji:my_nether --confirm true`\n\n\u25c9 Reset the extra dimension with random seed.\nIssue: `/world reset fuji:my_nether --confirm true`\n\n\u25c9 Specify a seed for an extra dimension.\n1. `/world create my_nether --seed 1234567890 minecraft:the_nether`\n2. `/world reset fuji:my_nether --useTheSameSeed true --confirm true`\n"), @ColorBox(id=1751982158414L, color=ColorBox.ColorBoxTypes.TIP, value="\u25c9 Make a resource world that reset automatically every day.\nYou can use `command_scheduler` module, to execute `/world reset` command automatically.\n"), @ColorBox(id=1752261661452L, color=ColorBox.ColorBoxTypes.TIP, value="\u25c9 The logic of `passed ticks` is per-dimension.\nEach fuji runtime dimension will save its own `time_of_day` (The equivalent to `DayTime` in `level.dat`).\n\n\u25c9 The duration of `one day` in Minecraft.\nThe `total ticks of one day` is `24000 ticks` or `20 minutes`.\nIt is `10 minutes of day time` + `10 minutes of night time`.\n\n\u25c9 The saved `passed ticks` and `/time` command.\nThe value of `Time` in `level.dat` = `/time query gametime`.\nThe value of `DayTime` in `level.dat` = `/time query day` * 24000 + `/time query daytime`.\n\nNOTE: The `minecraft:overworld`, `minecraft:the_nether` and `minecraft:the_end` shares the same instance of `DayTime`.\nNOTE: The `/time set {day/midnight/night/noon}` command directly sets the `DayTime` to the first day.\n\n\u25c9 The logic of `/time query ...` command.\nFor `/time query daytime` command, it returns the `DayTime % 24000` of `the world of the command source`:\n1. If the `command source` is `a player`, then the `world` is `the world where the player is`.\n2. If the `command source` is `the console`, then the `world` is `minecraft:overworld`.\n\n\u25c9 The logic of `/time {set/add} ...` command.\nFor command `/time {set/add}`, it operates on `all dimensions` in the server.\n"), @ColorBox(id=1752287089199L, color=ColorBox.ColorBoxTypes.TIP, value="\u25c9 The `weather system` of the `world`.\nThere are 3 types of `weather`: `clear`, `rain` and `thunder`.\nIf `clear`, then both `rain` and `thunder` is false.\nIf `thunder`, then `rain` is true.\n\nThe `weather system` will be `tick` if:\n1. The `dimension options` of the `world` has `skylight`.\n2. The `gamerule DO_WEATHER_CYCLE` of the `world` is true.\n\n\u25c9 The logic of `/weather` command.\nThe `/weather` command `only` sets the `weather` of `minecraft:overworld`.\n\n\u25c9 Set the weather per-dimension.\nYou can modify the weather directly in config file, and issue `/fuji reload` to apply it.\n"), @ColorBox(id=1752429441664L, color=ColorBox.ColorBoxTypes.TIP, value="\u25c9 Does the `runtime dimension` support `datapack`?\nIt depends on how the `datapack` interfaces with the `world`.\nMost of datapack should work.\nAnyway, always backup your world data before install a new datapack.\n"), @ColorBox(id=1752431019812L, color=ColorBox.ColorBoxTypes.TIP, value="\u25c9 The logic of `nether portal` and `ender portal`.\nIn vanilla Minecraft, there are only 3 dimensions.\nThey are `minecraft:overworld`, `minecraft:the_nether` and `minecraft:the_end`.\nThey are `hard coded` dimensions.\nThe linkage of `nether portal` and `ender portal` use the `hard coded` dimensions.\n\n\u25c9 Can I create `nether portal` in `runtime dimension`?\nNo, you can't create any `nether portal` in runtime dimension.\n\n\u25c9 Can I create `ender portal` in `runtime dimension`?\nYes, but the destination dimension is hard-coded, it is always the `minecraft:the_end`.\n\nThe logic of `EnderPortalBlockEntity`:\n1. If the player is now in `minecraft:the_end`, then destination dimension is `minecraft:overworld`.\n2. Else the destination dimension is `minecraft:the_end`.\n"), @ColorBox(id=1752733447050L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 Create a `flat dimension` with `overworld` dimension type.\nIssue: `/world create my_flat_world minecraft:overworld --chunkGeneratorType FLAT`\n\n\u25c9 Create a `flat dimension` with `overworld` dimension type and `customized preset`.\nIssue: `/world create my_desert_world minecraft:overworld --chunkGeneratorType FLAT --chunkGeneratorParameters \"minecraft:bedrock,3*minecraft:stone,116*minecraft:sandstone;minecraft:desert\"`\n\n\u25c9 Create a `void dimension`.\nIssue: `/world create my_void_world minecraft:overworld --chunkGeneratorType FLAT --chunkGeneratorParameters \"minecraft:air;minecraft:the_void\"`\n<green>NOTE: The `secret` is, a `void dimension` is just a `flat dimension` with customized `minecraft:air layers` with the `minecraft:the_void` biome.\n\n\u25c9 Generate the `parameters` using a `generator`.\nSee: https://minecraft.tools/en/flat.php\n\n\u25c9 Useful resource\nThe definition of `world preset`: https://minecraft.fandom.com/wiki/World_preset\nThe definition of `superflat dimension`: https://minecraft.fandom.com/wiki/Superflat\n"), @ColorBox(id=1752741022214L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 Create a `runtime dimension` using pre-defined `world preset`.\nIssue: `/world create example minecraft:overworld --worldPresetType DEBUG_ALL_BLOCK_STATES`\n\nNOTE: When you are using a pre-defined `world preset`, then the following options will be `ignored`:\n1. `dimension type id`\n2. `chunk generator type`\n3. `chunk generator parameters`.\n"), @ColorBox(id=1752807649896L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 The definition of `import`, `make`, `load`, `unload`.\nThe `import` means: define a `runtime dimension descriptor` in config file.\nSo that we know how make the `original chunk generator` used by the dimension.\n\nThe `make` means: We use the `runtime dimension descriptor` to create the `dimension` instance.\nWe need to make the `DimensionOptions` from the `runtime dimension descriptor`.\nA `DimensionOptions` = A `Dimension Type` + A `Chunk Generator`.\n\nThe `load` means: We will put this `dimension` instance into the worlds list of the `server`.\n\nThe `unload` means: We will take this `dimension` instance from the worlds list of the `server`.\n\n\u25c9 The definition of `/world create` and `/world delete` command.\nThe `/world create` command does the `import`, `make` and `load`.\nThe `/world delete` command does the `unload` and also `delete the chunk files of that dimension`.\n"), @ColorBox(id=1752811309081L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 How to `import` a `dimension dir`?\nThe `/world import` is similar to `/world create` command.\nYou need to specify `enough information` to define the `runtime dimension descriptor`.\nNote that `to import a dimension dir` is `to define the runtime dimension descriptor in the config file`.\n<red>NOTE: If you specify a `wrong seed`, then the `chunk generator` will generate `in-consistent new chunks` compared to your `existing chunks`.\n\n\u25c9 Import a `sky block dimension`.\nLet's say you have a `sky block dimension` whose directory name is `sky_block`.\nYou need to put that `directory` in `world/dimensions/fuji/sky_block`.\n\nAnd issue: `/world import sky_block minecraft:overworld -seed \\<seed\\> --chunkGeneratorType FLAT --chunkGeneratorParameters \"minecraft:air;minecraft:the_void\"`\nThis defines a `runtime dimension descriptor` with `flat chunk generator`, and with `void layers`.\nThe `void layers` means the `flat chunk generator` will fill `minecraft:air` when it is needed to `generate a new chunk`.\n\n\u25c9 Import a `overworld dimension`.\nIssue: `/world import my_overworld minecraft:overworld --seed \\<seed\\>`\nYou need to specify the `dimension type` to define the `environment of your dimension`.\nAnd also the `seed` to define the `seed of your dimension`.\n\n\u25c9 Import a `superflat dimension`.\nIssue: `/world import my_superflat minecraft:overworld --seed \\<seed\\> --chunkGeneratorType FLAT`\n"), @ColorBox(id=1753243335351L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 Use `command_bundle` module to create a `/tpw` command.\nThe `/world tp` command is an `admin-level` command.\nYou can use `command_bundle` module to create a `/tpw resource-world` command, to teleport players to `fuji:overworld`.\n\n\u25c9 Use `tppos` module to teleport the players to a specific world.\n1. `/tppos --dimension minecraft:overworld --x 0 --y 128 --z 0 --yaw 0 --pitch 0`\n2. `/tppos --dimension minecraft:overworld --centerX 0 --centerZ 0 --minRange 0 --maxRange 1000 --maxTryTimes 16`\n")})
@CommandNode(value="world")
@CommandRequirement(level=4)
@TestCases(value={@TestCase(action="In MC 1.20.1, create a `overworld` dimension type with seed `12345`.", targets={"Goto `/tp @s 14665 ~ 345`. (You should get `emerald * 7`, `gold ingot * 3`, `iron ingot * 11`, `tnt * 2`, `heart of the sea * 1`, `cooked cod * 8` and `potion of water breathing * 1`.)", "Goto `/tp @s 0 128 0`, you should in `minecraft:ocean`, and there is a `minecraft:dark_forest` in front of you, also there is a `lava source` flowing down."}), @TestCase(action="Test the chunk generator types and parameters", targets={"Issue `/world create flat minecraft:overworld --chunkGeneratorType FLAT`", "Issue `/world create void minecraft:overworld --chunkGeneratorType FLAT --chunkGeneratorParameters \"minecraft:air;minecraft:the_void\"`"})})
public class WorldInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<WorldConfigModel> config = ObjectConfigurationHandler.ofModule("config.json", WorldConfigModel.class);
    public static final BaseConfigurationHandler<WorldDataModel> world = ObjectConfigurationHandler.ofModule("world.json", WorldDataModel.class).enableAutoSaveFeature("0 * * ? * * *");

    private static void ensureDimensionNotExists(@NotNull class_2168 source, @NotNull class_2960 identifier) {
        if (WorldService.existsDimension(identifier)) {
            TextHelper.sendTextByKey(source, "world.dimension.exist", new Object[0]);
            throw new AbortCommandExecutionException();
        }
    }

    private static void ensureDimensionIsNotVanillaDimension(@NotNull class_2168 source, @NotNull String dimensionId) {
        if (WorldHelper.isVanillaDimension(dimensionId)) {
            TextHelper.sendTextByKey(source, "world.dimension.delete.forbidden", dimensionId);
            throw new AbortCommandExecutionException();
        }
    }

    @Document(id=1751826609063L, value="Teleport to the target dimension with the same coordinate.")
    @CommandNode(value="tp")
    private static int $tp(@CommandSource class_3222 player, Dimension dimension) {
        class_3218 targetDimension = (class_3218)dimension.getValue();
        GlobalPos.of(player).withLevel(RegistryHelper.getIdAsString((class_1937)targetDimension)).teleport(player);
        return 1;
    }

    @Document(id=1752802990626L, value="List `loaded dimensions` and `unloaded dimensions`.\n")
    @CommandNode(value="list")
    private static int $list(@CommandSource class_2168 source) {
        TextHelper.sendTextByKey(source, "dimension.loaded_dimensions", new Object[0]);
        WorldHelper.getWorlds().forEach(world -> {
            String dimensionId = RegistryHelper.getIdAsString((class_1937)world);
            TextHelper.sendTextByKey(source, "dimension", dimensionId);
        });
        List<String> unloadedDimensions = WorldService.getRuntimeDimensionDescriptors().stream().filter(it -> !it.isDimensionLoaded()).map(RuntimeDimensionDescriptor::getDimension).toList();
        TextHelper.sendTextByKey(source, "dimension.unloaded_dimensions", unloadedDimensions);
        return 1;
    }

    @Document(id=1752798248863L, value="This command does the following things:\n1. `Add` a `dimension descriptor` into the `config` file.\n2. Use that `dimension descriptor` to `make` the `runtime dimension`.\n3. `Load` the runtime dimension into the `server`.\n")
    @CommandNode(value="create")
    private static int $create(@CommandSource class_2168 source, FujiIdentifier name, DimensionType dimensionType, Optional<Long> seed, Optional<ChunkGeneratorType> chunkGeneratorType, Optional<String> chunkGeneratorParameters, Optional<WorldPresetType> worldPresetType) {
        class_2960 dimensionIdentifier = (class_2960)name.getValue();
        WorldInitializer.ensureDimensionNotExists(source, dimensionIdentifier);
        long $seed = seed.orElse(class_6673.method_39001());
        ChunkGeneratorType $chunkGeneratorType = chunkGeneratorType.orElse(ChunkGeneratorType.NOISE);
        class_2960 dimensionTypeIdentifier = RegistryHelper.makeIdentifierOrThrow((String)dimensionType.getValue());
        String $chunkGeneratorParameter = chunkGeneratorParameters.orElse("");
        WorldPresetType $worldPresetType = worldPresetType.orElse(null);
        RuntimeDimensionDescriptor runtimeDimensionDescriptor = RuntimeDimensionImporter.importRuntimeDimensionDescriptor(dimensionIdentifier, $worldPresetType, dimensionTypeIdentifier, $chunkGeneratorType, $chunkGeneratorParameter, $seed);
        DimensionCreationTicket ticket = new DimensionCreationTicket(source, runtimeDimensionDescriptor);
        WorldService.submitDimensionCreationTicket(ticket);
        return 1;
    }

    @Document(id=1752809824729L, value="This command will `import` an external `dimension directory` placed in `world/dimensions/fuji/\\<dimension-name\\>`.\nYou need to provide enough information to define the `runtime dimension descriptor`.\n\n<green>NOTE: This command is almost identical to `/world create` command.\n")
    @CommandNode(value="import")
    private static int $import(@CommandSource class_2168 source, FujiIdentifier name, DimensionType dimensionType, Optional<Long> seed, Optional<ChunkGeneratorType> chunkGeneratorType, Optional<String> chunkGeneratorParameters, Optional<WorldPresetType> worldPresetType) {
        class_2960 dimensionId = (class_2960)name.getValue();
        Path targetDimensionPath = RuntimeDimensionImporter.getLevelSavePath().resolve("dimensions").resolve(dimensionId.method_12836()).resolve(dimensionId.method_12832());
        if (!Files.exists(targetDimensionPath, new LinkOption[0])) {
            TextHelper.sendTextByKey(source, "world.dimension.import.dimension_dir_not_found", targetDimensionPath.toFile().getCanonicalPath());
            return 0;
        }
        if (seed.isEmpty()) {
            TextHelper.sendTextByKey(source, "dimension.seed.empty", new Object[0]);
            return 0;
        }
        return WorldInitializer.$create(source, name, dimensionType, seed, chunkGeneratorType, chunkGeneratorParameters, worldPresetType);
    }

    @Document(id=1752798163284L, value="This command does the following things:\n1. `Unload` the `loaded runtime dimension` in the server.\n2. <red><b>Delete the chunk files of the dimension.\n3. <red><b>Delete the `runtime dimension descriptor` in config file.\n")
    @CommandNode(value="delete")
    private static int $delete(@CommandSource class_2168 source, Dimension dimension, Optional<Boolean> confirm) {
        return CommandHelper.Pattern.withCommandConfirmed(source, confirm, () -> {
            class_3218 $dimension = (class_3218)dimension.getValue();
            String dimensionId = RegistryHelper.getIdAsString((class_1937)$dimension);
            WorldInitializer.ensureDimensionIsNotVanillaDimension(source, dimensionId);
            WorldService.submitDimensionDeletionTicket(new DimensionDeletionTicket(source, $dimension, true, true));
            return 1;
        });
    }

    @Document(id=1752798473110L, value="This command does the following things:\n1. `Make` the `runtime dimension` instance based on the `runtime dimension descriptor`.\n2. `Load` the made `runtime dimension` into the `server`.\n")
    @CommandNode(value="load")
    private static int $load(@CommandSource class_2168 source, UnloadedRuntimeDimensionDescriptor dimension) {
        RuntimeDimensionDescriptor runtimeDimensionDescriptor = (RuntimeDimensionDescriptor)dimension.getValue();
        DimensionCreationTicket ticket = new DimensionCreationTicket(source, runtimeDimensionDescriptor);
        WorldService.submitDimensionCreationTicket(ticket);
        TextHelper.sendTextByKey(source, "world.dimension.load", runtimeDimensionDescriptor.dimension);
        return 1;
    }

    @CommandNode(value="unload")
    private static int $unload(@CommandSource class_2168 source, LoadedRuntimeDimensionDescriptor dimension) {
        RuntimeDimensionDescriptor runtimeDimensionDescriptor = (RuntimeDimensionDescriptor)dimension.getValue();
        Optional<class_3218> loadedWorld = runtimeDimensionDescriptor.getLoadedWorld();
        String dimensionId = runtimeDimensionDescriptor.dimension;
        return loadedWorld.map($loadedWorld -> {
            WorldService.submitDimensionDeletionTicket(new DimensionDeletionTicket(source, (class_3218)$loadedWorld, false, false));
            TextHelper.sendTextByKey(source, "world.dimension.unload", dimensionId);
            return 1;
        }).orElseGet(() -> {
            TextHelper.sendTextByKey(source, "world.dimension.unload.already", dimensionId);
            return 0;
        });
    }

    @Document(id=1751826611302L, value="Delete and create the specified world.")
    @CommandNode(value="reset")
    private static int $reset(@CommandSource class_2168 source, Dimension dimension, Optional<Boolean> useTheSameSeed, Optional<Boolean> confirm) {
        return CommandHelper.Pattern.withCommandConfirmed(source, confirm, () -> {
            class_3218 dimensionInstance = (class_3218)dimension.getValue();
            String dimensionIdentifier = RegistryHelper.getIdAsString((class_1937)dimensionInstance);
            Optional<RuntimeDimensionDescriptor> runtimeDimensionDescriptor = WorldService.getRuntimeDimensionDescriptor(dimensionIdentifier);
            return runtimeDimensionDescriptor.map($runtimeDimensionDescriptor -> {
                WorldService.submitDimensionDeletionTicket(new DimensionDeletionTicket(source, dimensionInstance, true, false));
                Boolean $useTheSameSeed = useTheSameSeed.orElse(false);
                $runtimeDimensionDescriptor.seed = $useTheSameSeed != false ? $runtimeDimensionDescriptor.seed : class_6673.method_39001();
                world.writeStorage();
                DimensionCreationTicket ticket = new DimensionCreationTicket(source, (RuntimeDimensionDescriptor)$runtimeDimensionDescriptor);
                WorldService.submitDimensionCreationTicket(ticket);
                TextHelper.sendBroadcastByKey("world.dimension.reset", dimensionIdentifier);
                return 1;
            }).orElseGet(() -> {
                TextHelper.sendTextByKey(source, "world.dimension.dimension_descriptor_not_found", dimensionIdentifier);
                return 0;
            });
        });
    }

    @Document(id=1752248825291L, value="Saves all the `dimension descriptors` from `memory` into the `storage`.\n")
    @CommandNode(value="save-configs")
    @CommandRequirement(level=4)
    private static int $saveConfigs(@CommandSource class_2168 source) {
        WorldService.saveRuntimeDimensionDescriptors();
        TextHelper.sendTextByKey(source, "operation.success", new Object[0]);
        return 1;
    }

    @Document(id=1752433782557L, value="List the dimensions each player is in.\n")
    @CommandNode(value="who")
    @CommandRequirement(level=4)
    private static int $who(@CommandSource class_2168 source) {
        WorldInitializer.printGroupedPlayersByDimension(source, null);
        return 1;
    }

    @Document(id=1752434557605L, value="List the players in specified dimension.\n")
    @CommandNode(value="who")
    @CommandRequirement(level=4)
    private static int $who(@CommandSource class_2168 source, Dimension dimension) {
        WorldInitializer.printGroupedPlayersByDimension(source, dimension);
        return 1;
    }

    private static void printGroupedPlayersByDimension(class_2168 source, @Nullable Dimension specifiedDimension) {
        Map<@NotNull String, List> groupedPlayers = WorldHelper.getWorlds().stream().collect(Collectors.toMap(RegistryHelper::getIdAsString, world -> world.method_18456().stream().map(PlayerHelper::getPlayerName).toList()));
        groupedPlayers.entrySet().stream().filter(entry -> {
            if (specifiedDimension == null) {
                return true;
            }
            String filterDimension = RegistryHelper.getIdAsString((class_1937)specifiedDimension.getValue());
            return ((String)entry.getKey()).equals(filterDimension);
        }).forEach(entry -> {
            String dimensionId = (String)entry.getKey();
            List players = (List)entry.getValue();
            TextHelper.sendTextByKey(source, "world.who.dimension", dimensionId, players);
        });
    }

    @Document(id=1752283075945L, value="List the debug info of specified dimension.\n")
    @CommandNode(value="info")
    @CommandRequirement(level=4)
    private static int $info(@CommandSource class_2168 source, Dimension dimension) {
        class_3218 dimensionInstance = (class_3218)dimension.getValue();
        TextHelper.sendTextByKey(source, "dimension.class", dimensionInstance.getClass().getName());
        TextHelper.sendTextByKey(source, "dimension.id", RegistryHelper.getIdAsString((class_1937)dimensionInstance));
        TextHelper.sendTextByKey(source, "dimension.difficulty", dimensionInstance.method_8407());
        TextHelper.sendTextByKey(source, "dimension.seed", dimensionInstance.method_8412());
        TextHelper.sendTextByKey(source, "dimension.options", dimensionInstance.method_8597());
        TextHelper.sendTextByKey(source, "dimension.properties", dimensionInstance.method_8401());
        TextHelper.sendTextByKey(source, "dimension.chunk_generator", dimensionInstance.method_14178().method_12129());
        class_2784 worldBorder = dimensionInstance.method_8621();
        TextHelper.sendTextByKey(source, "dimension.border", new Object[0]);
        TextHelper.sendTextByKey(source, "dimension.border.size", worldBorder.method_11965());
        TextHelper.sendTextByKey(source, "dimension.border.size.lerp_target", worldBorder.method_11954());
        TextHelper.sendTextByKey(source, "dimension.border.size.lerp_time", worldBorder.method_11962());
        TextHelper.sendTextByKey(source, "dimension.border.center.x", worldBorder.method_11964());
        TextHelper.sendTextByKey(source, "dimension.border.center.z", worldBorder.method_11980());
        TextHelper.sendTextByKey(source, "dimension.border.damage.per_block", worldBorder.method_11953());
        TextHelper.sendTextByKey(source, "dimension.border.safe_zone", worldBorder.method_11971());
        TextHelper.sendTextByKey(source, "dimension.border.warning.blocks", worldBorder.method_11972());
        TextHelper.sendTextByKey(source, "dimension.border.warning.time", worldBorder.method_11956());
        class_5250 gameRulesText = TextHelper.getTextByKey(source, "dimension.gamerules", new Object[0]).method_27661();
        final HashMap gameRulesMap = new HashMap();
        final class_1928 gameRules = dimensionInstance.method_64395();
        gameRules.method_20744(new class_1928.class_4311(){

            public <T extends class_1928.class_4315<T>> void method_20762(class_1928.class_4313<T> key, class_1928.class_4314<T> type) {
                String gameRuleName = key.method_20771();
                class_1928.class_4315 gameRuleValue = gameRules.method_20746(key);
                gameRulesMap.put(gameRuleName, gameRuleValue);
            }
        });
        class_5250 gameRulesHoverText = TextHelper.Formatter.formatMapInLine(gameRulesMap);
        gameRulesText.method_27696(class_2583.field_24360.method_10949(TextHelper.Events.HoverEvent.makeShowTextAction((class_2561)gameRulesHoverText)));
        TextHelper.sendMessageByText(source, (class_2561)gameRulesText);
        TextHelper.sendTextByKey(source, "prompt.hover.see_it", new Object[0]);
        return 1;
    }

    @Override
    protected void registerGsonTypeAdapters() {
        GsonMapper.setTypeNullability(class_1267.class, false);
    }
}

