/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.document.config.writter;

import com.google.gson.FormattingStyle;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Optional;
import mod.fuji.core.auxiliary.ReflectionUtil;
import mod.fuji.core.document.auxiliary.DocumentUtil;
import mod.fuji.module.initializer.document.config.adapter.DocumentedTypeAdapterFactory;
import org.jetbrains.annotations.NotNull;

public class DocumentJsonWriter
extends JsonWriter {
    private final JsonWriter delegate;

    public DocumentJsonWriter(JsonWriter delegate) {
        super(DocumentJsonWriter.getBackendWriter(delegate));
        this.delegate = delegate;
        this.setPrettyFormatting();
    }

    private void setPrettyFormatting() {
        this.setFormattingStyle(FormattingStyle.PRETTY);
    }

    public JsonWriter name(String name) throws IOException {
        Optional<String> documentString = Optional.ofNullable(DocumentedTypeAdapterFactory.FLATTEN_DOCUMENT_STRING_MAP.get(name));
        if (documentString.isPresent()) {
            Writer underlyingWriter = DocumentJsonWriter.getBackendWriter(this.delegate);
            String formattedDocumentString = documentString.get().trim();
            formattedDocumentString = DocumentUtil.Indenter.indentExceptFirstLine(formattedDocumentString, this.getCurrentIndent());
            underlyingWriter.append(this.getLineSeparator()).append(this.getCurrentIndent()).append("/* ").append(formattedDocumentString).append(" */");
        }
        return super.name(name);
    }

    @NotNull
    private static Writer getBackendWriter(@NotNull JsonWriter jsonWriter) {
        return ReflectionUtil.Reflection.getInstanceFieldValue(jsonWriter, "out", Writer.class);
    }

    @NotNull
    private String getCurrentIndent() {
        StringBuilder builder = new StringBuilder();
        String indent = this.getIndent();
        for (int i = 1; i < this.getStackSize(); ++i) {
            builder.append(indent);
        }
        return builder.toString();
    }

    @NotNull
    private String getIndent() {
        FormattingStyle formattingStyle = this.getFormattingStyle();
        return formattingStyle.getIndent();
    }

    @NotNull
    private String getLineSeparator() {
        FormattingStyle formattingStyle = this.getFormattingStyle();
        return formattingStyle.getNewline();
    }

    private int getStackSize() {
        return ReflectionUtil.Reflection.getInstanceFieldValue((Object)this, "stackSize", Integer.class);
    }
}

