/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.fuji.gui;

import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import eu.pb4.sgui.api.gui.SlotGuiInterface;
import java.util.ArrayList;
import java.util.List;
import mod.fuji.core.auxiliary.minecraft.GuiHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.config.Configs;
import mod.fuji.core.config.model.MainControlConfigModel;
import mod.fuji.core.document.annotation.ColorBox;
import mod.fuji.core.document.auxiliary.DocumentUtil;
import mod.fuji.core.document.gui.CommandsInspectionGui;
import mod.fuji.core.gui.component.gui.PagedGui;
import mod.fuji.module.initializer.fuji.FujiInitializer;
import mod.fuji.module.initializer.fuji.gui.AboutGui;
import mod.fuji.module.initializer.fuji.gui.ArgumentTypesInspectionGui;
import mod.fuji.module.initializer.fuji.gui.ConfigurationsInspectionGui;
import mod.fuji.module.initializer.fuji.gui.JobsInspectionGui;
import mod.fuji.module.initializer.fuji.gui.LanguagesInspectionGui;
import mod.fuji.module.initializer.fuji.gui.PermissionsAndMetasInspectionGui;
import mod.fuji.module.initializer.fuji.gui.PlaceholdersInspectionGui;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleDetailsInspectionGui
extends PagedGui<GuiElementInterface> {
    public ModuleDetailsInspectionGui(@Nullable SimpleGui parent, class_3222 player, class_2561 prefixTitle, @NotNull List<GuiElementInterface> entities, int pageIndex) {
        super(parent, player, prefixTitle, entities, pageIndex);
        this.streamMessageIntoToast = false;
    }

    public static void attachThingsForCore(class_3222 player, ModuleDetailsInspectionGui gui, List<GuiElementInterface> entities, String modulePathString) {
        if (!modulePathString.equals("core")) {
            return;
        }
        GuiElementBuilder aboutButton = (GuiElementBuilder)GuiHelper.Button.makeModIconButton().setName(TextHelper.getTextByKey(player, "about", new Object[0])).setLore(List.of(TextHelper.getTextByKey(player, "prompt.click.see_inside", new Object[0]))).setCallback(() -> AboutGui.make(gui.getBackendGui(), player).open());
        entities.add((GuiElementInterface)aboutButton.build());
        GuiElementBuilder userGuideButton = (GuiElementBuilder)new GuiElementBuilder().setItem(class_1802.field_8529).setName(TextHelper.getTextByKey(player, "user_guide", new Object[0])).setLore(List.of(TextHelper.getTextByKey(player, "prompt.click.see_it.any", new Object[0]))).glow().setCallback(() -> {
            gui.closeWithoutOpenParentGui();
            FujiInitializer.$userGuide(player.method_64396());
        });
        entities.add((GuiElementInterface)userGuideButton.build());
        GuiElementBuilder languagesButton = (GuiElementBuilder)new GuiElementBuilder().setItem(class_1802.field_16313).setName(TextHelper.getTextByKey(player, "language", new Object[0])).setLore(List.of(TextHelper.getTextByKey(player, "prompt.click.see_inside", new Object[0]))).setCallback(() -> LanguagesInspectionGui.inspectAll(gui.getBackendGui(), player).open());
        entities.add((GuiElementInterface)languagesButton.build());
        GuiElementBuilder reloadButton = (GuiElementBuilder)new GuiElementBuilder().setItem(class_1802.field_22420).setName(TextHelper.getTextByKey(player, "reload.gui.name", new Object[0])).setLore(List.of(TextHelper.getTextByKey(player, "prompt.click.apply_it", new Object[0]))).setCallback(() -> {
            gui.closeWithoutOpenParentGui();
            FujiInitializer.$reload(player.method_64396());
        });
        entities.add((GuiElementInterface)reloadButton.build());
        MainControlConfigModel.Core.Debug debugConfig = Configs.MAIN_CONTROL_CONFIG.model().core.debug;
        GuiElementBuilder debugButton = (GuiElementBuilder)new GuiElementBuilder().setItem(debugConfig.log_debug_messages ? class_1802.field_8295 : class_1802.field_8586).setName(TextHelper.getTextByKey(player, "debug", new Object[0])).setLore(List.of(TextHelper.getTextByKey(player, "prompt.click.apply_it", new Object[0]))).setCallback(() -> {
            gui.closeWithoutOpenParentGui();
            FujiInitializer.$debug(player.method_64396());
        });
        entities.add((GuiElementInterface)debugButton.build());
        entities.add(GuiHelper.Button.makeSlotPlaceholderButton());
        entities.add(GuiHelper.Button.makeSlotPlaceholderButton());
        entities.add(GuiHelper.Button.makeSlotPlaceholderButton());
        entities.add(GuiHelper.Button.makeSlotPlaceholderButton());
    }

    @Override
    protected PagedGui<GuiElementInterface> makePage(@Nullable SimpleGui parent, @NotNull class_3222 player, class_2561 title, @NotNull List<GuiElementInterface> entities, int pageIndex) {
        return new ModuleDetailsInspectionGui(parent, player, title, entities, pageIndex);
    }

    public static ModuleDetailsInspectionGui inspectModuleDetails(@Nullable SimpleGui parent, @NotNull class_3222 player, @NotNull String modulePathString, boolean moduleEnableStatus) {
        ArrayList<GuiElementInterface> entities = new ArrayList<GuiElementInterface>();
        class_2561 title = TextHelper.getTextByKey(player, "fuji.inspect.module_details.gui.title", modulePathString);
        ModuleDetailsInspectionGui moduleDetailsInspectionGui = new ModuleDetailsInspectionGui(parent, player, title, (List<GuiElementInterface>)entities, 0);
        ModuleDetailsInspectionGui.attachThingsForCore(player, moduleDetailsInspectionGui, entities, modulePathString);
        ModuleDetailsInspectionGui.attachColorBoxes(player, entities, modulePathString);
        SimpleGui trueParent = moduleDetailsInspectionGui.getBackendGui();
        entities.addAll(ModuleDetailsInspectionGui.searchModuleConfigurations(trueParent, player, modulePathString));
        entities.addAll(ModuleDetailsInspectionGui.searchModuleCommands(trueParent, player, modulePathString));
        entities.addAll(ModuleDetailsInspectionGui.searchModulePermissionsAndMetas(trueParent, player, modulePathString));
        entities.addAll(ModuleDetailsInspectionGui.searchModulePlaceholders(trueParent, player, modulePathString));
        entities.addAll(ModuleDetailsInspectionGui.searchModuleJobs(trueParent, player, modulePathString));
        entities.addAll(ModuleDetailsInspectionGui.searchModuleArgumentTypes(trueParent, player, modulePathString));
        if (!moduleEnableStatus) {
            ModuleDetailsInspectionGui.placeModuleDisabledTipsItem(player, moduleDetailsInspectionGui);
        }
        return moduleDetailsInspectionGui;
    }

    private static List<GuiElementInterface> searchModuleJobs(SimpleGui parent, class_3222 player, String modulePathString) {
        return JobsInspectionGui.inspectAll(parent, player).skipCurrentGuiAndSearch(it -> it.getSourceModule().equals(modulePathString)).toGuiElements();
    }

    private static void placeModuleDisabledTipsItem(class_3222 player, ModuleDetailsInspectionGui gui) {
        GuiElementBuilder builder = new GuiElementBuilder().setItem(class_1802.field_8879).setName(TextHelper.getTextByKey(player, "module.status.disabled.gui.name", new Object[0])).setLore(TextHelper.getTextListByKey(player, "module.status.disabled.gui.lore"));
        GuiHelper.Placer.fillEmptySlots((SlotGuiInterface)gui, builder);
    }

    private static void attachColorBoxes(class_3222 player, List<GuiElementInterface> entities, String modulePathString) {
        DocumentUtil.getColorBoxes(modulePathString).forEach(colorBox -> {
            GuiElementBuilder colorboxElementBuilder = new GuiElementBuilder();
            ColorBox.ColorBoxTypes color = colorBox.color();
            class_2561 colorBoxName = TextHelper.getTextByKey(player, color.toLanguageKey(), new Object[0]);
            String documentString = DocumentUtil.getColorBoxString(player, colorBox);
            List<class_2561> colorBoxTextList = TextHelper.getDocumentTextList(player, documentString);
            colorboxElementBuilder.setName(colorBoxName).setItem(color.toItem()).setLore(colorBoxTextList).setCallback(() -> ModuleDetailsInspectionGui.sendColorBoxMessage(player, colorBoxName, colorBoxTextList));
            entities.add((GuiElementInterface)colorboxElementBuilder.build());
        });
    }

    private static void sendColorBoxMessage(class_3222 player, class_2561 colorBoxName, List<class_2561> colorBoxTestList) {
        TextHelper.sendMessageByText(player, colorBoxName);
        colorBoxTestList.forEach(text -> TextHelper.sendMessageByText(player, text));
        TextHelper.sendMessageByText(player, TextHelper.TEXT_EMPTY);
        TextHelper.sendMessageByText(player, TextHelper.TEXT_EMPTY);
    }

    private static List<GuiElementInterface> searchModuleArgumentTypes(@Nullable SimpleGui parent, class_3222 player, String modulePathString) {
        return ArgumentTypesInspectionGui.inspectAll(parent, player).skipCurrentGuiAndSearch(it -> it.getSourceModule().equals(modulePathString)).toGuiElements();
    }

    private static List<GuiElementInterface> searchModuleConfigurations(@Nullable SimpleGui parent, class_3222 player, String modulePathString) {
        return ConfigurationsInspectionGui.inspectAll(parent, player).skipCurrentGuiAndSearch(it -> it.getSourceModule().equals(modulePathString)).toGuiElements();
    }

    private static List<GuiElementInterface> searchModulePlaceholders(@Nullable SimpleGui parent, class_3222 player, String modulePathString) {
        return PlaceholdersInspectionGui.inspectAll(parent, player).skipCurrentGuiAndSearch(it -> it.getSourceModule().equals(modulePathString)).toGuiElements();
    }

    private static List<GuiElementInterface> searchModuleCommands(SimpleGui parent, class_3222 player, String modulePathString) {
        return CommandsInspectionGui.inspectAll(parent, player).skipCurrentGuiAndSearch(it -> it.getSourceModule().equals(modulePathString)).toGuiElements();
    }

    private static List<GuiElementInterface> searchModulePermissionsAndMetas(@Nullable SimpleGui parent, class_3222 player, String modulePathString) {
        return PermissionsAndMetasInspectionGui.inspectAll(parent, player).skipCurrentGuiAndSearch(it -> it.getSourceModule().equals(modulePathString)).toGuiElements();
    }

    @Override
    @NotNull
    protected GuiElementInterface toGuiElement(@NotNull GuiElementInterface entity) {
        return entity;
    }
}

