/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.rank;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import mod.fuji.core.annotation.Unused;
import mod.fuji.core.auxiliary.minecraft.CommandHelper;
import mod.fuji.core.auxiliary.minecraft.PlayerHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.command.annotation.CommandNode;
import mod.fuji.core.command.annotation.CommandRequirement;
import mod.fuji.core.command.annotation.CommandSource;
import mod.fuji.core.config.handler.abst.BaseConfigurationHandler;
import mod.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import mod.fuji.core.document.annotation.ColorBox;
import mod.fuji.core.document.annotation.ColorBoxes;
import mod.fuji.core.document.annotation.Document;
import mod.fuji.core.event.annotation.EventConsumer;
import mod.fuji.core.event.message.server.lifecycle.ServerStartedEvent;
import mod.fuji.module.initializer.ModuleInitializer;
import mod.fuji.module.initializer.rank.RankPlaceholders;
import mod.fuji.module.initializer.rank.command.argument.wrapper.NextAvailableRankNode;
import mod.fuji.module.initializer.rank.command.argument.wrapper.PreviousAvailableRankNode;
import mod.fuji.module.initializer.rank.config.model.RankConfigModel;
import mod.fuji.module.initializer.rank.config.model.RankDataModel;
import mod.fuji.module.initializer.rank.service.RankService;
import mod.fuji.module.initializer.rank.structure.RankNode;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_3222;

@Document(id=1754411151804L, value="This module provides the rank up system.\nIt allows defining a `rank` with `requirements` and `award`.\n")
@ColorBoxes(value={@ColorBox(id=1754450877863L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 How it works?\n1. A `rank node` is used to define a `rank`.\n1.a. A `rank` has basic information, like `id`, `display name` and `description`.\n1.b. A `rank` can have multiple `next ranks`, to construct the `rank paths`.\n1.b.i. From `rank A` to `rank E`, you can define a `rank path` as `A -> B -> C -> D -> E`\n1.b.ii. From `rank A` to `rank E`, you can define another `rank path` as `A -> F -> G -> E`\n1.b.iii. A player can use `/rank up <next-rank>` to choose a `rank path` to `walk`.\n2. A `rank` can have `events`:\n2.a. The `on_enter_this_rank_node_commands` will be executed when a player `enter` this `rank`.\n2.b. The `on_lave_this_rank_node_commands` will be executed when a player `leave` this `rank`.\n2.c. The `on_first_enter_this_rank_node_commands` will be executed when a player `the first time enter` this `rank`.\n3. A `rank` can have `requirements`.\n3.a. A player must meet all the `requirements`, so that the `/rank up <next-rank>` command can be executed successfully.\n3.b. The admin can use `/rank set <player> <rank>` command to `force set` a player's rank. (Ignore requirements)\n3.c. A player can use `/rank down <rank>` to `rank down` to a previously `earned rank`.\n3.d. The admin can use `/rank remove <player>` to set a player's rank to `none`.\n"), @ColorBox(id=1754466653435L, color=ColorBox.ColorBoxTypes.TIP, value="\u25c9 Automatic rank up to the only available next rank.\nYou can use `command_schedule` module to define a job.\nTo execute the `/rank try-up %player:name%` command for each online player.\nSo that each player will get auto rank up if there is only one `available next rank` for them.\nIt can be `/execute as @a run rank try-up @s` or `/foreach rank try-up %player:name%`\n"), @ColorBox(id=1754451752816L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 List rank nodes by type\n1. `/rank list all-rank-nodes`\n2. `/rank list starting-rank-nodes Steve`\n3. `/rank list next-rank-nodes Steve`\n4. `/rank list previous-rank-nodes Steve`\n5. `/rank list walked-rank-nodes Steve`\n\n\u25c9 Query the info of a rank\nIssue: `/rank info newbie`\n\n\u25c9 Query current rank progress\n1. `/rank progress`\n2. `/rank progress Steve`\n\n\u25c9 Rank up to a specified rank\nIssue: `/rank up branch-1 --confirm true`\n\n\u25c9 Rank down to a `walked rank`\nIssue: `/rank down branch-1 --confirm true`\n<red>NOTE: If you `rank down` from this rank node, you must meet its `requirements` again before you can `rank back up` to it.\n\n\u25c9 Set a player's rank to none\nIssue: `/rank remove Steve --confirm true`.\n"), @ColorBox(id=1754465524369L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 Allow a player to choose an `intermediate rank` as their `starting rank`.\nYou can define one `starting rank node` as the public `starting rank node` for all players.\nHowever, you can also allow some players to pick other `rank nodes` as their starting rank node, and skip some path.\nIssue: `/lp group default permission set fuji.rank.starting_rank_node.branch-1-3`\nThis will allow players to pick `branch-1-3` as their `starting rank node`.\nYou can define multiple `starting rank nodes` for different `luckperms groups`.\n")})
public class RankInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<RankConfigModel> config = ObjectConfigurationHandler.ofModule("config.json", RankConfigModel.class);
    public static final BaseConfigurationHandler<RankDataModel> data = ObjectConfigurationHandler.ofModule("rank-data.json", RankDataModel.class);

    @Document(id=1754412528895L, value="List all defined `rank nodes`.")
    @CommandNode(value="rank list all-rank-nodes")
    @CommandRequirement(level=4)
    private static int $listAllRankNodes(@CommandSource class_2168 source) {
        TextHelper.sendTextByKey(source, "rank.list.all_rank_nodes", RankService.getAllRankIds());
        return 1;
    }

    @Document(id=1754412670219L, value="Query the info of the specified `rank node`.")
    @CommandNode(value="rank info")
    @CommandRequirement(level=4)
    private static int $info(@CommandSource class_2168 source, RankNode rankNode) {
        RankService.sendRankNodeInfo(source, rankNode, true);
        return 1;
    }

    @Document(id=1754414840437L, value="List all available `starting rank nodes` for the specified player.")
    @CommandNode(value="rank list starting-rank-nodes")
    @CommandRequirement(level=4)
    private static int $listStartingRankNodes(@CommandSource class_2168 source, class_3222 target) {
        String playerName = PlayerHelper.getPlayerName((class_1657)target);
        List<String> availableStartingRankNodes = RankService.getAvailableStartingRankNodes(target).stream().map(RankNode::getId).toList();
        TextHelper.sendTextByKey(source, "rank.list.starting_rank_nodes", playerName, availableStartingRankNodes);
        return 1;
    }

    @Document(id=1754415572673L, value="Query the rank progress of the specified player.")
    @CommandNode(value="rank progress")
    @CommandRequirement(level=4)
    private static int $rankProgress(@CommandSource class_2168 source, class_3222 target) {
        return RankService.getCurrentRankNode(target).map(currentRankNode -> {
            RankService.sendRankNodeInfo(source, currentRankNode, false);
            return 1;
        }).orElseGet(() -> {
            String playerName = PlayerHelper.getPlayerName((class_1657)target);
            TextHelper.sendTextByKey(source, "rank.progress.no_rank", playerName);
            return 0;
        });
    }

    @Document(id=1754420858807L, value="Query the rank progress.")
    @CommandNode(value="rank progress")
    private static int $rankProgress(@CommandSource class_3222 player) {
        return RankInitializer.$rankProgress(player.method_64396(), player);
    }

    @Document(id=1754417962937L, value="Set the rank for specified player.")
    @CommandNode(value="rank set")
    @CommandRequirement(level=4)
    private static int $setRank(@CommandSource class_2168 source, class_3222 target, RankNode rankNode) {
        RankService.moveTo(target, rankNode);
        TextHelper.sendTextByKey(source, "rank.set", PlayerHelper.getPlayerName((class_1657)target), rankNode.getId());
        return 1;
    }

    @Document(id=1754418507342L, value="Rank up to the next available rank node.")
    @CommandNode(value="rank up")
    private static int $rankUp(@CommandSource class_3222 player, NextAvailableRankNode nextRank, Optional<Boolean> confirm) {
        return CommandHelper.Pattern.withCommandConfirmed(player, confirm, () -> {
            RankNode $nextRank = (RankNode)nextRank.getValue();
            RankService.tryMoveTo(player, $nextRank);
            return 1;
        });
    }

    @Document(id=1754423529102L, value="Rank down to the previous available rank node.")
    @CommandNode(value="rank down")
    private static int $rankDown(@CommandSource class_3222 player, PreviousAvailableRankNode previousRank, Optional<Boolean> confirm) {
        return CommandHelper.Pattern.withCommandConfirmed(player, confirm, () -> {
            RankNode $previousRank = (RankNode)previousRank.getValue();
            RankService.moveTo(player, $previousRank);
            TextHelper.sendTextByKey(player, "rank.down", $previousRank.getDisplayName());
            return 1;
        });
    }

    @Document(id=1754421296792L, value="Set the specified player's rank to none.")
    @CommandNode(value="rank remove")
    @CommandRequirement(level=4)
    private static int $removeRank(@CommandSource class_2168 source, class_3222 player, Optional<Boolean> confirm) {
        return CommandHelper.Pattern.withCommandConfirmed(source, confirm, () -> {
            RankService.moveTo(player, null);
            TextHelper.sendTextByKey(source, "rank.remove", PlayerHelper.getPlayerName((class_1657)player));
            return 1;
        });
    }

    @Document(id=1754424553830L, value="List all available `next rank nodes` for the specified player.")
    @CommandNode(value="rank list next-rank-nodes")
    @CommandRequirement(level=4)
    private static int $listNextRankNodes(@CommandSource class_2168 source, class_3222 target) {
        String playerName = PlayerHelper.getPlayerName((class_1657)target);
        List<String> ids = RankService.getNextAvailableRankNodes(target).stream().map(RankNode::getId).toList();
        TextHelper.sendTextByKey(source, "rank.list.next_rank_nodes", playerName, ids);
        return 1;
    }

    @Document(id=1754424619470L, value="List all available `previous rank nodes` for the specified player.")
    @CommandNode(value="rank list previous-rank-nodes")
    @CommandRequirement(level=4)
    private static int $listPreviousRankNodes(@CommandSource class_2168 source, class_3222 target) {
        String playerName = PlayerHelper.getPlayerName((class_1657)target);
        List<String> ids = RankService.getPreviousAvailableRankNodes(target).stream().map(RankNode::getId).toList();
        TextHelper.sendTextByKey(source, "rank.list.previous_rank_nodes", playerName, ids);
        return 1;
    }

    @Document(id=1754430022210L, value="List all `walked rank nodes` for the specified player.")
    @CommandNode(value="rank list walked-rank-nodes")
    @CommandRequirement(level=4)
    private static int $listWalkedRankNodes(@CommandSource class_2168 source, class_3222 target) {
        String playerName = PlayerHelper.getPlayerName((class_1657)target);
        Set<String> ids = RankService.getWalkedRankNodeIds(target);
        TextHelper.sendTextByKey(source, "rank.list.walked_rank_nodes", playerName, ids);
        return 1;
    }

    @Document(id=1754466143852L, value="If there is only one `next rank node` for the player, then rank up to that node, else do nothing.")
    @CommandNode(value="rank try-up")
    @CommandRequirement(level=4)
    private static int $tryUp(@CommandSource class_2168 source, class_3222 target) {
        List<RankNode> nextAvailableRankNodes = RankService.getNextAvailableRankNodes(target);
        if (nextAvailableRankNodes.size() != 1) {
            return 0;
        }
        NextAvailableRankNode theOnlyNode = new NextAvailableRankNode(nextAvailableRankNodes.get(0));
        RankInitializer.$rankUp(target, theOnlyNode, Optional.of(true));
        return 1;
    }

    @EventConsumer
    private static void onServerStarted(@Unused ServerStartedEvent event) {
        RankService.computeRankGraph();
    }

    @Override
    protected void onReload() {
        RankService.computeRankGraph();
    }

    @Override
    protected void registerPlaceholders() {
        RankPlaceholders.registerRankIdPlaceholder();
        RankPlaceholders.registerRankDisplayNamePlaceholder();
        RankPlaceholders.registerRankDisplayNameRawPlaceholder();
    }
}

