/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.tpa.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import mod.fuji.core.auxiliary.minecraft.PlayerHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.job.impl.PlaySoundJob;
import mod.fuji.core.structure.GlobalPos;
import mod.fuji.module.initializer.tpa.TpaInitializer;
import mod.fuji.module.initializer.tpa.structure.ResponseStatus;
import mod.fuji.module.initializer.tpa.structure.TpaMessenger;
import mod.fuji.module.initializer.tpa.structure.TpaRequest;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class TpaService {
    private static final List<TpaRequest> requests = new ArrayList<TpaRequest>();

    public static int doRequest(class_3222 source, class_3222 target, boolean tpahere) {
        if (target.method_31481()) {
            TextHelper.sendTextByKey(source, "player.invalid", PlayerHelper.getPlayerName((class_1657)target));
            return 0;
        }
        TpaRequest request = new TpaRequest(source, target, tpahere);
        if (request.getSender().equals((Object)request.getReceiver())) {
            TextHelper.sendTextByKey(request.getSender(), "tpa.request_to_self", new Object[0]);
            return 0;
        }
        if (requests.stream().anyMatch(request::isSimilarTo)) {
            TextHelper.sendTextByKey(request.getSender(), "tpa.similar_request_exists", new Object[0]);
            return 0;
        }
        requests.add(request);
        request.startTimeout();
        PlaySoundJob.scheduleJob(TpaInitializer.config.model().getMentionPlayer(), request.getReceiver());
        TextHelper.sendMessageByText(request.getReceiver(), (class_2561)TpaMessenger.toReceiverText$Sent(request));
        TextHelper.sendMessageByText(request.getSender(), (class_2561)TpaMessenger.toSenderText$Sent(request));
        return 1;
    }

    public static int doResponse(class_3222 player, class_3222 target, ResponseStatus status) {
        Optional<TpaRequest> requestOpt = requests.stream().filter(request -> status == ResponseStatus.CANCEL ? request.getSender().equals((Object)player) && request.getReceiver().equals((Object)target) : request.getSender().equals((Object)target) && request.getReceiver().equals((Object)player)).findFirst();
        if (requestOpt.isEmpty()) {
            TextHelper.sendTextByKey(player, "tpa.no_relative_ticket", new Object[0]);
            return 0;
        }
        TpaRequest request2 = requestOpt.get();
        if (status == ResponseStatus.ACCEPT) {
            class_3222 who = request2.getTeleportWho();
            class_3222 to = request2.getTeleportTo();
            PlaySoundJob.scheduleJob(TpaInitializer.config.model().getMentionPlayer(), request2.isTpahere() ? to : who);
            new GlobalPos((class_1937)PlayerHelper.getServerWorld(to), to.method_23317(), to.method_23318(), to.method_23321(), to.method_36454(), to.method_36455()).teleport(who);
            TextHelper.sendText(request2.getSender(), (class_2561)TpaMessenger.toSenderText$Accepted(request2), TextHelper.Sender.TextLocation.ACTION_BAR);
            TextHelper.sendMessageByText(request2.getReceiver(), (class_2561)TpaMessenger.toReceiverText$Accepted(request2));
        } else if (status == ResponseStatus.DENY) {
            TextHelper.sendText(request2.getSender(), (class_2561)TpaMessenger.toSenderText$Denied(request2), TextHelper.Sender.TextLocation.ACTION_BAR);
            TextHelper.sendMessageByText(request2.getReceiver(), (class_2561)TpaMessenger.toReceiverText$Denied(request2));
        } else if (status == ResponseStatus.CANCEL) {
            TextHelper.sendMessageByText(request2.getSender(), (class_2561)TpaMessenger.toSenderText$Cancelled(request2));
            TextHelper.sendMessageByText(request2.getReceiver(), (class_2561)TpaMessenger.toReceiverText$Cancelled(request2));
        }
        request2.cancelTimeout();
        requests.remove(request2);
        return 1;
    }

    public static int doResponseToAll(class_3222 me, ResponseStatus responseStatus) {
        ArrayList targetPlayers = requests.stream().filter(request -> {
            if (responseStatus == ResponseStatus.CANCEL) {
                return request.getSender().equals((Object)me);
            }
            return request.getReceiver().equals((Object)me);
        }).collect(Collectors.toCollection(ArrayList::new));
        targetPlayers.forEach(request -> {
            class_3222 responseTarget = responseStatus == ResponseStatus.CANCEL ? request.getReceiver() : request.getSender();
            TpaService.doResponse(me, responseTarget, responseStatus);
        });
        return 1;
    }

    @Generated
    public static List<TpaRequest> getRequests() {
        return requests;
    }
}

