/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.view;

import mod.fuji.core.auxiliary.minecraft.PlayerHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.command.annotation.CommandNode;
import mod.fuji.core.command.annotation.CommandRequirement;
import mod.fuji.core.command.annotation.CommandSource;
import mod.fuji.core.command.argument.wrapper.impl.OfflinePlayerName;
import mod.fuji.core.command.exception.AbortCommandExecutionException;
import mod.fuji.core.document.annotation.Document;
import mod.fuji.core.document.annotation.TestCase;
import mod.fuji.module.initializer.ModuleInitializer;
import mod.fuji.module.initializer.view.gui.EnderChestRedirectScreenFactory;
import mod.fuji.module.initializer.view.gui.InventoryRedirectScreenFactory;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import net.minecraft.class_3908;

@Document(id=1751824970923L, value="Allow you to edit a player's `slots`.\n\n1. Edit an online/offline player's `inventory`.\n2. Edit an online/offline player's `enderchest`.\n")
@CommandNode(value="view")
@CommandRequirement(level=4)
@TestCase(action="Issue the `/view {inv/ender}` command on a fake-player.", targets={"You should be able to modify the slots on the fly."})
public class ViewInitializer
extends ModuleInitializer {
    private static void checkSelfView(class_3222 source, OfflinePlayerName target) {
        String targetPlayerName;
        String sourcePlayerName = PlayerHelper.getPlayerName((class_1657)source);
        if (sourcePlayerName.equals(targetPlayerName = (String)target.getValue())) {
            TextHelper.sendTextByKey(source, "view.failed.self_view", new Object[0]);
            throw new AbortCommandExecutionException();
        }
    }

    @Document(id=1751824976609L, value="View the player's inventory.")
    @CommandNode(value="inv")
    private static int $inv(@CommandSource class_3222 source, OfflinePlayerName target) {
        ViewInitializer.checkSelfView(source, target);
        source.method_17355((class_3908)new InventoryRedirectScreenFactory(source, (String)target.getValue()).makeFactory());
        return 1;
    }

    @Document(id=1751824982580L, value="View the player's enderchest.")
    @CommandNode(value="ender")
    private static int $ender(@CommandSource class_3222 source, OfflinePlayerName target) {
        ViewInitializer.checkSelfView(source, target);
        source.method_17355((class_3908)new EnderChestRedirectScreenFactory(source, (String)target.getValue()).makeFactory());
        return 1;
    }
}

