/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.command_alias.structure;

import com.google.errorprone.annotations.Keep;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import java.lang.reflect.Method;
import java.util.List;
import mod.fuji.core.auxiliary.LogUtil;
import mod.fuji.core.command.argument.structure.CommandArgument;
import mod.fuji.core.command.descriptor.CommandDescriptor;
import mod.fuji.core.document.annotation.TestCase;
import net.minecraft.class_2168;
import org.jetbrains.annotations.NotNull;

public class AliasCommandDescriptor
extends CommandDescriptor {
    private final CommandNode<class_2168> redirectTargetCommandNode;

    public AliasCommandDescriptor(@NotNull List<CommandArgument> commandArguments, @NotNull CommandNode<class_2168> redirectTargetCommandNode) {
        super(AliasCommandDescriptor.getDummyMethod(), commandArguments);
        this.redirectTargetCommandNode = redirectTargetCommandNode;
    }

    @Override
    @TestCase(action="Test the redirect functionality.", targets={"The redirect target command is a non-leaf command: `/invsee` -> `/view inv`", "The redirect target command is a leaf command: `/wb` -> `/workbench`", "The redirect target command already registered (no args): `/help` -> `/warp`", "The redirect target command already registered (with args): `/workbench` -> `/say`", "The redirect target command already registered (with branches): `/home` -> `/warp`", "The chained command redirect (1-hop redirect): `/wb -> /workbench -> /warp`", "The chained command redirect (2-hop redirect): `/wb -> /workbench -> /say`", "The duplicated command redirect: `/wb -> /wb -> /wb`"})
    @NotNull
    protected ArgumentBuilder<class_2168, ?> terminalArgumentDecorator(@NotNull ArgumentBuilder<class_2168, ?> terminalArgumentBuilder) {
        return terminalArgumentBuilder.executes(this.redirectTargetCommandNode.getCommand()).redirect(this.redirectTargetCommandNode);
    }

    @Keep
    private static int dummyCommandActionMethod() {
        LogUtil.warn("The dummy method for redirect command descriptor is called. You should never see this.", new Object[0]);
        return 1;
    }

    private static Method getDummyMethod() {
        Method dummyMethod = AliasCommandDescriptor.class.getDeclaredMethod("dummyCommandActionMethod", new Class[0]);
        dummyMethod.setAccessible(true);
        return dummyMethod;
    }
}

