/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.command_meta.run;

import mod.fuji.core.command.annotation.CommandNode;
import mod.fuji.core.command.annotation.CommandRequirement;
import mod.fuji.core.command.annotation.CommandSource;
import mod.fuji.core.command.argument.wrapper.impl.GreedyCommandString;
import mod.fuji.core.command.executor.CommandExecutor;
import mod.fuji.core.command.executor.structure.ExtendedCommandSource;
import mod.fuji.core.document.annotation.ColorBox;
import mod.fuji.core.document.annotation.ColorBoxes;
import mod.fuji.core.document.annotation.Document;
import mod.fuji.module.initializer.ModuleInitializer;
import net.minecraft.class_2168;
import net.minecraft.class_3222;

@Document(id=1751823988812L, value="Provides `/run` command, to run a command with context.\n")
@ColorBoxes(value={@ColorBox(id=1752982945496L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 What is the difference between `/run` and `/execute` command?\n1. The main purpose of `/run` command is to `modify the command context` while executing a `command` instance.\n2. The `/run` command will parse `placeholders` like `%player:name%`. (However, you can still use vanilla target selector, but NOT recommended)\n3. The `/run as {player/fake-op/console}` allows you to switch the `role` of the `command source` easily.\n\n\u25c9 A `command` is executed with a `command context`.\nIn internal Minecraft, when you submit a `command` to the `command executor`. You need to provide a `command context`.\nA `command context` contains important information like:\n1. `the command source`\n2. `the value of command arguments`\n3. `the executing dimension`\n4. `the execution position`\n5. `the executing permission level`\nAnd more.\n\n\u25c9 The `/run` command can be used to switch the `command context`.\nYou can use `/run as player` to modify the `command source` to another player.\nIf player `Alice` issues the `/run as player Bob say I am %player:name%`.\nThen the `initializing command source` is `Alice`, and `executing command source` is `Bob`.\nWe will report `command exception` to both the `initializing command source` and `executing command source`.\nWe will use player `Bob` as the `contextual player` to `parse placeholders`.\nSo the result is: The player `Bob` executes the `/say I am Bob` command.\n\n\u25c9 How the `/run as fake-op` works?\nWhen you issue `/run as fake-op Alice say Hi`, the `/run` command will modify the `command context`.\nTo make the `command executor` treat the player `Alice` as if he has a `level permission` of `4`.\n\nThe effect is like: We `/op` the player `Alice`, and the console executes `/run as player Alice say Hi`, then we `/deop` the player `Alice`.\nHowever, we didn't actually `/op` the player `Alice`.\nWhat we do is simple, we just tell the `command executor` to treat the player `Alice` as if he has a `level permission` of `4` when executing `this command` instance.\n"), @ColorBox(id=1751968631536L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 Execute a command as a specified player.\nIssue: `/run as player Alice back`\n\n\u25c9 Execute a command as a fake-op.\nIssue: `/run as fake-op Alice give %player:name% minecraft:apple 1`\n\n\u25c9 Give random amount of diamonds to online players.\nIssue: `/run as console give @a minecraft:diamond %fuji:random 8 32%`\n\n\u25c9 Give online players random amount of diamonds.\nIssue: `/run as console foreach give %fuji:escape player:name% minecraft:diamond %fuji:escape fuji:random 8 32 1%`\n"), @ColorBox(id=1753585969328L, color=ColorBox.ColorBoxTypes.WARNING, value="\u25c9 Be careful with the vanilla Minecraft `target selector`.\nThe vanilla Minecraft `target selectors` are: `@a`, `@e`, `@n`, `@p`, `@r` and `@s`.\nThey are used to select the value for `Player` argument type and `Entity` argument type:\n1. The `@a` in `/give @a minecraft:apple` will `select` all online players. (Player Argument)\n2. The `@e` in `/kill @e` will `select` all entities. (Entity Argument)\nRemember, the `target selector` can only be used to select specific `argument types`, like the `Player` and `Entity`.\n\nHowever, the `%player:name%` is a `placeholder` which will always be replaced with `the contextual player`.\nIf you want to specify the name of `the contextual player`, you should use a `placeholder`, because it always works.\nFor example:\n1. `/run as console say I am @s` will say `I am @s`\n2. `/run as console say I am %player:name%` will say `I am Steve` (Assume that your account is named `Steve`)\n\nNOTE: The `@s` does work if you use `/execute as @a run say I am @s` (If you actually know what you are doing.)\n\nAnyway, if you are trying to mix the usage of `target selector` and `placeholders`, you must be careful with the `semantics`.\n\n\u25c9 The semantics of `@p` and `%player:name%`.\nAll fuji commands that execute a command, will try to parse the `placeholders`.\nSo, you can insert placeholders like `%player:name%` in `/run as console say I am %player:name%` command.\n\nThe `@p` is just a `target selector`, you can use it with the `/execute` command.\nHowever, you should not use `/run as console give @p minecraft:apple`.\nThe `@p` will select `the nearest player` as the value of `Player Argument`.\nThen here comes the question: `Which player is considered as the nearest player to the console?`\nThe answer is: The `console` is considered as a dummy player in the spawnpoint of `minecraft:overworld`.\nSo if you use `@p` with `/run as console` command, then there will be `in-consistent`.\nThe player referred to by the `@p` will be in-consistent.\nIt depends on which player is the closest player to the spawnpoint of `minecraft:overworld` at that time.\n")})
@CommandNode(value="run")
@CommandRequirement(level=4)
public class RunInitializer
extends ModuleInitializer {
    @Document(id=1751823993461L, value="Execute a command as console.")
    @CommandNode(value="as console")
    private static int $runAsConsole(@CommandSource class_2168 source, GreedyCommandString rest) {
        CommandExecutor.executeSingle(ExtendedCommandSource.asConsole(source), (String)rest.getValue());
        return 1;
    }

    @Document(id=1751823999061L, value="Execute a command as a player.")
    @CommandNode(value="as player")
    private static int $runAsPlayer(@CommandSource class_2168 source, class_3222 player, GreedyCommandString rest) {
        return CommandExecutor.executeSingle(ExtendedCommandSource.asPlayer(source, player), (String)rest.getValue());
    }

    @Document(id=1751824003937L, value="Execute a command as a player with fake-op.")
    @CommandNode(value="as fake-op")
    private static int $runAsFakeOp(@CommandSource class_2168 source, class_3222 player, GreedyCommandString rest) {
        return CommandExecutor.executeSingle(ExtendedCommandSource.asFakeOp(source, player), (String)rest.getValue());
    }
}

