/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.auxiliary.minecraft;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import mod.fuji.core.annotation.Unused;
import mod.fuji.core.auxiliary.LogUtil;
import mod.fuji.core.auxiliary.minecraft.PlayerHelper;
import mod.fuji.core.auxiliary.minecraft.RegistryHelper;
import mod.fuji.core.auxiliary.minecraft.ServerHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.command.extension.CommandNodeExtension;
import mod.fuji.core.command.processor.CommandAnnotationProcessor;
import mod.fuji.core.command.structure.RegisteredCommandNode;
import mod.fuji.core.command.suggestion.CommandSuggestionOptimizer;
import mod.fuji.core.config.mapper.wrapper.GameProfileWrapper;
import mod.fuji.core.document.annotation.TestCase;
import net.minecraft.class_11560;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2378;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7157;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandHelper {
    @NotNull
    public static CommandDispatcher<class_2168> getCommandDispatcher() {
        return CommandAnnotationProcessor.COMMAND_DISPATCHER;
    }

    @NotNull
    public static class_7157 getCommandRegistryAccess() {
        return CommandAnnotationProcessor.COMMAND_REGISTRY_ACCESS;
    }

    public static class Context {
        public static <T> Optional<T> tryGetArgument(@NotNull CommandContext<?> commandContext, String argumentName, Class<T> clazz) {
            try {
                return Optional.ofNullable(commandContext.getArgument(argumentName, clazz));
            }
            catch (Exception e) {
                return Optional.empty();
            }
        }
    }

    public static class Pattern {
        public static int withServerPlayerCommand(@NotNull class_2168 source, @NotNull Function<class_3222, Integer> function) {
            class_3222 player = source.method_44023();
            if (player == null) {
                TextHelper.sendTextByKey(source, "command.player_only", new Object[0]);
                return 1;
            }
            return function.apply(player);
        }

        public static int withItemInMainHandCommand(@NotNull class_3222 source, @NotNull Function<class_1799, Integer> consumer) {
            class_2168 commandSource = Source.getCommandSource(source);
            return Pattern.withItemInMainHandCommand(commandSource, (class_3222 player, class_1799 item) -> (Integer)consumer.apply((class_1799)item));
        }

        public static int withItemInMainHandCommand(@NotNull class_2168 source, @NotNull BiFunction<class_3222, class_1799, Integer> consumer) {
            return Pattern.withServerPlayerCommand(source, player -> {
                class_1799 mainHandStack = player.method_6047();
                if (mainHandStack.method_7960()) {
                    TextHelper.sendTextByKey(player, "item.empty.not_allow", new Object[0]);
                    return 0;
                }
                return (Integer)consumer.apply((class_3222)player, mainHandStack);
            });
        }

        public static int withCommandConfirmed(class_3222 player, Optional<Boolean> confirm, Supplier<Integer> supplier) {
            return Pattern.withCommandConfirmed(Source.getCommandSource(player), confirm, supplier);
        }

        public static int withCommandConfirmed(class_2168 source, Optional<Boolean> confirm, Supplier<Integer> supplier) {
            boolean confirmed = confirm.orElse(false);
            if (!confirmed) {
                TextHelper.sendTextByKey(source, "operation.confirm.failed", new Object[0]);
                return 0;
            }
            int commandReturnValue = supplier.get();
            return commandReturnValue;
        }
    }

    public static class Suggestion {
        @NotNull
        private static <T> CompletableFuture<Suggestions> makeSuggestionsCompletableFuture(@NotNull SuggestionsBuilder builder, @NotNull Supplier<Iterable<T>> iterableSupplier) {
            Iterable<T> iterable = iterableSupplier.get();
            CommandSuggestionOptimizer.optimize(iterable, builder.getRemaining()).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        }

        @NotNull
        public static <T> SuggestionProvider<class_2168> iterable(@NotNull BiFunction<CommandContext<class_2168>, SuggestionsBuilder, Iterable<T>> iterableSupplier) {
            return (context, builder) -> Suggestion.makeSuggestionsCompletableFuture(builder, () -> (Iterable)iterableSupplier.apply(context, builder));
        }

        @NotNull
        public static <T> SuggestionProvider<class_2168> iterable(@NotNull Supplier<Iterable<T>> iterableSupplier) {
            return (context, builder) -> Suggestion.makeSuggestionsCompletableFuture(builder, iterableSupplier);
        }

        @NotNull
        public static <T> SuggestionProvider<class_2168> enums(@NotNull Supplier<T[]> enumValuesSupplier) {
            return Suggestion.iterable(() -> Arrays.asList((Object[])enumValuesSupplier.get()));
        }

        @NotNull
        public static <T> SuggestionProvider<class_2168> identifiers(@NotNull class_5321<? extends class_2378<T>> registryKey) {
            return Suggestion.iterable(() -> RegistryHelper.getRegistry(registryKey).method_10235());
        }

        @NotNull
        public static Suggestions listSuggestions(@NotNull class_2168 commandSource, @NotNull String commandString) {
            CommandDispatcher<class_2168> commandDispatcher = CommandHelper.getCommandDispatcher();
            ParseResults parse = commandDispatcher.parse(commandString, (Object)commandSource);
            CompletableFuture completionSuggestions = commandDispatcher.getCompletionSuggestions(parse);
            return (Suggestions)completionSuggestions.join();
        }
    }

    public static class Parser {
        @NotNull
        public static String stripTrailingButKeepOne(@NotNull String input) {
            String result = input.stripTrailing();
            if (result.length() != input.length()) {
                return result + " ";
            }
            return result;
        }
    }

    public static class Return {
        public static final int FAILURE = 0;
        public static final int SUCCESS = 1;

        private static int fromBoolean(boolean value) {
            return value ? 1 : 0;
        }

        public static int returnBoolean(@Unused class_2168 source, boolean value) {
            return Return.fromBoolean(value);
        }

        public static boolean isSuccess(int commandReturnValue) {
            return commandReturnValue > 0;
        }
    }

    public static class Source {
        @NotNull
        public static class_2168 getConsoleCommandSource() {
            return ServerHelper.getServer().method_3739();
        }

        @NotNull
        public static class_2168 getCommandSource(@NotNull class_3222 player) {
            return player.method_64396();
        }

        public static void withServerPlayerEntity(@NotNull CommandContextBuilder<class_2168> contextBuilder, @NotNull Consumer<class_3222> consumer) {
            @NotNull class_2168 source = (class_2168)contextBuilder.getSource();
            Source.withServerPlayerEntity(source, consumer);
        }

        public static void withServerPlayerEntity(@NotNull CommandContext<?> context, @NotNull Consumer<class_3222> consumer) {
            @NotNull Object source = context.getSource();
            if (source instanceof class_2168) {
                class_2168 serverCommandSource = (class_2168)source;
                Source.withServerPlayerEntity(serverCommandSource, consumer);
                return;
            }
        }

        public static void withServerPlayerEntity(@NotNull class_2168 serverCommandSource, @NotNull Consumer<class_3222> consumer) {
            if (Source.isExecutedByPlayer(serverCommandSource)) {
                consumer.accept(serverCommandSource.method_44023());
            }
        }

        public static void withServerCommandSource(@NotNull Object indicator, @NotNull Consumer<class_2168> consumer) {
            if (Source.isServerCommandSource(indicator = Source.extractCommandSource(indicator))) {
                @NotNull class_2168 serverCommandSource = (class_2168)indicator;
                consumer.accept(serverCommandSource);
            }
        }

        public static void withServerCommandSource(@NotNull Object indicator, @NotNull Runnable runnable) {
            Source.withServerCommandSource(indicator, (class_2168 serverCommandSource) -> runnable.run());
        }

        public static <S> boolean isExecutedOnServerSide(@NotNull CommandContextBuilder<S> context) {
            Object source = context.getSource();
            return Source.isExecutedOnServerSide(source);
        }

        public static boolean isExecutedOnServerSide(@NotNull Object indicator) {
            indicator = Source.extractCommandSource(indicator);
            return Source.isServerCommandSource(indicator);
        }

        public static boolean isExecutedByConsole(@NotNull CommandContext<class_2168> commandContext) {
            @NotNull class_2168 source = (class_2168)commandContext.getSource();
            return Source.isExecutedByConsole(source);
        }

        public static boolean isExecutedByConsole(@NotNull class_2168 commandSource) {
            return !Source.isExecutedByPlayer(commandSource);
        }

        public static boolean isExecutedByPlayer(@NotNull CommandContext<class_2168> commandContext) {
            @NotNull class_2168 source = (class_2168)commandContext.getSource();
            return Source.isExecutedByPlayer(source);
        }

        public static boolean isExecutedByPlayer(@NotNull class_2168 commandSource) {
            return commandSource.method_44023() != null;
        }

        public static boolean isSilent(@NotNull class_2168 commandSource) {
            return commandSource.field_9823;
        }

        private static boolean isServerCommandSource(@NotNull Object object) {
            return object instanceof class_2168;
        }

        @NotNull
        private static Object extractCommandSource(@NotNull Object object) {
            if (object instanceof CommandContext) {
                CommandContext commandContext = (CommandContext)object;
                object = commandContext.getSource();
            }
            if (object instanceof CommandContextBuilder) {
                CommandContextBuilder commandContextBuilder = (CommandContextBuilder)object;
                object = commandContextBuilder.getSource();
            }
            return object;
        }
    }

    public static class Requirement {
        public static boolean canUseCommandString(@NotNull class_3222 player, @NotNull String commandString) {
            class_2168 commandSource = Source.getCommandSource(player);
            ParseResults parseResults = CommandHelper.getCommandDispatcher().parse(commandString, (Object)commandSource);
            CommandContextBuilder context = parseResults.getContext();
            if (!parseResults.getExceptions().isEmpty()) {
                return false;
            }
            List nodes = context.getNodes();
            if (nodes.isEmpty()) {
                return false;
            }
            return nodes.stream().map(ParsedCommandNode::getNode).allMatch(it -> it.canUse((Object)commandSource));
        }

        public static boolean isOperator(@NotNull class_1657 player) {
            class_11560 profile = GameProfileWrapper.of(player).toVanillaType().orElseThrow();
            return PlayerHelper.getPlayerManager().method_14569(profile);
        }

        public static boolean isAdmin(@NotNull class_3222 player) {
            class_2168 commandSource = Source.getCommandSource(player);
            return Requirement.isAdmin(commandSource);
        }

        public static boolean isAdmin(@NotNull class_2168 source) {
            return source.method_9259(4);
        }

        public static int getPermissionLevel(@NotNull GameProfile gameProfile) {
            class_11560 vanillaType = GameProfileWrapper.fromVanillaType(gameProfile).toVanillaType().orElseThrow();
            return ServerHelper.getServer().method_3835(vanillaType);
        }
    }

    public static class Tree {
        @NotNull
        public static List<List<RegisteredCommandNode>> findCommandTree(@NotNull CommandNode<class_2168> navigationNode) {
            ArrayList<List<RegisteredCommandNode>> treeCollector = new ArrayList<List<RegisteredCommandNode>>();
            ArrayList<RegisteredCommandNode> branchCollector = new ArrayList<RegisteredCommandNode>();
            treeCollector.add(branchCollector);
            RootCommandNode<class_2168> root = Tree.getRootCommandNode();
            Tree.findCommandTreeRecursively(treeCollector, branchCollector, navigationNode, root);
            return treeCollector;
        }

        private static void findCommandTreeRecursively(@NotNull List<List<RegisteredCommandNode>> treeCollector, @NotNull List<RegisteredCommandNode> branchCollector, @NotNull CommandNode<class_2168> navigationNode, @NotNull CommandNode<class_2168> walkingNode) {
            CommandNode<class_2168> parent = walkingNode;
            Optional.ofNullable(parent.getChild(navigationNode.getName())).ifPresent(child -> {
                RegisteredCommandNode found = new RegisteredCommandNode(parent, (CommandNode<class_2168>)child);
                branchCollector.add(found);
                Collection children = navigationNode.getChildren();
                children.forEach(newNavigationNode -> {
                    if (children.size() == 1) {
                        Tree.findCommandTreeRecursively(treeCollector, branchCollector, (CommandNode<class_2168>)newNavigationNode, (CommandNode<class_2168>)child);
                    } else {
                        ArrayList<RegisteredCommandNode> forkedCollector = new ArrayList<RegisteredCommandNode>(branchCollector);
                        treeCollector.add(forkedCollector);
                        Tree.findCommandTreeRecursively(treeCollector, forkedCollector, (CommandNode<class_2168>)newNavigationNode, (CommandNode<class_2168>)child);
                    }
                });
            });
        }

        public static void removeCommandTree(@NotNull RegisteredCommandNode registeredCommandNode) {
            CommandNodeExtension parentNode = (CommandNodeExtension)registeredCommandNode.getParent();
            CommandNode<class_2168> childNode = registeredCommandNode.getNode();
            parentNode.fuji$getChildren().values().removeIf(it -> it.getName().equals(childNode.getName()));
            parentNode.fuji$getLiterals().values().removeIf(it -> it.getName().equals(childNode.getName()));
            parentNode.fuji$getArguments().values().removeIf(it -> it.getName().equals(childNode.getName()));
        }

        public static void updateCommandTree() {
            @NotNull class_2170 commandManager = ServerHelper.getServer().method_3734();
            Tree.updateCommandTree(commandManager);
        }

        public static void updateCommandTree(@NotNull class_2170 commandManager) {
            ServerHelper.Lifecycle.withServerInstantiated(() -> PlayerHelper.Lookup.getOnlinePlayers().forEach(arg_0 -> ((class_2170)commandManager).method_9241(arg_0)));
        }

        public static RootCommandNode<class_2168> getRootCommandNode() {
            return CommandHelper.getCommandDispatcher().getRoot();
        }

        public static Optional<CommandNode<class_2168>> findCommandNode(@NotNull List<String> commandNodePath) {
            return Optional.ofNullable(CommandHelper.getCommandDispatcher().findNode(commandNodePath));
        }

        public static Optional<CommandNode<class_2168>> findCommandNode(@NotNull String commandPath) {
            List<String> splitCommandPath = Path.splitCommandPath(commandPath);
            return Tree.findCommandNode(splitCommandPath);
        }

        @NotNull
        public static String findCommandNodePathString(@NotNull CommandNode<class_2168> leafNode) {
            List<String> nodes = Tree.findCommandNodePathList(leafNode);
            return Path.joinCommandPath(nodes);
        }

        @NotNull
        private static List<String> findCommandNodePathList(@NotNull CommandNode<class_2168> leafNode) {
            CommandDispatcher<class_2168> dispatcher = CommandHelper.getCommandDispatcher();
            return new ArrayList<String>(dispatcher.getPath(leafNode));
        }

        public static List<CommandNode<class_2168>> getAllCommandNodes() {
            ArrayList<CommandNode<class_2168>> result = new ArrayList<CommandNode<class_2168>>();
            RootCommandNode root = CommandHelper.getCommandDispatcher().getRoot();
            Tree.collectCommandNodes(result, (CommandNode<class_2168>)root);
            return result;
        }

        private static void collectCommandNodes(@NotNull List<CommandNode<class_2168>> collector, @NotNull CommandNode<class_2168> parent) {
            parent.getChildren().forEach(it -> Tree.collectCommandNodes(collector, (CommandNode<class_2168>)it));
            if (!Node.isRootCommandNode(parent)) {
                collector.add(parent);
            }
        }

        public static void replaceChild(CommandNode<class_2168> parent, CommandNode<class_2168> node) {
            if (node instanceof RootCommandNode) {
                throw new UnsupportedOperationException("Cannot add a RootCommandNode as a child to any other CommandNode");
            }
            CommandNodeExtension parentExtension = (CommandNodeExtension)parent;
            Map parentChildren = parentExtension.fuji$getChildren();
            CommandNode child = parentChildren.get(node.getName());
            if (child != null) {
                CommandNodeExtension childExtension = (CommandNodeExtension)child;
                if (node.getCommand() != null) {
                    childExtension.fuji$setCommand(node.getCommand());
                }
                if (node.getRedirect() != null) {
                    childExtension.fuji$setRedirect(node.getRedirect());
                }
                if (node.getRequirement() != null) {
                    childExtension.fuji$setRequirement(node.getRequirement());
                }
                for (CommandNode grandchild : node.getChildren()) {
                    Tree.replaceChild(child, (CommandNode<class_2168>)grandchild);
                }
            } else {
                Tree.setMappings(parent, node);
            }
        }

        private static void setMappings(@NotNull CommandNode<class_2168> parent, @NotNull CommandNode<class_2168> node) {
            CommandNodeExtension parentExtension = (CommandNodeExtension)parent;
            Map parentChildren = parentExtension.fuji$getChildren();
            Map parentLiterals = parentExtension.fuji$getLiterals();
            Map parentArguments = parentExtension.fuji$getArguments();
            parentChildren.put(node.getName(), node);
            if (node instanceof LiteralCommandNode) {
                parentLiterals.put(node.getName(), (LiteralCommandNode)node);
            } else if (node instanceof ArgumentCommandNode) {
                parentArguments.put(node.getName(), (ArgumentCommandNode)node);
            }
        }

        public static boolean isCommandNodeRegistered(@NotNull CommandNode<class_2168> navigationNode) {
            if (!Path.isLinearCommandPath(navigationNode)) {
                LogUtil.warn("There are forks in the given command node: {}", Path.toLinearCommandPathList(navigationNode));
                return false;
            }
            RootCommandNode<class_2168> rootNode = Tree.getRootCommandNode();
            @Nullable CommandNode walkingNode = rootNode.getChild(navigationNode.getName());
            if (walkingNode == null) {
                return false;
            }
            return Tree.isCommandNodeRegisteredRecursively(navigationNode, (CommandNode<class_2168>)walkingNode);
        }

        @TestCase(action="Test the functionality of command override detection.", targets={"Create the new command `/home tp -> /say` (with redirect) using `command_alias` module, you should see the override warning.", "Create the new command `/home tp -> /say` (without redirect) using `command_bundle` module, you should NOT see the override warning.", "Create the new command `/workbench -> /say` (not nested) using `command_alias` module, you should see the override warning."})
        private static boolean isCommandNodeRegisteredRecursively(@NotNull CommandNode<class_2168> navigationNode, @Nullable CommandNode<class_2168> walkingNode) {
            if (walkingNode == null) {
                return false;
            }
            Collection navigationNodeChildren = navigationNode.getChildren();
            if (navigationNodeChildren.isEmpty()) {
                if (Node.isExecutableOrRedirectCommandNode(walkingNode)) {
                    return true;
                }
                return navigationNode.getRedirect() != null;
            }
            boolean treeValue = false;
            for (CommandNode navigationNodeChild : navigationNodeChildren) {
                CommandNode walkingNodeChild;
                boolean branchValue = Tree.isCommandNodeRegisteredRecursively((CommandNode<class_2168>)navigationNodeChild, (CommandNode<class_2168>)(walkingNodeChild = walkingNode.getChild(navigationNodeChild.getName())));
                if (!branchValue) continue;
                treeValue = true;
                return treeValue;
            }
            return treeValue;
        }
    }

    public static class Node {
        private static boolean isRootCommandNode(@NotNull CommandNode<class_2168> node) {
            return node.getName().isEmpty() || node instanceof RootCommandNode;
        }

        @NotNull
        public static String toCommandNodeTypeString(@NotNull CommandNode<class_2168> node) {
            if (node instanceof LiteralCommandNode) {
                return "LiteralCommandNode";
            }
            if (node instanceof ArgumentCommandNode) {
                return "ArgumentCommandNode";
            }
            if (node instanceof RootCommandNode) {
                return "RootCommandNode";
            }
            return "UnknownType";
        }

        public static boolean isExecutableCommandNode(@NotNull CommandNode<class_2168> node) {
            return node.getCommand() != null;
        }

        public static boolean isRedirectCommandNode(@NotNull CommandNode<class_2168> node) {
            return node.getRedirect() != null;
        }

        public static boolean isExecutableOrRedirectCommandNode(@NotNull CommandNode<class_2168> node) {
            return Node.isExecutableCommandNode(node) || Node.isRedirectCommandNode(node);
        }
    }

    public static class Path {
        public static boolean isLinearCommandPath(@NotNull CommandNode<class_2168> navigationNode) {
            return Path.toLinearCommandPathList(navigationNode).isPresent();
        }

        public static Optional<List<String>> toLinearCommandPathList(@NotNull CommandNode<class_2168> navigationNode) {
            ArrayList<String> names;
            block1: {
                names = new ArrayList<String>();
                CommandNode current = navigationNode;
                while (true) {
                    names.add(current.getName());
                    ArrayList children = new ArrayList(current.getChildren());
                    if (children.isEmpty()) break block1;
                    if (children.size() != 1) break;
                    current = (CommandNode)children.get(0);
                }
                return Optional.empty();
            }
            return Optional.of(names);
        }

        public static Optional<String> toLinearCommandPathString(@NotNull CommandNode<class_2168> navigationNode) {
            return Path.toLinearCommandPathList(navigationNode).map(Path::joinCommandPath);
        }

        @NotNull
        public static String toLinearCommandPathString(@NotNull List<CommandNode<class_2168>> nodes) {
            return nodes.stream().map(CommandNode::getName).collect(Collectors.joining("."));
        }

        @NotNull
        public static String toFlatCommandPathString(@NotNull CommandNode<class_2168> navigationNode) {
            StringBuilder flatCommandPath = new StringBuilder();
            flatCommandPath.append(navigationNode.getName());
            navigationNode.getChildren().forEach(child -> flatCommandPath.append(".").append(Path.toFlatCommandPathString((CommandNode<class_2168>)child)));
            return flatCommandPath.toString();
        }

        @NotNull
        public static String joinCommandPath(@NotNull List<String> nodes) {
            return String.join((CharSequence)".", nodes);
        }

        @NotNull
        public static String trimCommandPathString(@NotNull String path) {
            return StringUtils.strip((String)path, (String)".");
        }

        @NotNull
        public static List<String> getPrefixesOfCommandPath(@NotNull List<ParsedCommandNode<class_2168>> nodes) {
            ArrayList<String> prefixes = new ArrayList<String>();
            Object walkingPath = "";
            for (ParsedCommandNode<class_2168> node : nodes) {
                String currentNodeName = node.getNode().getName();
                walkingPath = (String)walkingPath + "." + currentNodeName;
                walkingPath = Path.trimCommandPathString((String)walkingPath);
                prefixes.add((String)walkingPath);
            }
            return prefixes;
        }

        @NotNull
        private static List<String> splitCommandPath(@NotNull String commandPath) {
            String[] nodeNames = commandPath.split("\\.", -1);
            return Arrays.asList(nodeNames);
        }
    }
}

