/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.auxiliary.minecraft;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import mod.fuji.core.auxiliary.minecraft.PlayerHelper;
import mod.fuji.core.auxiliary.minecraft.RegistryHelper;
import mod.fuji.core.auxiliary.minecraft.ServerHelper;
import mod.fuji.core.service.random_teleport.searcher.PositionYTopDownSearcher;
import mod.fuji.core.structure.GlobalPos;
import net.minecraft.class_1297;
import net.minecraft.class_1675;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2791;
import net.minecraft.class_3193;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3898;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4076;
import net.minecraft.class_5217;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7134;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorldHelper {
    public static int getTopY(@NotNull class_2791 chunk) {
        return chunk.method_31600();
    }

    public static int getBottomYInclusive(@NotNull class_2791 chunk) {
        return chunk.method_31607();
    }

    public static int getTopY(@NotNull class_1937 world) {
        return world.method_31600();
    }

    public static class_243 toBottomCenterPos(class_2338 pos) {
        return class_243.method_49273((class_2382)pos, (double)0.5, (double)0.0, (double)0.5);
    }

    public static double squareDistance(@NotNull class_243 vec3d, double x2, double y2, double z2) {
        return WorldHelper.squareDistance(vec3d.method_10216(), vec3d.method_10214(), vec3d.method_10215(), x2, y2, z2);
    }

    public static double squareDistance(double x1, double y1, double z1, double x2, double y2, double z2) {
        double dx = x1 - x2;
        double dy = y1 - y2;
        double dz = z1 - z2;
        return dx * dx + dy * dy + dz * dz;
    }

    public static class_1792 toGuiItem(String dimension) {
        if (dimension.equals(class_7134.field_37670.toString())) {
            return class_1802.field_8270;
        }
        if (dimension.equals(class_7134.field_37672.toString())) {
            return class_1802.field_20399;
        }
        if (dimension.equals(class_7134.field_37671.toString())) {
            return class_1802.field_8328;
        }
        return class_1802.field_8634;
    }

    public static Collection<class_3218> getWorlds() {
        return ServerHelper.getServer().field_4589.values();
    }

    public static Optional<class_3218> getWorld(@Nullable String dimensionId) {
        return WorldHelper.getWorlds().stream().filter(it -> RegistryHelper.getIdAsString((class_1937)it).equals(dimensionId)).findFirst();
    }

    public static Optional<class_3218> getWorld(@NotNull class_5321<class_1937> dimensionKey) {
        String idAsString = RegistryHelper.getIdAsString(dimensionKey);
        return WorldHelper.getWorld(idAsString);
    }

    @NotNull
    public static class_3218 getWorldOrThrow(@NotNull String dimensionId) {
        return WorldHelper.getWorld(dimensionId).orElseThrow(() -> new IllegalStateException("Dimension %s not found.".formatted(dimensionId)));
    }

    public static boolean isServerWorld(@Nullable class_1937 world) {
        if (world == null) {
            return false;
        }
        return world instanceof class_3218;
    }

    public static class_3898 getChunkStorage(class_3218 world) {
        return world.method_14178().field_17254;
    }

    @NotNull
    public static class_1923 makeChunkPos(@NotNull class_2338 blockPos) {
        return WorldHelper.makeChunkPos(blockPos.method_10263(), blockPos.method_10260());
    }

    @NotNull
    public static class_1923 makeChunkPos(int blockPosX, int blockPosZ) {
        return new class_1923(blockPosX >> 4, blockPosZ >> 4);
    }

    @NotNull
    public static Iterable<class_3193> getChunks(@NotNull class_3218 world) {
        class_3898 chunkLoadingManager = WorldHelper.getChunkStorage(world);
        ObjectCollection iterable = chunkLoadingManager.field_17220.values();
        return Iterables.unmodifiableIterable((Iterable)iterable);
    }

    @NotNull
    public static List<class_1297> getEntities(@NotNull class_3218 world) {
        ArrayList snapshot = Lists.newArrayList((Iterable)world.method_27909());
        return snapshot;
    }

    public static int getMaxBlockY(@NotNull class_2791 chunk) {
        int i = chunk.method_12040();
        if (i == -1) {
            return WorldHelper.getTopY(chunk);
        }
        int blockCoord = class_4076.method_18688((int)chunk.method_31604(i));
        return blockCoord + 15;
    }

    @NotNull
    public static String getBiomeId(@NotNull class_3218 world, @NotNull class_2338 blockPos) {
        class_6880 biome = world.method_23753(blockPos);
        return biome.method_40230().map(RegistryHelper::getIdAsString).orElse("[UnknownBiome]");
    }

    @NotNull
    public static GlobalPos findSafeTopY(@NotNull class_1937 world, @NotNull class_2338 blockPos) {
        class_2791 chunk = world.method_22350(blockPos);
        int resultY = new PositionYTopDownSearcher().search(chunk, blockPos.method_10263(), blockPos.method_10260()).orElseGet(() -> ((class_2338)blockPos).method_10264());
        return GlobalPos.of(world, blockPos).withY(resultY);
    }

    public static class Raycast {
        private static final double PLAYER_INTERACTION_DISTANCE = 5.0;

        public static Optional<class_2338> getLookingAtBlock(@NotNull class_3222 player) {
            return Raycast.getLookingAtBlock(player, 5.0);
        }

        public static Optional<class_2338> getLookingAtBlock(@NotNull class_3222 player, double maxDistance) {
            class_243 eyePos = player.method_5836(1.0f);
            class_243 lookVec = player.method_5828(1.0f);
            class_243 reachVec = eyePos.method_1019(lookVec.method_1021(maxDistance));
            class_3218 serverWorld = PlayerHelper.getServerWorld(player);
            class_3965 blockHitResult = serverWorld.method_17742(new class_3959(eyePos, reachVec, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)player));
            if (blockHitResult.method_17783() == class_239.class_240.field_1332) {
                return Optional.ofNullable(blockHitResult.method_17777());
            }
            return Optional.empty();
        }

        public static Optional<class_1297> getLookingAtEntity(@NotNull class_3222 player) {
            return Raycast.getLookingAtEntity(player, 5.0);
        }

        public static Optional<class_1297> getLookingAtEntity(@NotNull class_3222 player, double maxDistance) {
            class_238 box;
            class_243 direction;
            class_243 end;
            class_243 start = player.method_5836(1.0f);
            class_3966 entityHitResult = class_1675.method_18075((class_1297)player, (class_243)start, (class_243)(end = start.method_1019((direction = player.method_5828(1.0f)).method_1021(maxDistance))), (class_238)(box = player.method_5829().method_18804(direction.method_1021(maxDistance)).method_1009(1.0, 1.0, 1.0)), entity -> !entity.method_7325() && entity.method_5732() && entity != player, (double)(maxDistance * maxDistance));
            if (entityHitResult != null) {
                return Optional.ofNullable(entityHitResult.method_17782());
            }
            return Optional.empty();
        }
    }

    public static class Formatter {
        @NotNull
        public static String format(@NotNull class_2338 blockPos) {
            return "%d %d %d".formatted(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
        }
    }

    public static class SpawnPos {
        @NotNull
        public static GlobalPos getServerSpawnPos() {
            @NotNull class_3218 overworld = ServerHelper.getServer().method_30002();
            @NotNull class_2338 spawnPos = overworld.method_74854().method_74897();
            return GlobalPos.of((class_1937)overworld, spawnPos);
        }

        @NotNull
        public static GlobalPos getSafeServerSpawnPos() {
            GlobalPos serverSpawnPos = SpawnPos.getServerSpawnPos();
            GlobalPos safeSpawnPos = new GlobalPos(serverSpawnPos.getLevel(), serverSpawnPos.getX() + 0.5, serverSpawnPos.getY() + 0.5, serverSpawnPos.getZ() + 0.5, 0.0f, 0.0f);
            @NotNull class_3218 serverWorld = WorldHelper.getWorldOrThrow(safeSpawnPos.getLevel());
            @NotNull class_2338 blockPos = safeSpawnPos.toBlockPos();
            safeSpawnPos = WorldHelper.findSafeTopY((class_1937)serverWorld, blockPos);
            return safeSpawnPos;
        }

        public static Optional<GlobalPos> getPlayerSpawnPos(@NotNull class_3222 player) {
            return Optional.ofNullable(player.method_67564()).map(respawn -> {
                class_5217.class_12064 spawnPoint = respawn.comp_4913();
                class_5321 dimension = spawnPoint.method_74894();
                class_2338 blockPos = spawnPoint.method_74897();
                return Optional.of(GlobalPos.of((class_5321<class_1937>)dimension, blockPos));
            }).orElse(Optional.empty());
        }
    }
}

