/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.command_meta.when_online;

import java.util.List;
import java.util.Optional;
import mod.fuji.core.annotation.Unused;
import mod.fuji.core.auxiliary.LogUtil;
import mod.fuji.core.auxiliary.minecraft.PlayerHelper;
import mod.fuji.core.command.annotation.CommandNode;
import mod.fuji.core.command.annotation.CommandRequirement;
import mod.fuji.core.command.annotation.CommandSource;
import mod.fuji.core.command.argument.wrapper.impl.GreedyCommandString;
import mod.fuji.core.command.argument.wrapper.impl.OfflinePlayerName;
import mod.fuji.core.command.executor.CommandExecutor;
import mod.fuji.core.command.executor.structure.ExtendedCommandSource;
import mod.fuji.core.config.handler.abst.BaseConfigurationHandler;
import mod.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import mod.fuji.core.document.annotation.Document;
import mod.fuji.core.event.annotation.EventConsumer;
import mod.fuji.core.event.message.player.PlayerJoinedEvent;
import mod.fuji.module.initializer.ModuleInitializer;
import mod.fuji.module.initializer.command_meta.when_online.config.model.WhenOnlineDataModel;
import mod.fuji.module.initializer.command_meta.when_online.gui.ListWhenOnlineTicketsGui;
import mod.fuji.module.initializer.command_meta.when_online.structure.WhenOnlineTicket;
import net.minecraft.class_2168;
import net.minecraft.class_3222;

@Document(id=1751824024333L, value="This module provides the `/when-online \\<player\\> \\<cmd\\>` command.\nTo execute a specified command `exactly once` when the target player is `online`:\n1. If the target player is `online` now, the command will be executed `at once`.\n2. If the target player is `offline` now, the command will be executed `when the player online`.\n\nBesides, you use `/when-online list` to manage `submitted commands`.\n\nFor example:\n1. `/when-online Steve give %player:name% minecraft:apple 3`\n2. `/when-online Alex delay 8 say Hi %player:name%`\n")
public class WhenOnlineInitializer
extends ModuleInitializer {
    public static BaseConfigurationHandler<WhenOnlineDataModel> data = ObjectConfigurationHandler.ofModule("when-online-data.json", WhenOnlineDataModel.class);

    @Document(id=1755412463665L, value="Execute the specified command `exactly once`, when the target player `is online`.")
    @CommandNode(value="when-online")
    @CommandRequirement(level=4)
    private static int $whenOnline(@CommandSource class_2168 source, OfflinePlayerName targetPlayer, GreedyCommandString command) {
        String $creatorName = source.method_9214();
        String $targetPlayerName = (String)targetPlayer.getValue();
        String $command = (String)command.getValue();
        WhenOnlineTicket ticket = WhenOnlineTicket.make($creatorName, $targetPlayerName, $command);
        WhenOnlineInitializer.data.model().tickets.add(ticket);
        data.writeStorage();
        WhenOnlineInitializer.processWhenOnlineTickets();
        return 1;
    }

    @Document(id=1755412352252L, value="An alias command for `/when-online list` command.")
    @CommandNode(value="when-online")
    @CommandRequirement(level=4)
    private static int $root(@CommandSource class_3222 player) {
        return WhenOnlineInitializer.$list(player);
    }

    @Document(id=1755412381305L, value="List all submitted `when-online` tickets.")
    @CommandNode(value="when-online list")
    @CommandRequirement(level=4)
    private static int $list(@CommandSource class_3222 player) {
        ListWhenOnlineTicketsGui.make(player).open();
        return 1;
    }

    @EventConsumer
    private static void processWhenOnlineTickets(@Unused PlayerJoinedEvent event) {
        WhenOnlineInitializer.processWhenOnlineTickets();
    }

    private static void processWhenOnlineTickets() {
        List<String> onlinePlayerNames = PlayerHelper.Lookup.getOnlinePlayerNames();
        WhenOnlineInitializer.data.model().tickets.stream().toList().stream().filter(ticket -> ticket.executedTimestamp == null && onlinePlayerNames.contains(ticket.targetPlayer)).forEach(ticket -> {
            LogUtil.debug("Execute the ticket: {}", ticket);
            ticket.executedTimestamp = System.currentTimeMillis();
            Optional<class_3222> onlinePlayer = PlayerHelper.Lookup.getOnlinePlayerByName(ticket.targetPlayer);
            onlinePlayer.ifPresentOrElse($onlinePlayer -> {
                ExtendedCommandSource extendedCommandSource = ExtendedCommandSource.asConsole($onlinePlayer.method_64396());
                String commandString = ticket.command;
                CommandExecutor.executeSingle(extendedCommandSource, commandString);
            }, () -> LogUtil.warn("Failed to execute the when-online ticket, the online player is null.", ticket));
        });
        data.writeStorage();
    }
}

