/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.multiplier;

import java.util.Optional;
import mod.fuji.core.auxiliary.minecraft.LuckpermsHelper;
import mod.fuji.core.auxiliary.minecraft.RegistryHelper;
import mod.fuji.core.document.annotation.ColorBox;
import mod.fuji.core.document.annotation.DocStringProvider;
import mod.fuji.core.document.annotation.Document;
import mod.fuji.core.document.annotation.TestCase;
import mod.fuji.core.document.descriptor.MetaDescriptor;
import mod.fuji.core.event.annotation.EventConsumer;
import mod.fuji.core.event.message.player.PlayerDamageEvent;
import mod.fuji.module.initializer.ModuleInitializer;
import net.minecraft.class_1282;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

@Document(id=1751978330624L, value="This module allows you to `multiply` some `numeric values` in vanilla Minecraft.\n\nNow supported `numeric types`:\n1. `damage`: The damage to a player.\n2. `experience`: The gained experience of a player.\n")
@ColorBox(id=1751978406823L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 Double the damage from `zombie` to a player.\nIssue: `/lp group default meta set fuji.multiplier.damage.minecraft:zombie 2`\n\n\u25c9 Cancel the `fall damage` to a player.\nIssue: `/lp group default meta set fuji.multiplier.damage.minecraft:fall 0`\n\n\u25c9 Double `all` damages to a player.\nIssue: `/lp group default meta set fuji.multiplier.damage.all 2`\n\n\u25c9 Half `all` damages to a player.\nIssue: `/lp group default meta set fuji.multiplier.damage.all 0.5`\n\n\u25c9 Double all experience a player gained.\nIssue: `/lp group default meta set fuji.multiplier.experience.all 2`\n")
public class MultiplierInitializer
extends ModuleInitializer {
    @DocStringProvider(id=1752000356004L, value="Specify the `multiply factor` for a specified `type` for this player.\n")
    public static final MetaDescriptor<Float> MULTIPLIER_META = new MetaDescriptor<Float>("fuji.multiplier.<multiplier-type>.<id>", Float::valueOf, 1752000356004L);

    @TestCase(action="Summon a fake player using `/player 1 spawn` and throw exp bottle to it.", targets={"Test the compatibility between `luckperms` and `carpet`'s fake player."})
    public static float transform(@NotNull class_3222 player, String type, String key, float f) {
        Optional<Float> meta = LuckpermsHelper.getMeta(player.method_5667(), MULTIPLIER_META, type, key);
        return meta.map(factor -> Float.valueOf(f * factor.floatValue())).orElse(Float.valueOf(f)).floatValue();
    }

    @EventConsumer
    private static void multiplyDamageValue(PlayerDamageEvent event) {
        class_3222 player = event.getPlayer();
        float damage = event.getDamage();
        damage = MultiplierInitializer.transform(player, "damage", "all", damage);
        class_1282 damageSource = event.getDamageSource();
        damage = MultiplierInitializer.transform(player, "damage", RegistryHelper.getIdAsString(damageSource.method_48793()), damage);
        event.setDamage(damage);
    }
}

