/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.works.job;

import java.util.HashSet;
import java.util.function.Supplier;
import lombok.Generated;
import mod.fuji.core.annotation.Unused;
import mod.fuji.core.document.annotation.Document;
import mod.fuji.core.event.annotation.EventConsumer;
import mod.fuji.core.event.message.server.lifecycle.ServerStartedEvent;
import mod.fuji.core.job.JobManager;
import mod.fuji.core.job.abst.CronJob;
import mod.fuji.core.job.interfaces.Schedulable;
import mod.fuji.module.initializer.works.structure.WorksBinding;
import org.jetbrains.annotations.NotNull;
import org.quartz.JobExecutionContext;

@Document(id=1751825531415L, value="This `job` is used to dispatch the `onSchedule` event for each `work`.\n\nFor example:\n1. To end the sample of a `production work`.\n")
public class WorksOnScheduleDispatcherJob
extends CronJob {
    private WorksOnScheduleDispatcherJob(Supplier<String> cronSupplier) {
        super(cronSupplier);
    }

    public static WorksOnScheduleDispatcherJob makeInstance() {
        return new WorksOnScheduleDispatcherJob(() -> "0/5 * * ? * * *");
    }

    @EventConsumer
    private static void scheduleWorksOnScheduleDispatcherJob(@Unused ServerStartedEvent event) {
        WorksOnScheduleDispatcherJob job = WorksOnScheduleDispatcherJob.makeInstance();
        JobManager.addJob(job);
    }

    public void execute(@NotNull JobExecutionContext context) {
        HashSet uniqueWorks = new HashSet();
        WorksBinding.BLOCK_POS_2_WORKS.values().forEach(uniqueWorks::addAll);
        WorksBinding.ENTITY_2_WORKS.values().forEach(uniqueWorks::addAll);
        uniqueWorks.forEach(it -> {
            if (it instanceof Schedulable) {
                Schedulable schedulable = (Schedulable)((Object)it);
                schedulable.onSchedule();
            }
        });
    }

    @Generated
    public WorksOnScheduleDispatcherJob() {
    }
}

