/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.command_cooldown.service;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import mod.fuji.core.command.executor.CommandExecutor;
import mod.fuji.core.command.executor.structure.ExtendedCommandSource;
import mod.fuji.module.initializer.command_cooldown.CommandCooldownInitializer;
import mod.fuji.module.initializer.command_cooldown.structure.NamedCooldownDataNode;
import mod.fuji.module.initializer.command_cooldown.structure.NamedCooldownDescriptor;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class NamedCooldownService {
    public static Map<String, NamedCooldownDescriptor> getNamedCooldownDescriptors() {
        return CommandCooldownInitializer.config.model().getNamedCooldown().getList();
    }

    public static Optional<NamedCooldownDescriptor> findNamedCooldownDescriptor(@NotNull String id) {
        return NamedCooldownService.getNamedCooldownDescriptors().entrySet().stream().filter(it -> ((String)it.getKey()).equals(id)).findFirst().map(Map.Entry::getValue);
    }

    public static void createNamedCooldownDescriptor(@NotNull String name, long cooldownDuration, int maxUses, boolean persistent, boolean global) {
        NamedCooldownDescriptor namedCooldownDescriptor = NamedCooldownDescriptor.make(name, cooldownDuration, maxUses, persistent, global);
        NamedCooldownService.getNamedCooldownDescriptors().put(name, namedCooldownDescriptor);
        CommandCooldownInitializer.config.writeStorage();
    }

    public static void deleteNamedCooldownDescriptor(@NotNull NamedCooldownDescriptor descriptor) {
        NamedCooldownService.getNamedCooldownDescriptors().remove(descriptor.getName());
        CommandCooldownInitializer.config.writeStorage();
    }

    public static <T> T withNamedCooldownDataNode(@NotNull NamedCooldownDescriptor namedCooldownDescriptor, @NotNull Function<NamedCooldownDataNode, T> function) {
        Optional<NamedCooldownDataNode> first = NamedCooldownService.getNamedCooldownNodes().stream().filter(it -> it.getId().equals(namedCooldownDescriptor.getName())).findFirst();
        NamedCooldownDataNode namedCooldownDataNode = first.orElseGet(() -> {
            NamedCooldownDataNode newValue = new NamedCooldownDataNode();
            newValue.setId(namedCooldownDescriptor.getName());
            NamedCooldownService.getNamedCooldownNodes().add(newValue);
            return newValue;
        });
        namedCooldownDataNode.setDescriptor(namedCooldownDescriptor);
        return function.apply(namedCooldownDataNode);
    }

    private static List<NamedCooldownDataNode> getNamedCooldownNodes() {
        return CommandCooldownInitializer.namedCooldownData.model().getNodes();
    }

    public static int testNamedCooldown(@NotNull NamedCooldownDescriptor descriptor, @NotNull class_3222 player, @NotNull List<String> onSuccessCommands, @NotNull List<String> onFailureCommands) {
        String key = NamedCooldownDataNode.toKey(player);
        return NamedCooldownService.withNamedCooldownDataNode(descriptor, dataNode -> {
            long remainingDuration = dataNode.tryUse(key, descriptor.getCooldownDuration());
            int uses = dataNode.getUses().computeIfAbsent(key, k -> 0);
            int availableUses = descriptor.getMaxUses() - uses;
            if (remainingDuration > 0L || availableUses <= 0) {
                CommandExecutor.executeBatch(ExtendedCommandSource.asConsole(player.method_5671()), onFailureCommands);
                return 0;
            }
            dataNode.getUses().compute(key, (k, v) -> v == null ? 1 : v + 1);
            CommandCooldownInitializer.config.writeStorage();
            CommandExecutor.executeBatch(ExtendedCommandSource.asConsole(player.method_5671()), onSuccessCommands);
            return 1;
        });
    }

    public static void resetNamedCooldownDuration(@NotNull NamedCooldownDescriptor descriptor, @NotNull String key) {
        NamedCooldownService.withNamedCooldownDataNode(descriptor, dataNode -> {
            dataNode.getCooldown().getTimestamp().put(key, 0L);
            return null;
        });
    }
}

