/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.world.gamerule;

import it.unimi.dsi.fastutil.objects.Reference2BooleanMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import java.util.List;
import java.util.Optional;
import mod.fuji.core.config.handler.abst.BaseConfigurationHandler;
import mod.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import mod.fuji.core.config.mapper.GsonMapper;
import mod.fuji.core.document.annotation.ColorBox;
import mod.fuji.core.document.annotation.ColorBoxes;
import mod.fuji.core.document.annotation.Document;
import mod.fuji.module.initializer.ModuleInitializer;
import mod.fuji.module.initializer.world.gamerule.config.adapter.BooleanGameRuleMapAdapter;
import mod.fuji.module.initializer.world.gamerule.config.adapter.IntegerGameRuleMapAdapter;
import mod.fuji.module.initializer.world.gamerule.config.model.WorldGameRuleConfigModel;
import mod.fuji.module.initializer.world.gamerule.structure.GameRuleDescriptor;
import net.minecraft.class_1928;

@Document(id=1752577892546L, value="This module allows you to customize the `per-dimension gamerule`.\n")
@ColorBoxes(value={@ColorBox(id=1753064698840L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 How it works?\nIn internal Minecraft, each `dimension` has a function named `getGameRules()`.\nIt returns the `gamerules` of this `dimension`.\n\nThe vanilla Minecraft only returns the `gamerules` of `minecraft:overworld`.\nFuji modify the `getGameRules()` function, to let it return the `per-dimension gamerules`.\n\n\u25c9 How can I configure the `per-dimension gamerules`?\nYou can modify the config file directly, and issue `/fuji reload` to apply changes.\n\n\u25c9 Can I use this module in vanilla dimensions?\nYes, you can.\n"), @ColorBox(id=1752292508145L, color=ColorBox.ColorBoxTypes.TIP, value="\u25c9 The logic of `/gamerule` command.\nThe `/gamerule` command `only` operates on `minecraft:overworld` dimension.\n\nTo see the `true info` of `a specified dimension`, you should use `/world info` command.\n\n\u25c9 Set the `per-dimension gamerules` using commands.\nYou can install the `WorldGameRules` mod to provide such commands.\nSee https://github.com/DrexHD/WorldGameRules\n")})
public class WorldGameRuleInitializer
extends ModuleInitializer {
    private static final BaseConfigurationHandler<WorldGameRuleConfigModel> config = ObjectConfigurationHandler.ofModule("config.json", WorldGameRuleConfigModel.class);

    public static Optional<GameRuleDescriptor> getEffectiveGameRuleDescriptor(String dimensionId) {
        List<GameRuleDescriptor> gameRules = WorldGameRuleInitializer.config.model().gameRules;
        for (GameRuleDescriptor gr : gameRules) {
            if (!gr.enable || !gr.dimensionId.equals(dimensionId)) continue;
            return Optional.of(gr);
        }
        return Optional.empty();
    }

    public static class_1928 getEffectiveGameRules(String dimensionId, class_1928 original) {
        Optional<GameRuleDescriptor> gameRuleDescriptorOpt = WorldGameRuleInitializer.getEffectiveGameRuleDescriptor(dimensionId);
        if (gameRuleDescriptorOpt.isPresent()) {
            return gameRuleDescriptorOpt.get().asVanillaGameRules();
        }
        return original;
    }

    @Override
    protected void registerGsonTypeAdapters() {
        GsonMapper.registerGsonTypeAdapter(Reference2BooleanMap.class, new BooleanGameRuleMapAdapter());
        GsonMapper.registerGsonTypeAdapter(Reference2IntMap.class, new IntegerGameRuleMapAdapter());
    }
}

